/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;

@InterfaceAudience.Private
public class MetricsRegionServerSourceImpl
extends BaseSourceImpl
implements MetricsRegionServerSource {
    final MetricsRegionServerWrapper rsWrap;
    private final MetricHistogram putHisto;
    private final MetricHistogram deleteHisto;
    private final MetricHistogram getHisto;
    private final MetricHistogram incrementHisto;
    private final MetricHistogram appendHisto;
    private final MetricHistogram replayHisto;
    private final MetricHistogram scanSizeHisto;
    private final MetricHistogram scanTimeHisto;
    private final MutableFastCounter slowPut;
    private final MutableFastCounter slowDelete;
    private final MutableFastCounter slowGet;
    private final MutableFastCounter slowIncrement;
    private final MutableFastCounter slowAppend;
    private final MutableFastCounter splitRequest;
    private final MutableFastCounter splitSuccess;
    private final MetricHistogram splitTimeHisto;
    private final MetricHistogram flushTimeHisto;
    private final MetricHistogram flushMemstoreSizeHisto;
    private final MetricHistogram flushOutputSizeHisto;
    private final MutableFastCounter flushedMemstoreBytes;
    private final MutableFastCounter flushedOutputBytes;
    private final MetricHistogram compactionTimeHisto;
    private final MetricHistogram compactionInputFileCountHisto;
    private final MetricHistogram compactionInputSizeHisto;
    private final MetricHistogram compactionOutputFileCountHisto;
    private final MetricHistogram compactionOutputSizeHisto;
    private final MutableFastCounter compactedInputBytes;
    private final MutableFastCounter compactedOutputBytes;
    private final MetricHistogram majorCompactionTimeHisto;
    private final MetricHistogram majorCompactionInputFileCountHisto;
    private final MetricHistogram majorCompactionInputSizeHisto;
    private final MetricHistogram majorCompactionOutputFileCountHisto;
    private final MetricHistogram majorCompactionOutputSizeHisto;
    private final MutableFastCounter majorCompactedInputBytes;
    private final MutableFastCounter majorCompactedOutputBytes;
    private final MutableFastCounter infoPauseThresholdExceeded;
    private final MutableFastCounter warnPauseThresholdExceeded;
    private final MetricHistogram pausesWithGc;
    private final MetricHistogram pausesWithoutGc;

    public MetricsRegionServerSourceImpl(MetricsRegionServerWrapper rsWrap) {
        this("Server", "Metrics about HBase RegionServer", "regionserver", "RegionServer,sub=Server", rsWrap);
    }

    public MetricsRegionServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsRegionServerWrapper rsWrap) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.rsWrap = rsWrap;
        this.putHisto = this.getMetricsRegistry().newTimeHistogram("mutate");
        this.slowPut = this.getMetricsRegistry().newCounter("slowPutCount", "The number of Multis that took over 1000ms to complete", 0L);
        this.deleteHisto = this.getMetricsRegistry().newTimeHistogram("delete");
        this.slowDelete = this.getMetricsRegistry().newCounter("slowDeleteCount", "The number of Deletes that took over 1000ms to complete", 0L);
        this.getHisto = this.getMetricsRegistry().newTimeHistogram("get");
        this.slowGet = this.getMetricsRegistry().newCounter("slowGetCount", "The number of Gets that took over 1000ms to complete", 0L);
        this.incrementHisto = this.getMetricsRegistry().newTimeHistogram("increment");
        this.slowIncrement = this.getMetricsRegistry().newCounter("slowIncrementCount", "The number of Increments that took over 1000ms to complete", 0L);
        this.appendHisto = this.getMetricsRegistry().newTimeHistogram("append");
        this.slowAppend = this.getMetricsRegistry().newCounter("slowAppendCount", "The number of Appends that took over 1000ms to complete", 0L);
        this.replayHisto = this.getMetricsRegistry().newTimeHistogram("replay");
        this.scanSizeHisto = this.getMetricsRegistry().newSizeHistogram("scanSize");
        this.scanTimeHisto = this.getMetricsRegistry().newTimeHistogram("scanTime");
        this.flushTimeHisto = this.getMetricsRegistry().newTimeHistogram("flushTime", "Histogram for the time in millis for memstore flush");
        this.flushMemstoreSizeHisto = this.getMetricsRegistry().newSizeHistogram("flushMemstoreSize", "Histogram for number of bytes in the memstore for a flush");
        this.flushOutputSizeHisto = this.getMetricsRegistry().newSizeHistogram("flushOutputSize", "Histogram for number of bytes in the resulting file for a flush");
        this.flushedOutputBytes = this.getMetricsRegistry().newCounter("flushedOutputBytes", "Total number of bytes written from flush", 0L);
        this.flushedMemstoreBytes = this.getMetricsRegistry().newCounter("flushedMemstoreBytes", "Total number of bytes of cells in memstore from flush", 0L);
        this.compactionTimeHisto = this.getMetricsRegistry().newTimeHistogram("compactionTime", "Histogram for the time in millis for compaction, both major and minor");
        this.compactionInputFileCountHisto = this.getMetricsRegistry().newHistogram("compactionInputFileCount", "Histogram for the compaction input number of files, both major and minor");
        this.compactionInputSizeHisto = this.getMetricsRegistry().newSizeHistogram("compactionInputSize", "Histogram for the compaction total input file sizes, both major and minor");
        this.compactionOutputFileCountHisto = this.getMetricsRegistry().newHistogram("compactionOutputFileCount", "Histogram for the compaction output number of files, both major and minor");
        this.compactionOutputSizeHisto = this.getMetricsRegistry().newSizeHistogram("compactionOutputSize", "Histogram for the compaction total output file sizes, both major and minor");
        this.compactedInputBytes = this.getMetricsRegistry().newCounter("compactedInputBytes", "Total number of bytes that is read for compaction, both major and minor", 0L);
        this.compactedOutputBytes = this.getMetricsRegistry().newCounter("compactedOutputBytes", "Total number of bytes that is output from compaction, both major and minor", 0L);
        this.majorCompactionTimeHisto = this.getMetricsRegistry().newTimeHistogram("majorCompactionTime", "Histogram for the time in millis for compaction, major only");
        this.majorCompactionInputFileCountHisto = this.getMetricsRegistry().newHistogram("majorCompactionInputFileCount", "Histogram for the compaction input number of files, major only");
        this.majorCompactionInputSizeHisto = this.getMetricsRegistry().newSizeHistogram("majorCompactionInputSize", "Histogram for the compaction total input file sizes, major only");
        this.majorCompactionOutputFileCountHisto = this.getMetricsRegistry().newHistogram("majorCompactionOutputFileCount", "Histogram for the compaction output number of files, major only");
        this.majorCompactionOutputSizeHisto = this.getMetricsRegistry().newSizeHistogram("majorCompactionOutputSize", "Histogram for the compaction total output file sizes, major only");
        this.majorCompactedInputBytes = this.getMetricsRegistry().newCounter("majorCompactedInputBytes", "Total number of bytes that is read for compaction, major only", 0L);
        this.majorCompactedOutputBytes = this.getMetricsRegistry().newCounter("majorCompactedOutputBytes", "Total number of bytes that is output from compaction, major only", 0L);
        this.splitTimeHisto = this.getMetricsRegistry().newTimeHistogram("splitTime");
        this.splitRequest = this.getMetricsRegistry().newCounter("splitRequestCount", "Number of splits requested", 0L);
        this.splitSuccess = this.getMetricsRegistry().newCounter("splitSuccessCount", "Number of successfully executed splits", 0L);
        this.infoPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseInfoThresholdExceeded", "Count of INFO level pause threshold alerts", 0L);
        this.warnPauseThresholdExceeded = this.getMetricsRegistry().newCounter("pauseWarnThresholdExceeded", "Count of WARN level pause threshold alerts", 0L);
        this.pausesWithGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithGc");
        this.pausesWithoutGc = this.getMetricsRegistry().newTimeHistogram("pauseTimeWithoutGc");
    }

    @Override
    public void updatePut(long t) {
        this.putHisto.add(t);
    }

    @Override
    public void updateDelete(long t) {
        this.deleteHisto.add(t);
    }

    @Override
    public void updateGet(long t) {
        this.getHisto.add(t);
    }

    @Override
    public void updateIncrement(long t) {
        this.incrementHisto.add(t);
    }

    @Override
    public void updateAppend(long t) {
        this.appendHisto.add(t);
    }

    @Override
    public void updateReplay(long t) {
        this.replayHisto.add(t);
    }

    @Override
    public void updateScanSize(long scanSize) {
        this.scanSizeHisto.add(scanSize);
    }

    @Override
    public void updateScanTime(long t) {
        this.scanTimeHisto.add(t);
    }

    @Override
    public void incrSlowPut() {
        this.slowPut.incr();
    }

    @Override
    public void incrSlowDelete() {
        this.slowDelete.incr();
    }

    @Override
    public void incrSlowGet() {
        this.slowGet.incr();
    }

    @Override
    public void incrSlowIncrement() {
        this.slowIncrement.incr();
    }

    @Override
    public void incrSlowAppend() {
        this.slowAppend.incr();
    }

    @Override
    public void incrSplitRequest() {
        this.splitRequest.incr();
    }

    @Override
    public void incrSplitSuccess() {
        this.splitSuccess.incr();
    }

    @Override
    public void updateSplitTime(long t) {
        this.splitTimeHisto.add(t);
    }

    @Override
    public void updateFlushTime(long t) {
        this.flushTimeHisto.add(t);
    }

    @Override
    public void updateFlushMemstoreSize(long bytes) {
        this.flushMemstoreSizeHisto.add(bytes);
        this.flushedMemstoreBytes.incr(bytes);
    }

    @Override
    public void updateFlushOutputSize(long bytes) {
        this.flushOutputSizeHisto.add(bytes);
        this.flushedOutputBytes.incr(bytes);
    }

    @Override
    public void updateCompactionTime(boolean isMajor, long t) {
        this.compactionTimeHisto.add(t);
        if (isMajor) {
            this.majorCompactionTimeHisto.add(t);
        }
    }

    @Override
    public void updateCompactionInputFileCount(boolean isMajor, long c) {
        this.compactionInputFileCountHisto.add(c);
        if (isMajor) {
            this.majorCompactionInputFileCountHisto.add(c);
        }
    }

    @Override
    public void updateCompactionInputSize(boolean isMajor, long bytes) {
        this.compactionInputSizeHisto.add(bytes);
        this.compactedInputBytes.incr(bytes);
        if (isMajor) {
            this.majorCompactionInputSizeHisto.add(bytes);
            this.majorCompactedInputBytes.incr(bytes);
        }
    }

    @Override
    public void updateCompactionOutputFileCount(boolean isMajor, long c) {
        this.compactionOutputFileCountHisto.add(c);
        if (isMajor) {
            this.majorCompactionOutputFileCountHisto.add(c);
        }
    }

    @Override
    public void updateCompactionOutputSize(boolean isMajor, long bytes) {
        this.compactionOutputSizeHisto.add(bytes);
        this.compactedOutputBytes.incr(bytes);
        if (isMajor) {
            this.majorCompactionOutputSizeHisto.add(bytes);
            this.majorCompactedOutputBytes.incr(bytes);
        }
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.metricsName);
        if (this.rsWrap != null) {
            mrb.addGauge(Interns.info("regionCount", "Number of regions"), this.rsWrap.getNumOnlineRegions()).addGauge(Interns.info("storeCount", "Number of Stores"), this.rsWrap.getNumStores()).addGauge(Interns.info("hlogFileCount", "Number of WAL Files"), this.rsWrap.getNumWALFiles()).addGauge(Interns.info("hlogFileSize", "Size of all WAL Files"), this.rsWrap.getWALFileSize()).addGauge(Interns.info("storeFileCount", "Number of Store Files"), this.rsWrap.getNumStoreFiles()).addGauge(Interns.info("memStoreSize", "Size of the memstore"), this.rsWrap.getMemstoreSize()).addGauge(Interns.info("storeFileSize", "Size of storefiles being served."), this.rsWrap.getStoreFileSize()).addGauge(Interns.info("maxStoreFileAge", "Max age of store files hosted on this region server"), this.rsWrap.getMaxStoreFileAge()).addGauge(Interns.info("minStoreFileAge", "Min age of store files hosted on this region server"), this.rsWrap.getMinStoreFileAge()).addGauge(Interns.info("avgStoreFileAge", "Average age of store files hosted on this region server"), this.rsWrap.getAvgStoreFileAge()).addGauge(Interns.info("numReferenceFiles", "Number of reference file on this region server"), this.rsWrap.getNumReferenceFiles()).addGauge(Interns.info("regionServerStartTime", "RegionServer Start Time"), this.rsWrap.getStartCode()).addGauge(Interns.info("averageRegionSize", "Average region size over the region server including memstore and storefile sizes."), this.rsWrap.getAverageRegionSize()).addCounter(Interns.info("totalRequestCount", "Total number of requests this RegionServer has answered."), this.rsWrap.getTotalRequestCount()).addCounter(Interns.info("readRequestCount", "Number of read requests this region server has answered."), this.rsWrap.getReadRequestsCount()).addCounter(Interns.info("filteredReadRequestCount", "Number of filtered read requests this region server has answered."), this.rsWrap.getFilteredReadRequestsCount()).addCounter(Interns.info("writeRequestCount", "Number of mutation requests this region server has answered."), this.rsWrap.getWriteRequestsCount()).addCounter(Interns.info("rpcGetRequestCount", "Number of rpc get requests this region server has answered."), this.rsWrap.getRpcGetRequestsCount()).addCounter(Interns.info("rpcScanRequestCount", "Number of rpc scan requests this region server has answered."), this.rsWrap.getRpcScanRequestsCount()).addCounter(Interns.info("rpcMultiRequestCount", "Number of rpc multi requests this region server has answered."), this.rsWrap.getRpcMultiRequestsCount()).addCounter(Interns.info("rpcMutateRequestCount", "Number of rpc mutation requests this region server has answered."), this.rsWrap.getRpcMutateRequestsCount()).addCounter(Interns.info("checkMutateFailedCount", "Number of Check and Mutate calls that failed the checks."), this.rsWrap.getCheckAndMutateChecksFailed()).addCounter(Interns.info("checkMutatePassedCount", "Number of Check and Mutate calls that passed the checks."), this.rsWrap.getCheckAndMutateChecksPassed()).addGauge(Interns.info("storeFileIndexSize", "Size of indexes in storefiles on disk."), this.rsWrap.getStoreFileIndexSize()).addGauge(Interns.info("staticIndexSize", "Uncompressed size of the static indexes."), this.rsWrap.getTotalStaticIndexSize()).addGauge(Interns.info("staticBloomSize", "Uncompressed size of the static bloom filters."), this.rsWrap.getTotalStaticBloomSize()).addGauge(Interns.info("mutationsWithoutWALCount", "Number of mutations that have been sent by clients with the write ahead logging turned off."), this.rsWrap.getNumMutationsWithoutWAL()).addGauge(Interns.info("mutationsWithoutWALSize", "Size of data that has been sent by clients with the write ahead logging turned off."), this.rsWrap.getDataInMemoryWithoutWAL()).addGauge(Interns.info("percentFilesLocal", "The percent of HFiles that are stored on the local hdfs data node."), this.rsWrap.getPercentFileLocal()).addGauge(Interns.info("percentFilesLocalSecondaryRegions", "The percent of HFiles used by secondary regions that are stored on the local hdfs data node."), this.rsWrap.getPercentFileLocalSecondaryRegions()).addGauge(Interns.info("splitQueueLength", "Length of the queue for splits."), this.rsWrap.getSplitQueueSize()).addGauge(Interns.info("compactionQueueLength", "Length of the queue for compactions."), this.rsWrap.getCompactionQueueSize()).addGauge(Interns.info("smallCompactionQueueLength", "Length of the queue for compactions with input size smaller than throttle threshold (2.5GB by default)"), this.rsWrap.getSmallCompactionQueueSize()).addGauge(Interns.info("largeCompactionQueueLength", "Length of the queue for compactions with input size larger than throttle threshold (2.5GB by default)"), this.rsWrap.getLargeCompactionQueueSize()).addGauge(Interns.info("compactionQueueLength", "Length of the queue for compactions."), this.rsWrap.getCompactionQueueSize()).addGauge(Interns.info("flushQueueLength", "Length of the queue for region flushes"), this.rsWrap.getFlushQueueSize()).addGauge(Interns.info("blockCacheFreeSize", "Size of the block cache that is not occupied."), this.rsWrap.getBlockCacheFreeSize()).addGauge(Interns.info("blockCacheCount", "Number of block in the block cache."), this.rsWrap.getBlockCacheCount()).addGauge(Interns.info("blockCacheSize", "Size of the block cache."), this.rsWrap.getBlockCacheSize()).addCounter(Interns.info("blockCacheHitCount", "Count of the hit on the block cache."), this.rsWrap.getBlockCacheHitCount()).addCounter(Interns.info("blockCacheHitCountPrimary", "Count of hit on primary replica in the block cache."), this.rsWrap.getBlockCachePrimaryHitCount()).addCounter(Interns.info("blockCacheMissCount", "Number of requests for a block that missed the block cache."), this.rsWrap.getBlockCacheMissCount()).addCounter(Interns.info("blockCacheMissCountPrimary", "Number of requests for a block of primary replica that missed the block cache."), this.rsWrap.getBlockCachePrimaryMissCount()).addCounter(Interns.info("blockCacheEvictionCount", "Count of the number of blocks evicted from the block cache.(Not including blocks evicted because of HFile removal)"), this.rsWrap.getBlockCacheEvictedCount()).addCounter(Interns.info("blockCacheEvictionCountPrimary", "Count of the number of blocks evicted from primary replica in the block cache."), this.rsWrap.getBlockCachePrimaryEvictedCount()).addGauge(Interns.info("blockCacheCountHitPercent", "Percent of block cache requests that are hits"), this.rsWrap.getBlockCacheHitPercent()).addGauge(Interns.info("blockCacheExpressHitPercent", "The percent of the time that requests with the cache turned on hit the cache."), this.rsWrap.getBlockCacheHitCachingPercent()).addCounter(Interns.info("blockCacheFailedInsertionCount", "Number of times that a block cache insertion failed. Usually due to size restrictions."), this.rsWrap.getBlockCacheFailedInsertions()).addCounter(Interns.info("blockCacheDataMissCount", ""), this.rsWrap.getDataMissCount()).addCounter(Interns.info("blockCacheLeafIndexMissCount", ""), this.rsWrap.getLeafIndexMissCount()).addCounter(Interns.info("blockCacheBloomChunkMissCount", ""), this.rsWrap.getBloomChunkMissCount()).addCounter(Interns.info("blockCacheMetaMissCount", ""), this.rsWrap.getMetaMissCount()).addCounter(Interns.info("blockCacheRootIndexMissCount", ""), this.rsWrap.getRootIndexMissCount()).addCounter(Interns.info("blockCacheIntermediateIndexMissCount", ""), this.rsWrap.getIntermediateIndexMissCount()).addCounter(Interns.info("blockCacheFileInfoMissCount", ""), this.rsWrap.getFileInfoMissCount()).addCounter(Interns.info("blockCacheGeneralBloomMetaMissCount", ""), this.rsWrap.getGeneralBloomMetaMissCount()).addCounter(Interns.info("blockCacheDeleteFamilyBloomMissCount", ""), this.rsWrap.getDeleteFamilyBloomMissCount()).addCounter(Interns.info("blockCacheTrailerMissCount", ""), this.rsWrap.getTrailerMissCount()).addCounter(Interns.info("blockCacheDataHitCount", ""), this.rsWrap.getDataHitCount()).addCounter(Interns.info("blockCacheLeafIndexHitCount", ""), this.rsWrap.getLeafIndexHitCount()).addCounter(Interns.info("blockCacheBloomChunkHitCount", ""), this.rsWrap.getBloomChunkHitCount()).addCounter(Interns.info("blockCacheMetaHitCount", ""), this.rsWrap.getMetaHitCount()).addCounter(Interns.info("blockCacheRootIndexHitCount", ""), this.rsWrap.getRootIndexHitCount()).addCounter(Interns.info("blockCacheIntermediateIndexHitCount", ""), this.rsWrap.getIntermediateIndexHitCount()).addCounter(Interns.info("blockCacheFileInfoHitCount", ""), this.rsWrap.getFileInfoHitCount()).addCounter(Interns.info("blockCacheGeneralBloomMetaHitCount", ""), this.rsWrap.getGeneralBloomMetaHitCount()).addCounter(Interns.info("blockCacheDeleteFamilyBloomHitCount", ""), this.rsWrap.getDeleteFamilyBloomHitCount()).addCounter(Interns.info("blockCacheTrailerHitCount", ""), this.rsWrap.getTrailerHitCount()).addCounter(Interns.info("updatesBlockedTime", "Number of MS updates have been blocked so that the memstore can be flushed."), this.rsWrap.getUpdatesBlockedTime()).addCounter(Interns.info("flushedCellsCount", "The number of cells flushed to disk"), this.rsWrap.getFlushedCellsCount()).addCounter(Interns.info("compactedCellsCount", "The number of cells processed during minor compactions"), this.rsWrap.getCompactedCellsCount()).addCounter(Interns.info("majorCompactedCellsCount", "The number of cells processed during major compactions"), this.rsWrap.getMajorCompactedCellsCount()).addCounter(Interns.info("flushedCellsSize", "The total amount of data flushed to disk, in bytes"), this.rsWrap.getFlushedCellsSize()).addCounter(Interns.info("compactedCellsSize", "The total amount of data processed during minor compactions, in bytes"), this.rsWrap.getCompactedCellsSize()).addCounter(Interns.info("majorCompactedCellsSize", "The total amount of data processed during major compactions, in bytes"), this.rsWrap.getMajorCompactedCellsSize()).addCounter(Interns.info("cellsCountCompactedFromMob", "The number of cells moved from mob during compaction"), this.rsWrap.getCellsCountCompactedFromMob()).addCounter(Interns.info("cellsCountCompactedToMob", "The number of cells moved to mob during compaction"), this.rsWrap.getCellsCountCompactedToMob()).addCounter(Interns.info("cellsSizeCompactedFromMob", "The total amount of cells move from mob during compaction, in bytes"), this.rsWrap.getCellsSizeCompactedFromMob()).addCounter(Interns.info("cellsSizeCompactedToMob", "The total amount of cells move to mob during compaction, in bytes"), this.rsWrap.getCellsSizeCompactedToMob()).addCounter(Interns.info("mobFlushCount", "The number of the flushes in mob-enabled stores"), this.rsWrap.getMobFlushCount()).addCounter(Interns.info("mobFlushedCellsCount", "The number of mob cells flushed to disk"), this.rsWrap.getMobFlushedCellsCount()).addCounter(Interns.info("mobFlushedCellsSize", "The total amount of mob cells flushed to disk, in bytes"), this.rsWrap.getMobFlushedCellsSize()).addCounter(Interns.info("mobScanCellsCount", "The number of scanned mob cells"), this.rsWrap.getMobScanCellsCount()).addCounter(Interns.info("mobScanCellsSize", "The total amount of scanned mob cells, in bytes"), this.rsWrap.getMobScanCellsSize()).addGauge(Interns.info("mobFileCacheCount", "The count of cached mob files"), this.rsWrap.getMobFileCacheCount()).addCounter(Interns.info("mobFileCacheAccessCount", "The count of accesses to the mob file cache"), this.rsWrap.getMobFileCacheAccessCount()).addCounter(Interns.info("mobFileCacheMissCount", "The count of misses to the mob file cache"), this.rsWrap.getMobFileCacheMissCount()).addCounter(Interns.info("mobFileCacheEvictedCount", "The number of items evicted from the mob file cache"), this.rsWrap.getMobFileCacheEvictedCount()).addGauge(Interns.info("mobFileCacheHitPercent", "The hit percent to the mob file cache"), this.rsWrap.getMobFileCacheHitPercent()).addCounter(Interns.info("hedgedReads", "The number of times we started a hedged read"), this.rsWrap.getHedgedReadOps()).addCounter(Interns.info("hedgedReadWins", "The number of times we started a hedged read and a hedged read won"), this.rsWrap.getHedgedReadWins()).addCounter(Interns.info("blockedRequestCount", "The number of blocked requests because of memstore size is larger than blockingMemStoreSize"), this.rsWrap.getBlockedRequestsCount()).tag(Interns.info("zookeeperQuorum", "ZooKeeper Quorum"), this.rsWrap.getZookeeperQuorum()).tag(Interns.info("serverName", "Server Name"), this.rsWrap.getServerName()).tag(Interns.info("clusterId", "Cluster Id"), this.rsWrap.getClusterId());
        }
        this.metricsRegistry.snapshot(mrb, all);
        if (this.metricsAdapter != null) {
            this.metricsAdapter.snapshotAllMetrics(this.registry, mrb);
        }
    }

    @Override
    public void incInfoThresholdExceeded(int count) {
        this.infoPauseThresholdExceeded.incr(count);
    }

    @Override
    public void incWarnThresholdExceeded(int count) {
        this.warnPauseThresholdExceeded.incr(count);
    }

    @Override
    public void updatePauseTimeWithGc(long t) {
        this.pausesWithGc.add(t);
    }

    @Override
    public void updatePauseTimeWithoutGc(long t) {
        this.pausesWithoutGc.add(t);
    }
}

