/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.util.Strings;

@InterfaceAudience.Public
public class QuotaFilter {
    private Set<QuotaType> types = new HashSet<QuotaType>();
    private boolean hasFilters = false;
    private String namespaceRegex;
    private String tableRegex;
    private String userRegex;

    public QuotaFilter setUserFilter(String regex) {
        this.userRegex = regex;
        this.hasFilters |= !Strings.isEmpty(regex);
        return this;
    }

    public QuotaFilter setTableFilter(String regex) {
        this.tableRegex = regex;
        this.hasFilters |= !Strings.isEmpty(regex);
        return this;
    }

    public QuotaFilter setNamespaceFilter(String regex) {
        this.namespaceRegex = regex;
        this.hasFilters |= !Strings.isEmpty(regex);
        return this;
    }

    public QuotaFilter addTypeFilter(QuotaType type) {
        this.types.add(type);
        this.hasFilters |= true;
        return this;
    }

    public boolean isNull() {
        return !this.hasFilters;
    }

    public Set<QuotaType> getTypeFilters() {
        return this.types;
    }

    public String getNamespaceFilter() {
        return this.namespaceRegex;
    }

    public String getTableFilter() {
        return this.tableRegex;
    }

    public String getUserFilter() {
        return this.userRegex;
    }
}

