/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ObjectIntPair;
import org.apache.hadoop.hbase.util.UnsafeAccess;
import org.apache.hadoop.hbase.util.UnsafeAvailChecker;
import sun.nio.ch.DirectBuffer;

@InterfaceAudience.Private
public class SingleByteBuff
extends ByteBuff {
    private static final boolean UNSAFE_AVAIL = UnsafeAvailChecker.isAvailable();
    private static final boolean UNSAFE_UNALIGNED = UnsafeAvailChecker.unaligned();
    private final ByteBuffer buf;
    private long unsafeOffset;
    private Object unsafeRef = null;

    public SingleByteBuff(ByteBuffer buf) {
        this.buf = buf;
        if (buf.hasArray()) {
            this.unsafeOffset = UnsafeAccess.BYTE_ARRAY_BASE_OFFSET + (long)buf.arrayOffset();
            this.unsafeRef = buf.array();
        } else {
            this.unsafeOffset = ((DirectBuffer)((Object)buf)).address();
        }
    }

    @Override
    public int position() {
        return this.buf.position();
    }

    @Override
    public SingleByteBuff position(int position) {
        this.buf.position(position);
        return this;
    }

    @Override
    public SingleByteBuff skip(int len) {
        this.buf.position(this.buf.position() + len);
        return this;
    }

    @Override
    public SingleByteBuff moveBack(int len) {
        this.buf.position(this.buf.position() - len);
        return this;
    }

    @Override
    public int capacity() {
        return this.buf.capacity();
    }

    @Override
    public int limit() {
        return this.buf.limit();
    }

    @Override
    public SingleByteBuff limit(int limit) {
        this.buf.limit(limit);
        return this;
    }

    @Override
    public SingleByteBuff rewind() {
        this.buf.rewind();
        return this;
    }

    @Override
    public SingleByteBuff mark() {
        this.buf.mark();
        return this;
    }

    @Override
    public ByteBuffer asSubByteBuffer(int length) {
        return this.buf;
    }

    @Override
    public void asSubByteBuffer(int offset, int length, ObjectIntPair<ByteBuffer> pair) {
        pair.setFirst(this.buf);
        pair.setSecond(offset);
    }

    @Override
    public int remaining() {
        return this.buf.remaining();
    }

    @Override
    public boolean hasRemaining() {
        return this.buf.hasRemaining();
    }

    @Override
    public SingleByteBuff reset() {
        this.buf.reset();
        return this;
    }

    @Override
    public SingleByteBuff slice() {
        return new SingleByteBuff(this.buf.slice());
    }

    @Override
    public SingleByteBuff duplicate() {
        return new SingleByteBuff(this.buf.duplicate());
    }

    @Override
    public byte get() {
        return this.buf.get();
    }

    @Override
    public byte get(int index) {
        if (UNSAFE_AVAIL) {
            return UnsafeAccess.toByte(this.unsafeRef, this.unsafeOffset + (long)index);
        }
        return this.buf.get(index);
    }

    @Override
    public byte getByteAfterPosition(int offset) {
        return this.get(this.buf.position() + offset);
    }

    @Override
    public SingleByteBuff put(byte b) {
        this.buf.put(b);
        return this;
    }

    @Override
    public SingleByteBuff put(int index, byte b) {
        this.buf.put(index, b);
        return this;
    }

    @Override
    public void get(byte[] dst, int offset, int length) {
        ByteBufferUtils.copyFromBufferToArray(dst, this.buf, this.buf.position(), offset, length);
        this.buf.position(this.buf.position() + length);
    }

    @Override
    public void get(int sourceOffset, byte[] dst, int offset, int length) {
        ByteBufferUtils.copyFromBufferToArray(dst, this.buf, sourceOffset, offset, length);
    }

    @Override
    public void get(byte[] dst) {
        this.get(dst, 0, dst.length);
    }

    @Override
    public SingleByteBuff put(int offset, ByteBuff src, int srcOffset, int length) {
        if (src instanceof SingleByteBuff) {
            ByteBufferUtils.copyFromBufferToBuffer(((SingleByteBuff)src).buf, this.buf, srcOffset, offset, length);
        } else {
            ObjectIntPair<ByteBuffer> pair = new ObjectIntPair<ByteBuffer>();
            src.asSubByteBuffer(srcOffset, length, pair);
            if (pair.getFirst() != null) {
                ByteBufferUtils.copyFromBufferToBuffer(pair.getFirst(), this.buf, pair.getSecond(), offset, length);
            }
        }
        return this;
    }

    @Override
    public SingleByteBuff put(byte[] src, int offset, int length) {
        ByteBufferUtils.copyFromArrayToBuffer(this.buf, src, offset, length);
        return this;
    }

    @Override
    public SingleByteBuff put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public boolean hasArray() {
        return this.buf.hasArray();
    }

    @Override
    public byte[] array() {
        return this.buf.array();
    }

    @Override
    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    @Override
    public short getShort() {
        return this.buf.getShort();
    }

    @Override
    public short getShort(int index) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.toShort(this.unsafeRef, this.unsafeOffset + (long)index);
        }
        return this.buf.getShort(index);
    }

    @Override
    public short getShortAfterPosition(int offset) {
        return this.getShort(this.buf.position() + offset);
    }

    @Override
    public int getInt() {
        return this.buf.getInt();
    }

    @Override
    public SingleByteBuff putInt(int value) {
        ByteBufferUtils.putInt(this.buf, value);
        return this;
    }

    @Override
    public int getInt(int index) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.toInt(this.unsafeRef, this.unsafeOffset + (long)index);
        }
        return this.buf.getInt(index);
    }

    @Override
    public int getIntAfterPosition(int offset) {
        return this.getInt(this.buf.position() + offset);
    }

    @Override
    public long getLong() {
        return this.buf.getLong();
    }

    @Override
    public SingleByteBuff putLong(long value) {
        ByteBufferUtils.putLong(this.buf, value);
        return this;
    }

    @Override
    public long getLong(int index) {
        if (UNSAFE_UNALIGNED) {
            return UnsafeAccess.toLong(this.unsafeRef, this.unsafeOffset + (long)index);
        }
        return this.buf.getLong(index);
    }

    @Override
    public long getLongAfterPosition(int offset) {
        return this.getLong(this.buf.position() + offset);
    }

    @Override
    public byte[] toBytes(int offset, int length) {
        byte[] output = new byte[length];
        ByteBufferUtils.copyFromBufferToArray(output, this.buf, offset, 0, length);
        return output;
    }

    @Override
    public void get(ByteBuffer out, int sourceOffset, int length) {
        ByteBufferUtils.copyFromBufferToBuffer(this.buf, out, sourceOffset, length);
    }

    @Override
    public int read(ReadableByteChannel channel) throws IOException {
        return SingleByteBuff.channelRead(channel, this.buf);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SingleByteBuff)) {
            return false;
        }
        return this.buf.equals(((SingleByteBuff)obj).buf);
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    @VisibleForTesting
    public ByteBuffer getEnclosingByteBuffer() {
        return this.buf;
    }
}

