/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.BufferedDataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.EncoderBufferTooSmallException;
import org.apache.hadoop.hbase.io.encoding.EncodingState;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class PrefixKeyDeltaEncoder
extends BufferedDataBlockEncoder {
    @Override
    public int internalEncode(Cell cell, HFileBlockDefaultEncodingContext encodingContext, DataOutputStream out) throws IOException {
        int klength = KeyValueUtil.keyLength(cell);
        int vlength = cell.getValueLength();
        EncodingState state = encodingContext.getEncodingState();
        if (state.prevCell == null) {
            ByteBufferUtils.putCompressedInt(out, klength);
            ByteBufferUtils.putCompressedInt(out, vlength);
            ByteBufferUtils.putCompressedInt(out, 0);
            CellUtil.writeFlatKey(cell, out);
        } else {
            int common = CellUtil.findCommonPrefixInFlatKey(cell, state.prevCell, true, true);
            ByteBufferUtils.putCompressedInt(out, klength - common);
            ByteBufferUtils.putCompressedInt(out, vlength);
            ByteBufferUtils.putCompressedInt(out, common);
            this.writeKeyExcludingCommon(cell, common, out);
        }
        CellUtil.writeValue(out, cell, vlength);
        int size = klength + vlength + 8;
        state.prevCell = cell;
        return size += this.afterEncodingKeyValue(cell, out, encodingContext);
    }

    private void writeKeyExcludingCommon(Cell cell, int commonPrefix, DataOutputStream out) throws IOException {
        short rLen = cell.getRowLength();
        if (commonPrefix < rLen + 2) {
            CellUtil.writeRowKeyExcludingCommon(cell, rLen, commonPrefix, out);
            byte fLen = cell.getFamilyLength();
            out.writeByte(fLen);
            CellUtil.writeFamily(out, cell, fLen);
            CellUtil.writeQualifier(out, cell, cell.getQualifierLength());
            out.writeLong(cell.getTimestamp());
            out.writeByte(cell.getTypeByte());
        } else {
            int commonQualPrefix;
            commonPrefix = commonPrefix - (rLen + 2) - (cell.getFamilyLength() + 1);
            int qLen = cell.getQualifierLength();
            int qualPartLenToWrite = qLen - (commonQualPrefix = Math.min(commonPrefix, qLen));
            if (qualPartLenToWrite > 0) {
                CellUtil.writeQualifierSkippingBytes(out, cell, qLen, commonQualPrefix);
            }
            if ((commonPrefix -= commonQualPrefix) > 0) {
                int commonTimestampPrefix = Math.min(commonPrefix, 8);
                if (commonTimestampPrefix < 8) {
                    byte[] curTsBuf = Bytes.toBytes(cell.getTimestamp());
                    out.write(curTsBuf, commonTimestampPrefix, 8 - commonTimestampPrefix);
                }
                if ((commonPrefix -= commonTimestampPrefix) == 0) {
                    out.writeByte(cell.getTypeByte());
                }
            } else {
                out.writeLong(cell.getTimestamp());
                out.writeByte(cell.getTypeByte());
            }
        }
    }

    @Override
    protected ByteBuffer internalDecodeKeyValues(DataInputStream source, int allocateHeaderLength, int skipLastBytes, HFileBlockDefaultDecodingContext decodingCtx) throws IOException {
        int decompressedSize = source.readInt();
        ByteBuffer buffer = ByteBuffer.allocate(decompressedSize + allocateHeaderLength);
        buffer.position(allocateHeaderLength);
        int prevKeyOffset = 0;
        while (source.available() > skipLastBytes) {
            prevKeyOffset = this.decodeKeyValue(source, buffer, prevKeyOffset);
            this.afterDecodingKeyValue(source, buffer, decodingCtx);
        }
        if (source.available() != skipLastBytes) {
            throw new IllegalStateException("Read too many bytes.");
        }
        buffer.limit(buffer.position());
        return buffer;
    }

    private int decodeKeyValue(DataInputStream source, ByteBuffer buffer, int prevKeyOffset) throws IOException, EncoderBufferTooSmallException {
        int keyOffset;
        int keyLength = ByteBufferUtils.readCompressedInt(source);
        int valueLength = ByteBufferUtils.readCompressedInt(source);
        int commonLength = ByteBufferUtils.readCompressedInt(source);
        PrefixKeyDeltaEncoder.ensureSpace(buffer, (keyLength += commonLength) + valueLength + 8);
        buffer.putInt(keyLength);
        buffer.putInt(valueLength);
        if (commonLength > 0) {
            keyOffset = buffer.position();
            ByteBufferUtils.copyFromBufferToBuffer(buffer, buffer, prevKeyOffset, commonLength);
        } else {
            keyOffset = buffer.position();
        }
        int len = keyLength - commonLength + valueLength;
        ByteBufferUtils.copyFromStreamToBuffer(buffer, source, len);
        return keyOffset;
    }

    @Override
    public Cell getFirstKeyCellInBlock(ByteBuff block) {
        block.mark();
        block.position(4);
        int keyLength = ByteBuff.readCompressedInt(block);
        ByteBuff.readCompressedInt(block);
        int commonLength = ByteBuff.readCompressedInt(block);
        if (commonLength != 0) {
            throw new AssertionError((Object)("Nonzero common length in the first key in block: " + commonLength));
        }
        ByteBuffer key = block.asSubByteBuffer(keyLength).duplicate();
        block.reset();
        return this.createFirstKeyCell(key, keyLength);
    }

    public String toString() {
        return PrefixKeyDeltaEncoder.class.getSimpleName();
    }

    @Override
    public DataBlockEncoder.EncodedSeeker createSeeker(CellComparator comparator, HFileBlockDecodingContext decodingCtx) {
        return new BufferedDataBlockEncoder.BufferedEncodedSeeker<BufferedDataBlockEncoder.SeekerState>(comparator, decodingCtx){

            @Override
            protected void decodeNext() {
                this.current.keyLength = ByteBuff.readCompressedInt(this.currentBuffer);
                this.current.valueLength = ByteBuff.readCompressedInt(this.currentBuffer);
                this.current.lastCommonPrefix = ByteBuff.readCompressedInt(this.currentBuffer);
                this.current.keyLength += this.current.lastCommonPrefix;
                this.current.ensureSpaceForKey();
                this.currentBuffer.get(this.current.keyBuffer, this.current.lastCommonPrefix, this.current.keyLength - this.current.lastCommonPrefix);
                this.current.valueOffset = this.currentBuffer.position();
                this.currentBuffer.skip(this.current.valueLength);
                if (this.includesTags()) {
                    this.decodeTags();
                }
                this.current.memstoreTS = this.includesMvcc() ? ByteBuff.readVLong(this.currentBuffer) : 0L;
                this.current.nextKvOffset = this.currentBuffer.position();
            }

            @Override
            protected void decodeFirst() {
                this.currentBuffer.skip(4);
                this.decodeNext();
            }
        };
    }
}

