/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.ByteBufferWriter;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ByteArrayOutputStream
extends OutputStream
implements ByteBufferWriter {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private byte[] buf;
    private int pos = 0;

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int capacity) {
        this.buf = new byte[capacity];
    }

    @Override
    public void write(ByteBuffer b, int off, int len) {
        this.checkSizeAndGrow(len);
        ByteBufferUtils.copyFromBufferToArray(this.buf, b, off, this.pos, len);
        this.pos += len;
    }

    @Override
    public void writeInt(int i) {
        this.checkSizeAndGrow(4);
        Bytes.putInt(this.buf, this.pos, i);
        this.pos += 4;
    }

    @Override
    public void write(int b) {
        this.checkSizeAndGrow(1);
        this.buf[this.pos] = (byte)b;
        ++this.pos;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.checkSizeAndGrow(len);
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
    }

    private void checkSizeAndGrow(int extra) {
        long capacityNeeded = (long)this.pos + (long)extra;
        if (capacityNeeded > (long)this.buf.length) {
            if (capacityNeeded > 0x7FFFFFF7L) {
                throw new BufferOverflowException();
            }
            long nextCapacity = Math.min(this.buf.length << 1, 0x7FFFFFF7);
            if ((nextCapacity = Math.max(nextCapacity, capacityNeeded)) > 0x7FFFFFF7L) {
                throw new BufferOverflowException();
            }
            byte[] newBuf = new byte[(int)nextCapacity];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
    }

    public void reset() {
        this.pos = 0;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.buf, this.pos);
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int size() {
        return this.pos;
    }
}

