/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hadoop.hbase.ByteBufferCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
public class KeyOnlyFilter
extends FilterBase {
    boolean lenAsVal;

    public KeyOnlyFilter() {
        this(false);
    }

    public KeyOnlyFilter(boolean lenAsVal) {
        this.lenAsVal = lenAsVal;
    }

    @Override
    public boolean filterRowKey(Cell cell) throws IOException {
        return false;
    }

    @Override
    public Cell transformCell(Cell cell) {
        return this.createKeyOnlyCell(cell);
    }

    private Cell createKeyOnlyCell(Cell c) {
        if (c instanceof ByteBufferCell) {
            return new KeyOnlyByteBufferCell((ByteBufferCell)c, this.lenAsVal);
        }
        return new KeyOnlyCell(c, this.lenAsVal);
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell ignored) throws IOException {
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument(filterArguments.isEmpty() || filterArguments.size() == 1, "Expected: 0 or 1 but got: %s", filterArguments.size());
        KeyOnlyFilter filter = new KeyOnlyFilter();
        if (filterArguments.size() == 1) {
            filter.lenAsVal = ParseFilter.convertByteArrayToBoolean(filterArguments.get(0));
        }
        return filter;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.KeyOnlyFilter.Builder builder = FilterProtos.KeyOnlyFilter.newBuilder();
        builder.setLenAsVal(this.lenAsVal);
        return builder.build().toByteArray();
    }

    public static KeyOnlyFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.KeyOnlyFilter proto;
        try {
            proto = FilterProtos.KeyOnlyFilter.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new KeyOnlyFilter(proto.getLenAsVal());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyOnlyFilter)) {
            return false;
        }
        KeyOnlyFilter other = (KeyOnlyFilter)o;
        return this.lenAsVal == other.lenAsVal;
    }

    static class KeyOnlyByteBufferCell
    extends ByteBufferCell {
        private ByteBufferCell cell;
        private boolean lenAsVal;

        public KeyOnlyByteBufferCell(ByteBufferCell c, boolean lenAsVal) {
            this.cell = c;
            this.lenAsVal = lenAsVal;
        }

        @Override
        public byte[] getRowArray() {
            return this.cell.getRowArray();
        }

        @Override
        public int getRowOffset() {
            return this.cell.getRowOffset();
        }

        @Override
        public short getRowLength() {
            return this.cell.getRowLength();
        }

        @Override
        public byte[] getFamilyArray() {
            return this.cell.getFamilyArray();
        }

        @Override
        public int getFamilyOffset() {
            return this.cell.getFamilyOffset();
        }

        @Override
        public byte getFamilyLength() {
            return this.cell.getFamilyLength();
        }

        @Override
        public byte[] getQualifierArray() {
            return this.cell.getQualifierArray();
        }

        @Override
        public int getQualifierOffset() {
            return this.cell.getQualifierOffset();
        }

        @Override
        public int getQualifierLength() {
            return this.cell.getQualifierLength();
        }

        @Override
        public long getTimestamp() {
            return this.cell.getTimestamp();
        }

        @Override
        public byte getTypeByte() {
            return this.cell.getTypeByte();
        }

        @Override
        public long getSequenceId() {
            return 0L;
        }

        @Override
        public byte[] getValueArray() {
            if (this.lenAsVal) {
                return Bytes.toBytes(this.cell.getValueLength());
            }
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            if (this.lenAsVal) {
                return 4;
            }
            return 0;
        }

        @Override
        public byte[] getTagsArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            return 0;
        }

        @Override
        public ByteBuffer getRowByteBuffer() {
            return this.cell.getRowByteBuffer();
        }

        @Override
        public int getRowPosition() {
            return this.cell.getRowPosition();
        }

        @Override
        public ByteBuffer getFamilyByteBuffer() {
            return this.cell.getFamilyByteBuffer();
        }

        @Override
        public int getFamilyPosition() {
            return this.cell.getFamilyPosition();
        }

        @Override
        public ByteBuffer getQualifierByteBuffer() {
            return this.cell.getQualifierByteBuffer();
        }

        @Override
        public int getQualifierPosition() {
            return this.cell.getQualifierPosition();
        }

        @Override
        public ByteBuffer getValueByteBuffer() {
            if (this.lenAsVal) {
                return ByteBuffer.wrap(Bytes.toBytes(this.cell.getValueLength()));
            }
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getValuePosition() {
            return 0;
        }

        @Override
        public ByteBuffer getTagsByteBuffer() {
            return HConstants.EMPTY_BYTE_BUFFER;
        }

        @Override
        public int getTagsPosition() {
            return 0;
        }
    }

    static class KeyOnlyCell
    implements Cell {
        private Cell cell;
        private boolean lenAsVal;

        public KeyOnlyCell(Cell c, boolean lenAsVal) {
            this.cell = c;
            this.lenAsVal = lenAsVal;
        }

        @Override
        public byte[] getRowArray() {
            return this.cell.getRowArray();
        }

        @Override
        public int getRowOffset() {
            return this.cell.getRowOffset();
        }

        @Override
        public short getRowLength() {
            return this.cell.getRowLength();
        }

        @Override
        public byte[] getFamilyArray() {
            return this.cell.getFamilyArray();
        }

        @Override
        public int getFamilyOffset() {
            return this.cell.getFamilyOffset();
        }

        @Override
        public byte getFamilyLength() {
            return this.cell.getFamilyLength();
        }

        @Override
        public byte[] getQualifierArray() {
            return this.cell.getQualifierArray();
        }

        @Override
        public int getQualifierOffset() {
            return this.cell.getQualifierOffset();
        }

        @Override
        public int getQualifierLength() {
            return this.cell.getQualifierLength();
        }

        @Override
        public long getTimestamp() {
            return this.cell.getTimestamp();
        }

        @Override
        public byte getTypeByte() {
            return this.cell.getTypeByte();
        }

        @Override
        public long getSequenceId() {
            return 0L;
        }

        @Override
        public byte[] getValueArray() {
            if (this.lenAsVal) {
                return Bytes.toBytes(this.cell.getValueLength());
            }
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            if (this.lenAsVal) {
                return 4;
            }
            return 0;
        }

        @Override
        public byte[] getTagsArray() {
            return HConstants.EMPTY_BYTE_ARRAY;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public int getTagsLength() {
            return 0;
        }
    }
}

