/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;

@InterfaceAudience.Public
public final class FilterList
extends FilterBase {
    private static final int MAX_LOG_FILTERS = 5;
    private Operator operator = Operator.MUST_PASS_ALL;
    private final List<Filter> filters;
    private Filter seekHintFilter = null;
    private List<Filter.ReturnCode> prevFilterRCList = null;
    private List<Cell> prevCellList = null;
    private Cell referenceCell = null;
    private Cell transformedCell = null;

    public FilterList(List<Filter> rowFilters) {
        this.reversed = FilterList.getReversed(rowFilters, this.reversed);
        this.filters = new ArrayList<Filter>(rowFilters);
        this.initPrevListForMustPassOne(rowFilters.size());
    }

    public FilterList(Filter ... rowFilters) {
        this(Arrays.asList(rowFilters));
    }

    public FilterList(Operator operator) {
        this.operator = operator;
        this.filters = new ArrayList<Filter>();
        this.initPrevListForMustPassOne(this.filters.size());
    }

    public FilterList(Operator operator, List<Filter> rowFilters) {
        this(rowFilters);
        this.operator = operator;
        this.initPrevListForMustPassOne(rowFilters.size());
    }

    public FilterList(Operator operator, Filter ... rowFilters) {
        this(rowFilters);
        this.operator = operator;
        this.initPrevListForMustPassOne(rowFilters.length);
    }

    public void initPrevListForMustPassOne(int size) {
        if (this.operator == Operator.MUST_PASS_ONE) {
            if (this.prevFilterRCList == null) {
                this.prevFilterRCList = new ArrayList<Object>(Collections.nCopies(size, null));
            }
            if (this.prevCellList == null) {
                this.prevCellList = new ArrayList<Object>(Collections.nCopies(size, null));
            }
        }
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public int size() {
        return this.filters.size();
    }

    private boolean isEmpty() {
        return this.filters.isEmpty();
    }

    private static boolean getReversed(List<Filter> rowFilters, boolean defaultValue) {
        boolean rval = defaultValue;
        boolean isFirst = true;
        for (Filter f : rowFilters) {
            if (isFirst) {
                rval = f.isReversed();
                isFirst = false;
                continue;
            }
            if (rval == f.isReversed()) continue;
            throw new IllegalArgumentException("Filters in the list must have the same reversed flag");
        }
        return rval;
    }

    private static void checkReversed(List<Filter> rowFilters, boolean expected) {
        for (Filter filter : rowFilters) {
            if (expected == filter.isReversed()) continue;
            throw new IllegalArgumentException("Filters in the list must have the same reversed flag, expected=" + expected);
        }
    }

    public void addFilter(List<Filter> filters) {
        FilterList.checkReversed(filters, this.isReversed());
        this.filters.addAll(filters);
        if (this.operator == Operator.MUST_PASS_ONE) {
            this.prevFilterRCList.addAll(Collections.nCopies(filters.size(), null));
            this.prevCellList.addAll(Collections.nCopies(filters.size(), null));
        }
    }

    public void addFilter(Filter filter) {
        this.addFilter(Collections.singletonList(filter));
    }

    @Override
    public void reset() throws IOException {
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            this.filters.get(i).reset();
            if (this.operator != Operator.MUST_PASS_ONE) continue;
            this.prevFilterRCList.set(i, null);
            this.prevCellList.set(i, null);
        }
        this.seekHintFilter = null;
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) throws IOException {
        if (this.isEmpty()) {
            return super.filterRowKey(rowKey, offset, length);
        }
        boolean flag = this.operator == Operator.MUST_PASS_ONE;
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            Filter filter = this.filters.get(i);
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterAllRemaining() && !filter.filterRowKey(rowKey, offset, length)) continue;
                flag = true;
                continue;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRowKey(rowKey, offset, length)) continue;
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean filterRowKey(Cell firstRowCell) throws IOException {
        if (this.isEmpty()) {
            return super.filterRowKey(firstRowCell);
        }
        boolean flag = this.operator == Operator.MUST_PASS_ONE;
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            Filter filter = this.filters.get(i);
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterAllRemaining() && !filter.filterRowKey(firstRowCell)) continue;
                flag = true;
                continue;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRowKey(firstRowCell)) continue;
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean filterAllRemaining() throws IOException {
        if (this.isEmpty()) {
            return super.filterAllRemaining();
        }
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            if (this.filters.get(i).filterAllRemaining()) {
                if (this.operator != Operator.MUST_PASS_ALL) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    @Override
    public Cell transformCell(Cell c) throws IOException {
        if (this.isEmpty()) {
            return super.transformCell(c);
        }
        if (!CellUtil.equals(c, this.referenceCell)) {
            throw new IllegalStateException("Reference Cell: " + this.referenceCell + " does not match: " + c);
        }
        return this.transformedCell;
    }

    private boolean shouldPassCurrentCellToFilter(Cell prevCell, Cell currentCell, int filterIdx) throws IOException {
        Filter.ReturnCode prevCode = this.prevFilterRCList.get(filterIdx);
        if (prevCell == null || prevCode == null) {
            return true;
        }
        switch (prevCode) {
            case INCLUDE: 
            case SKIP: {
                return true;
            }
            case SEEK_NEXT_USING_HINT: {
                Cell nextHintCell = this.getNextCellHint(prevCell);
                return nextHintCell == null || CellComparator.COMPARATOR.compare(currentCell, nextHintCell) >= 0;
            }
            case NEXT_COL: 
            case INCLUDE_AND_NEXT_COL: {
                return !CellUtil.matchingRowColumn(prevCell, currentCell);
            }
            case NEXT_ROW: 
            case INCLUDE_AND_SEEK_NEXT_ROW: {
                return !CellUtil.matchingRows(prevCell, currentCell);
            }
        }
        throw new IllegalStateException("Received code is not valid.");
    }

    @Override
    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"}, justification="Intentional")
    public Filter.ReturnCode filterKeyValue(Cell c) throws IOException {
        if (this.isEmpty()) {
            return Filter.ReturnCode.INCLUDE;
        }
        this.referenceCell = c;
        Cell transformed = c;
        Filter.ReturnCode rc = this.operator == Operator.MUST_PASS_ONE ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
        int listize = this.filters.size();
        boolean seenNonHintReturnCode = false;
        block13: for (int i = 0; i < listize; ++i) {
            Filter filter = this.filters.get(i);
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (filter.filterAllRemaining()) {
                    return Filter.ReturnCode.NEXT_ROW;
                }
                Filter.ReturnCode code = filter.filterKeyValue(c);
                switch (code) {
                    case INCLUDE_AND_NEXT_COL: {
                        rc = Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                    }
                    case INCLUDE: {
                        transformed = filter.transformCell(transformed);
                        continue block13;
                    }
                    case SEEK_NEXT_USING_HINT: {
                        this.seekHintFilter = filter;
                        return code;
                    }
                    default: {
                        return code;
                    }
                }
            }
            if (this.operator != Operator.MUST_PASS_ONE) continue;
            Cell prevCell = this.prevCellList.get(i);
            if (filter.filterAllRemaining() || !this.shouldPassCurrentCellToFilter(prevCell, c, i)) {
                seenNonHintReturnCode = true;
                continue;
            }
            Filter.ReturnCode localRC = filter.filterKeyValue(c);
            this.prevFilterRCList.set(i, localRC);
            if (c == null || localRC == Filter.ReturnCode.INCLUDE || localRC == Filter.ReturnCode.SKIP) {
                this.prevCellList.set(i, null);
            } else {
                this.prevCellList.set(i, KeyValueUtil.toNewKeyCell(c));
            }
            if (localRC != Filter.ReturnCode.SEEK_NEXT_USING_HINT) {
                seenNonHintReturnCode = true;
            }
            switch (localRC) {
                case INCLUDE: {
                    if (rc != Filter.ReturnCode.INCLUDE_AND_NEXT_COL) {
                        rc = Filter.ReturnCode.INCLUDE;
                    }
                    transformed = filter.transformCell(transformed);
                    continue block13;
                }
                case INCLUDE_AND_NEXT_COL: {
                    rc = Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                    transformed = filter.transformCell(transformed);
                    continue block13;
                }
                case NEXT_ROW: {
                    continue block13;
                }
                case SKIP: {
                    continue block13;
                }
                case NEXT_COL: {
                    continue block13;
                }
                case SEEK_NEXT_USING_HINT: {
                    continue block13;
                }
                default: {
                    throw new IllegalStateException("Received code is not valid.");
                }
            }
        }
        this.transformedCell = transformed;
        if (this.operator == Operator.MUST_PASS_ONE && !seenNonHintReturnCode) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        return rc;
    }

    @Override
    public void filterRowCells(List<Cell> cells) throws IOException {
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            this.filters.get(i).filterRowCells(cells);
        }
    }

    @Override
    public boolean hasFilterRow() {
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            if (!this.filters.get(i).hasFilterRow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterRow() throws IOException {
        if (this.isEmpty()) {
            return super.filterRow();
        }
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            Filter filter = this.filters.get(i);
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterRow()) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterRow()) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        FilterProtos.FilterList.Builder builder = FilterProtos.FilterList.newBuilder();
        builder.setOperator(FilterProtos.FilterList.Operator.valueOf(this.operator.name()));
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            builder.addFilters(ProtobufUtil.toFilter(this.filters.get(i)));
        }
        return builder.build().toByteArray();
    }

    public static FilterList parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FilterList proto;
        try {
            proto = FilterProtos.FilterList.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        ArrayList<Filter> rowFilters = new ArrayList<Filter>(proto.getFiltersCount());
        try {
            List<FilterProtos.Filter> filtersList = proto.getFiltersList();
            int listSize = filtersList.size();
            for (int i = 0; i < listSize; ++i) {
                rowFilters.add(ProtobufUtil.toFilter(filtersList.get(i)));
            }
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new FilterList(Operator.valueOf(proto.getOperator().name()), rowFilters);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FilterList)) {
            return false;
        }
        FilterList o = (FilterList)other;
        return this.getOperator().equals((Object)o.getOperator()) && (this.getFilters() == o.getFilters() || this.getFilters().equals(o.getFilters()));
    }

    @Override
    public Cell getNextCellHint(Cell currentCell) throws IOException {
        if (this.isEmpty()) {
            return super.getNextCellHint(currentCell);
        }
        Cell keyHint = null;
        if (this.operator == Operator.MUST_PASS_ALL) {
            if (this.seekHintFilter != null) {
                keyHint = this.seekHintFilter.getNextCellHint(currentCell);
            }
            return keyHint;
        }
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            if (this.filters.get(i).filterAllRemaining()) continue;
            Cell curKeyHint = this.filters.get(i).getNextCellHint(currentCell);
            if (curKeyHint == null) {
                return null;
            }
            if (keyHint == null) {
                keyHint = curKeyHint;
                continue;
            }
            if (CellComparator.COMPARATOR.compare(keyHint, curKeyHint) <= 0) continue;
            keyHint = curKeyHint;
        }
        return keyHint;
    }

    @Override
    public boolean isFamilyEssential(byte[] name) throws IOException {
        if (this.isEmpty()) {
            return super.isFamilyEssential(name);
        }
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            if (!this.filters.get(i).isFamilyEssential(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setReversed(boolean reversed) {
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            this.filters.get(i).setReversed(reversed);
        }
        this.reversed = reversed;
    }

    @Override
    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxFilters) {
        int endIndex = this.filters.size() < maxFilters ? this.filters.size() : maxFilters;
        return String.format("%s %s (%d/%d): %s", this.getClass().getSimpleName(), this.operator == Operator.MUST_PASS_ALL ? "AND" : "OR", endIndex, this.filters.size(), this.filters.subList(0, endIndex).toString());
    }

    @InterfaceAudience.Public
    public static enum Operator {
        MUST_PASS_ALL,
        MUST_PASS_ONE;

    }
}

