/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptor;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorContext;
import org.apache.hadoop.hbase.client.RetryingCallerInterceptorFactory;
import org.apache.hadoop.hbase.client.RetryingTimeTracker;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.exceptions.PreemptiveFastFailException;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.ipc.RemoteException;

@InterfaceAudience.Private
public class RpcRetryingCallerImpl<T>
implements RpcRetryingCaller<T> {
    public static final Log LOG = LogFactory.getLog(RpcRetryingCallerImpl.class);
    private final int startLogErrorsCnt;
    private final long pause;
    private final long pauseForCQTBE;
    private final int maxAttempts;
    private final int rpcTimeout;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final RetryingCallerInterceptor interceptor;
    private final RetryingCallerInterceptorContext context;
    private final RetryingTimeTracker tracker;

    public RpcRetryingCallerImpl(long pause, long pauseForCQTBE, int retries, int startLogErrorsCnt) {
        this(pause, pauseForCQTBE, retries, RetryingCallerInterceptorFactory.NO_OP_INTERCEPTOR, startLogErrorsCnt, 0);
    }

    public RpcRetryingCallerImpl(long pause, long pauseForCQTBE, int retries, RetryingCallerInterceptor interceptor, int startLogErrorsCnt, int rpcTimeout) {
        this.pause = pause;
        this.pauseForCQTBE = pauseForCQTBE;
        this.maxAttempts = ConnectionUtils.retries2Attempts(retries);
        this.interceptor = interceptor;
        this.context = interceptor.createEmptyContext();
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.tracker = new RetryingTimeTracker();
        this.rpcTimeout = rpcTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.cancelled.set(true);
        AtomicBoolean atomicBoolean = this.cancelled;
        synchronized (atomicBoolean) {
            this.cancelled.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T callWithRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
        ArrayList<RetriesExhaustedException.ThrowableWithExtraContext> exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        this.tracker.start();
        this.context.clear();
        int tries = 0;
        while (true) {
            long expectedSleep;
            Serializable t3;
            try {
                callable.prepare(tries != 0);
                this.interceptor.intercept(this.context.prepare(callable, tries));
                T t2 = callable.call(this.getTimeout(callTimeout));
                return t2;
            }
            catch (PreemptiveFastFailException e) {
                throw e;
            }
            catch (Throwable t3) {
                Throwable e = t3.getCause();
                ExceptionUtil.rethrowIfInterrupt(t3);
                this.interceptor.handleFailure(this.context, t3);
                t3 = RpcRetryingCallerImpl.translateException(t3);
                if (tries > this.startLogErrorsCnt) {
                    LOG.info((Object)("Call exception, tries=" + tries + ", maxAttempts=" + this.maxAttempts + ", started=" + (EnvironmentEdgeManager.currentTime() - this.tracker.getStartTime()) + " ms ago, cancelled=" + this.cancelled.get() + ", msg=" + t3.getMessage() + " " + callable.getExceptionMessageAdditionalDetail()));
                }
                callable.throwable((Throwable)t3, this.maxAttempts != 1);
                RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext((Throwable)t3, EnvironmentEdgeManager.currentTime(), this.toString());
                exceptions.add(qt);
                if (tries >= this.maxAttempts - 1) {
                    throw new RetriesExhaustedException(tries, exceptions);
                }
                long pauseBase = t3 instanceof CallQueueTooBigException ? this.pauseForCQTBE : this.pause;
                expectedSleep = callable.sleep(pauseBase, tries);
                long duration = this.singleCallDuration(expectedSleep);
                if (duration > (long)callTimeout) {
                    String msg = "callTimeout=" + callTimeout + ", callDuration=" + duration + ": " + t3.getMessage() + " " + callable.getExceptionMessageAdditionalDetail();
                    throw (SocketTimeoutException)new SocketTimeoutException(msg).initCause((Throwable)t3);
                }
            }
            finally {
                this.interceptor.updateFailureInfo(this.context);
            }
            try {
                if (expectedSleep > 0L) {
                    t3 = this.cancelled;
                    synchronized (t3) {
                        if (this.cancelled.get()) {
                            return null;
                        }
                        this.cancelled.wait(expectedSleep);
                    }
                }
                if (this.cancelled.get()) {
                    return null;
                }
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException("Interrupted after " + tries + " tries while maxAttempts=" + this.maxAttempts);
            }
            ++tries;
        }
    }

    private long singleCallDuration(long expectedSleep) {
        return EnvironmentEdgeManager.currentTime() - this.tracker.getStartTime() + expectedSleep;
    }

    @Override
    public T callWithoutRetries(RetryingCallable<T> callable, int callTimeout) throws IOException, RuntimeException {
        try {
            callable.prepare(false);
            return callable.call(callTimeout);
        }
        catch (Throwable t) {
            Throwable t2 = RpcRetryingCallerImpl.translateException(t);
            ExceptionUtil.rethrowIfInterrupt(t2);
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            throw new RuntimeException(t2);
        }
    }

    static Throwable translateException(Throwable t) throws DoNotRetryIOException {
        if (t instanceof UndeclaredThrowableException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof RemoteException) {
            t = ((RemoteException)t).unwrapRemoteException();
        }
        if (t instanceof LinkageError) {
            throw new DoNotRetryIOException(t);
        }
        if (t instanceof ServiceException) {
            ServiceException se = (ServiceException)t;
            Throwable cause = se.getCause();
            if (cause != null && cause instanceof DoNotRetryIOException) {
                throw (DoNotRetryIOException)cause;
            }
            t = cause;
            RpcRetryingCallerImpl.translateException(t);
        } else if (t instanceof DoNotRetryIOException) {
            throw (DoNotRetryIOException)t;
        }
        return t;
    }

    private int getTimeout(int callTimeout) {
        int timeout = this.tracker.getRemainingTime(callTimeout);
        if (timeout <= 0 || this.rpcTimeout > 0 && this.rpcTimeout < timeout) {
            timeout = this.rpcTimeout;
        }
        return timeout;
    }

    public String toString() {
        return "RpcRetryingCaller{globalStartTime=" + this.tracker.getStartTime() + ", pause=" + this.pause + ", maxAttempts=" + this.maxAttempts + '}';
    }
}

