/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ClientCoprocessorRpcController;
import org.apache.hadoop.hbase.client.RegionLocateType;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcChannel;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
class RegionCoprocessorRpcChannelImpl
implements RpcChannel {
    private final AsyncConnectionImpl conn;
    private final TableName tableName;
    private final HRegionInfo region;
    private final byte[] row;
    private final long rpcTimeoutNs;
    private final long operationTimeoutNs;

    RegionCoprocessorRpcChannelImpl(AsyncConnectionImpl conn, TableName tableName, HRegionInfo region, byte[] row, long rpcTimeoutNs, long operationTimeoutNs) {
        this.conn = conn;
        this.tableName = tableName;
        this.region = region;
        this.row = row;
        this.rpcTimeoutNs = rpcTimeoutNs;
        this.operationTimeoutNs = operationTimeoutNs;
    }

    private CompletableFuture<Message> rpcCall(Descriptors.MethodDescriptor method, Message request, final Message responsePrototype, final HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub) {
        final CompletableFuture<Message> future = new CompletableFuture<Message>();
        if (this.region != null && !Bytes.equals(loc.getRegionInfo().getRegionName(), this.region.getRegionName())) {
            future.completeExceptionally(new DoNotRetryIOException("Region name is changed, expected " + this.region.getRegionNameAsString() + ", actual " + loc.getRegionInfo().getRegionNameAsString()));
            return future;
        }
        ClientProtos.CoprocessorServiceRequest csr = CoprocessorRpcUtils.getCoprocessorServiceRequest(method, request, this.row, loc.getRegionInfo().getRegionName());
        stub.execService(controller, csr, new RpcCallback<ClientProtos.CoprocessorServiceResponse>(){

            @Override
            public void run(ClientProtos.CoprocessorServiceResponse resp) {
                if (controller.failed()) {
                    future.completeExceptionally(controller.getFailed());
                } else {
                    try {
                        future.complete(CoprocessorRpcUtils.getResponse(resp, responsePrototype));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    @Override
    public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> done) {
        this.conn.callerFactory.single().table(this.tableName).row(this.row).locateType(RegionLocateType.CURRENT).rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.operationTimeoutNs, TimeUnit.NANOSECONDS).action((c, l, s) -> this.rpcCall(method, request, responsePrototype, c, l, s)).call().whenComplete((r, e) -> {
            if (e != null) {
                ((ClientCoprocessorRpcController)controller).setFailed((Throwable)e);
            }
            done.run((Message)r);
        });
    }
}

