/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.SyncCoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcController;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;

@InterfaceAudience.Private
class RegionCoprocessorRpcChannel
extends SyncCoprocessorRpcChannel {
    private static final Log LOG = LogFactory.getLog(RegionCoprocessorRpcChannel.class);
    private final TableName table;
    private final byte[] row;
    private final ClusterConnection conn;
    private byte[] lastRegion;
    private final int operationTimeout;
    private final RpcRetryingCallerFactory rpcCallerFactory;

    RegionCoprocessorRpcChannel(ClusterConnection conn, TableName table, byte[] row) {
        this.table = table;
        this.row = row;
        this.conn = conn;
        this.operationTimeout = conn.getConnectionConfiguration().getOperationTimeout();
        this.rpcCallerFactory = conn.getRpcRetryingCallerFactory();
    }

    @Override
    protected Message callExecService(RpcController controller, final Descriptors.MethodDescriptor method, final Message request, Message responsePrototype) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Call: " + method.getName() + ", " + request.toString()));
        }
        if (this.row == null) {
            throw new NullPointerException("Can't be null!");
        }
        ClientServiceCallable<ClientProtos.CoprocessorServiceResponse> callable = new ClientServiceCallable<ClientProtos.CoprocessorServiceResponse>((Connection)this.conn, this.table, this.row, (RpcController)this.conn.getRpcControllerFactory().newController()){

            @Override
            protected ClientProtos.CoprocessorServiceResponse rpcCall() throws Exception {
                byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                ClientProtos.CoprocessorServiceRequest csr = CoprocessorRpcUtils.getCoprocessorServiceRequest(method, request, RegionCoprocessorRpcChannel.this.row, regionName);
                return ((ClientProtos.ClientService.BlockingInterface)this.getStub()).execService(this.getRpcController(), csr);
            }
        };
        ClientProtos.CoprocessorServiceResponse result = this.rpcCallerFactory.newCaller().callWithRetries(callable, this.operationTimeout);
        this.lastRegion = result.getRegion().getValue().toByteArray();
        return CoprocessorRpcUtils.getResponse(result, responsePrototype);
    }

    public byte[] getLastRegion() {
        return this.lastRegion;
    }
}

