/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
public class ConnectionConfiguration {
    public static final String WRITE_BUFFER_SIZE_KEY = "hbase.client.write.buffer";
    public static final long WRITE_BUFFER_SIZE_DEFAULT = 0x200000L;
    public static final String MAX_KEYVALUE_SIZE_KEY = "hbase.client.keyvalue.maxsize";
    public static final int MAX_KEYVALUE_SIZE_DEFAULT = -1;
    private final long writeBufferSize;
    private final int metaOperationTimeout;
    private final int operationTimeout;
    private final int scannerCaching;
    private final long scannerMaxResultSize;
    private final int primaryCallTimeoutMicroSecond;
    private final int replicaCallTimeoutMicroSecondScan;
    private final int metaReplicaCallTimeoutMicroSecondScan;
    private final int retries;
    private final int maxKeyValueSize;
    private final int rpcTimeout;
    private final int readRpcTimeout;
    private final int writeRpcTimeout;
    private final boolean clientScannerAsyncPrefetch;

    ConnectionConfiguration(Configuration conf) {
        this.writeBufferSize = conf.getLong(WRITE_BUFFER_SIZE_KEY, 0x200000L);
        this.metaOperationTimeout = conf.getInt("hbase.client.meta.operation.timeout", 1200000);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.scannerCaching = conf.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        this.scannerMaxResultSize = conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.primaryCallTimeoutMicroSecond = conf.getInt("hbase.client.primaryCallTimeout.get", 10000);
        this.replicaCallTimeoutMicroSecondScan = conf.getInt("hbase.client.replicaCallTimeout.scan", 1000000);
        this.metaReplicaCallTimeoutMicroSecondScan = conf.getInt("hbase.client.meta.replica.scan.timeout", 1000000);
        this.retries = conf.getInt("hbase.client.retries.number", 31);
        this.clientScannerAsyncPrefetch = conf.getBoolean("hbase.client.scanner.async.prefetch", false);
        this.maxKeyValueSize = conf.getInt(MAX_KEYVALUE_SIZE_KEY, -1);
        this.rpcTimeout = conf.getInt("hbase.rpc.timeout", 60000);
        this.readRpcTimeout = conf.getInt("hbase.rpc.read.timeout", conf.getInt("hbase.rpc.timeout", 60000));
        this.writeRpcTimeout = conf.getInt("hbase.rpc.write.timeout", conf.getInt("hbase.rpc.timeout", 60000));
    }

    @VisibleForTesting
    protected ConnectionConfiguration() {
        this.writeBufferSize = 0x200000L;
        this.metaOperationTimeout = 1200000;
        this.operationTimeout = 1200000;
        this.scannerCaching = Integer.MAX_VALUE;
        this.scannerMaxResultSize = 0x200000L;
        this.primaryCallTimeoutMicroSecond = 10000;
        this.replicaCallTimeoutMicroSecondScan = 1000000;
        this.metaReplicaCallTimeoutMicroSecondScan = 1000000;
        this.retries = 31;
        this.clientScannerAsyncPrefetch = false;
        this.maxKeyValueSize = -1;
        this.readRpcTimeout = 60000;
        this.writeRpcTimeout = 60000;
        this.rpcTimeout = 60000;
    }

    public int getReadRpcTimeout() {
        return this.readRpcTimeout;
    }

    public int getWriteRpcTimeout() {
        return this.writeRpcTimeout;
    }

    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public int getMetaOperationTimeout() {
        return this.metaOperationTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public int getScannerCaching() {
        return this.scannerCaching;
    }

    public int getPrimaryCallTimeoutMicroSecond() {
        return this.primaryCallTimeoutMicroSecond;
    }

    public int getReplicaCallTimeoutMicroSecondScan() {
        return this.replicaCallTimeoutMicroSecondScan;
    }

    public int getMetaReplicaCallTimeoutMicroSecondScan() {
        return this.metaReplicaCallTimeoutMicroSecondScan;
    }

    public int getRetriesNumber() {
        return this.retries;
    }

    public int getMaxKeyValueSize() {
        return this.maxKeyValueSize;
    }

    public long getScannerMaxResultSize() {
        return this.scannerMaxResultSize;
    }

    public boolean isClientScannerAsyncPrefetch() {
        return this.clientScannerAsyncPrefetch;
    }

    public int getRpcTimeout() {
        return this.rpcTimeout;
    }
}

