/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ClientSimpleScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public class ClientAsyncPrefetchScanner
extends ClientSimpleScanner {
    private static final int ESTIMATED_SINGLE_RESULT_SIZE = 1024;
    private static final int DEFAULT_QUEUE_CAPACITY = 1024;
    private int cacheCapacity;
    private AtomicLong cacheSizeInBytes;
    private Queue<Exception> exceptionsQueue;
    private PrefetchRunnable prefetchRunnable;
    private AtomicBoolean prefetchRunning;
    private AtomicLong closingThreadId;
    private Consumer<Boolean> prefetchListener;
    private static final int NO_THREAD = -1;

    public ClientAsyncPrefetchScanner(Configuration configuration, Scan scan, TableName name, ClusterConnection connection, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, ExecutorService pool, int replicaCallTimeoutMicroSecondScan) throws IOException {
        super(configuration, scan, name, connection, rpcCallerFactory, rpcControllerFactory, pool, replicaCallTimeoutMicroSecondScan);
    }

    @VisibleForTesting
    void setPrefetchListener(Consumer<Boolean> prefetchListener) {
        this.prefetchListener = prefetchListener;
    }

    @Override
    protected void initCache() {
        this.cacheCapacity = this.calcCacheCapacity();
        this.cache = new LinkedBlockingQueue();
        this.cacheSizeInBytes = new AtomicLong(0L);
        this.exceptionsQueue = new ConcurrentLinkedQueue<Exception>();
        this.prefetchRunnable = new PrefetchRunnable();
        this.prefetchRunning = new AtomicBoolean(false);
        this.closingThreadId = new AtomicLong(-1L);
    }

    @Override
    public Result next() throws IOException {
        try {
            boolean hasExecutedPrefetch = false;
            do {
                if (this.getCacheCount() == 0 && this.closed) {
                    Result result = null;
                    return result;
                }
                if (this.prefetchCondition() && !this.isPrefetchRunning() && this.prefetchRunning.compareAndSet(false, true)) {
                    this.getPool().execute(this.prefetchRunnable);
                    hasExecutedPrefetch = true;
                }
                while (this.isPrefetchRunning()) {
                    if (this.getCacheCount() > 0) {
                        Result result = this.pollCache();
                        return result;
                    }
                    Threads.sleep(1L);
                }
                if (this.getCacheCount() <= 0) continue;
                Result result = this.pollCache();
                return result;
            } while (!hasExecutedPrefetch);
            this.writeScanMetrics();
            Result result = null;
            return result;
        }
        finally {
            this.handleException();
        }
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        this.closed = true;
        if (!this.isPrefetchRunning() && this.closingThreadId.compareAndSet(-1L, Thread.currentThread().getId())) {
            super.close();
        }
    }

    @Override
    public int getCacheCount() {
        if (this.cache != null) {
            int size = this.cache.size();
            if (size > this.cacheCapacity) {
                this.cacheCapacity = size;
            }
            return size;
        }
        return 0;
    }

    @Override
    protected void addEstimatedSize(long estimatedSize) {
        this.cacheSizeInBytes.addAndGet(estimatedSize);
    }

    private void handleException() throws IOException {
        if (!this.exceptionsQueue.isEmpty()) {
            Exception first = this.exceptionsQueue.peek();
            first.printStackTrace();
            if (first instanceof IOException) {
                throw (IOException)first;
            }
            throw (RuntimeException)first;
        }
    }

    private boolean isPrefetchRunning() {
        return this.prefetchRunning.get();
    }

    private int calcCacheCapacity() {
        int capacity = Integer.MAX_VALUE;
        if (this.caching > 0 && this.caching < 0x3FFFFFFF) {
            capacity = this.caching * 2 + 1;
        }
        if (capacity == Integer.MAX_VALUE) {
            capacity = this.maxScannerResultSize != Integer.MAX_VALUE ? (int)(this.maxScannerResultSize / 1024L) : 1024;
        }
        return Math.max(capacity, 1);
    }

    private boolean prefetchCondition() {
        return this.getCacheCount() < this.getCountThreshold() && (this.maxScannerResultSize == Long.MAX_VALUE || this.getCacheSizeInBytes() < this.getSizeThreshold());
    }

    private int getCountThreshold() {
        return Math.max(this.cacheCapacity / 2, 1);
    }

    private long getSizeThreshold() {
        return Math.max(this.maxScannerResultSize / 2L, 1L);
    }

    private long getCacheSizeInBytes() {
        return this.cacheSizeInBytes.get();
    }

    private Result pollCache() {
        Result res = (Result)this.cache.poll();
        long estimatedSize = ConnectionUtils.calcEstimatedSize(res);
        this.addEstimatedSize(-estimatedSize);
        return res;
    }

    private class PrefetchRunnable
    implements Runnable {
        private PrefetchRunnable() {
        }

        @Override
        public void run() {
            boolean succeed = false;
            try {
                ClientAsyncPrefetchScanner.this.loadCache();
                succeed = true;
            }
            catch (Exception e) {
                ClientAsyncPrefetchScanner.this.exceptionsQueue.add(e);
            }
            finally {
                if (ClientAsyncPrefetchScanner.this.prefetchListener != null) {
                    ClientAsyncPrefetchScanner.this.prefetchListener.accept(succeed);
                }
                ClientAsyncPrefetchScanner.this.prefetchRunning.set(false);
                if (ClientAsyncPrefetchScanner.this.closed && ClientAsyncPrefetchScanner.this.closingThreadId.compareAndSet(-1L, Thread.currentThread().getId())) {
                    ClientAsyncPrefetchScanner.this.close();
                }
            }
        }
    }
}

