/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.AsyncMetaTableAccessor;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.hadoop.hbase.client.AsyncRegistryFactory;
import org.apache.hadoop.hbase.client.AsyncRpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RawAsyncTable;
import org.apache.hadoop.hbase.client.RawScanResultConsumer;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.replication.ReplicationSerDeHelper;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.hadoop.hbase.shaded.io.netty.util.Timeout;
import org.apache.hadoop.hbase.shaded.io.netty.util.TimerTask;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AsyncHBaseAdmin
implements AsyncAdmin {
    public static final String FLUSH_TABLE_PROCEDURE_SIGNATURE = "flush-table-proc";
    private static final Log LOG = LogFactory.getLog(AsyncHBaseAdmin.class);
    private final AsyncConnectionImpl connection;
    private final RawAsyncTable metaTable;
    private final long rpcTimeoutNs;
    private final long operationTimeoutNs;
    private final long pauseNs;
    private final int maxAttempts;
    private final int startLogErrorsCnt;
    private final NonceGenerator ng;

    AsyncHBaseAdmin(AsyncConnectionImpl connection) {
        this.connection = connection;
        this.metaTable = connection.getRawTable(TableName.META_TABLE_NAME);
        this.rpcTimeoutNs = connection.connConf.getRpcTimeoutNs();
        this.operationTimeoutNs = connection.connConf.getOperationTimeoutNs();
        this.pauseNs = connection.connConf.getPauseNs();
        this.maxAttempts = connection.connConf.getMaxRetries();
        this.startLogErrorsCnt = connection.connConf.getStartLogErrorsCnt();
        this.ng = connection.getNonceGenerator();
    }

    private <T> AsyncRpcRetryingCallerFactory.MasterRequestCallerBuilder<T> newMasterCaller() {
        return this.connection.callerFactory.masterRequest().rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.operationTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt);
    }

    private <T> AsyncRpcRetryingCallerFactory.AdminRequestCallerBuilder<T> newAdminCaller() {
        return this.connection.callerFactory.adminRequest().rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.operationTimeoutNs, TimeUnit.NANOSECONDS).pause(this.pauseNs, TimeUnit.NANOSECONDS).maxAttempts(this.maxAttempts).startLogErrorsCnt(this.startLogErrorsCnt);
    }

    private <PREQ, PRESP, RESP> CompletableFuture<RESP> call(final HBaseRpcController controller, MasterProtos.MasterService.Interface stub, PREQ preq, MasterRpcCall<PRESP, PREQ> rpcCall, final Converter<RESP, PRESP> respConverter) {
        final CompletableFuture future = new CompletableFuture();
        rpcCall.call(stub, controller, preq, new RpcCallback<PRESP>(){

            @Override
            public void run(PRESP resp) {
                if (controller.failed()) {
                    future.completeExceptionally(controller.getFailed());
                } else {
                    try {
                        future.complete(respConverter.convert(resp));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    private <PREQ, PRESP, RESP> CompletableFuture<RESP> adminCall(final HBaseRpcController controller, AdminProtos.AdminService.Interface stub, PREQ preq, AdminRpcCall<PRESP, PREQ> rpcCall, final Converter<RESP, PRESP> respConverter) {
        final CompletableFuture future = new CompletableFuture();
        rpcCall.call(stub, controller, preq, new RpcCallback<PRESP>(){

            @Override
            public void run(PRESP resp) {
                if (controller.failed()) {
                    future.completeExceptionally(new IOException(controller.errorText()));
                } else {
                    try {
                        future.complete(respConverter.convert(resp));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    private <PREQ, PRESP> CompletableFuture<Void> procedureCall(PREQ preq, MasterRpcCall<PRESP, PREQ> rpcCall, Converter<Long, PRESP> respConverter, ProcedureBiConsumer consumer) {
        CompletableFuture<Long> procFuture = this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, preq, rpcCall, respConverter)).call();
        return this.waitProcedureResult(procFuture).whenComplete((BiConsumer)consumer);
    }

    private CompletableFuture<TableDescriptor[]> batchTableOperations(Pattern pattern, TableOperator operator, String operationType) {
        CompletableFuture<TableDescriptor[]> future = new CompletableFuture<TableDescriptor[]>();
        LinkedList failed = new LinkedList();
        this.listTables(pattern, false).whenComplete((tables, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            CompletableFuture[] futures = (CompletableFuture[])Arrays.stream(tables).map(table -> operator.operate(table.getTableName()).whenComplete((v, ex) -> {
                if (ex != null) {
                    LOG.info((Object)("Failed to " + operationType + " table " + table.getTableName()), ex);
                    failed.add(table);
                }
            })).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).thenAccept(v -> future.complete(failed.toArray(new TableDescriptor[failed.size()])));
        });
        return future;
    }

    @Override
    public AsyncConnectionImpl getConnection() {
        return this.connection;
    }

    @Override
    public CompletableFuture<Boolean> tableExists(TableName tableName) {
        return AsyncMetaTableAccessor.tableExists(this.metaTable, tableName);
    }

    @Override
    public CompletableFuture<TableDescriptor[]> listTables() {
        return this.listTables((Pattern)null, false);
    }

    @Override
    public CompletableFuture<TableDescriptor[]> listTables(String regex, boolean includeSysTables) {
        return this.listTables(Pattern.compile(regex), false);
    }

    @Override
    public CompletableFuture<TableDescriptor[]> listTables(Pattern pattern, boolean includeSysTables) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetTableDescriptorsRequest(pattern, includeSysTables), (s, c, req, done) -> s.getTableDescriptors(c, (MasterProtos.GetTableDescriptorsRequest)req, done), resp -> ProtobufUtil.getTableDescriptorArray(resp))).call();
    }

    @Override
    public CompletableFuture<TableName[]> listTableNames() {
        return this.listTableNames((Pattern)null, false);
    }

    @Override
    public CompletableFuture<TableName[]> listTableNames(String regex, boolean includeSysTables) {
        return this.listTableNames(Pattern.compile(regex), false);
    }

    @Override
    public CompletableFuture<TableName[]> listTableNames(Pattern pattern, boolean includeSysTables) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetTableNamesRequest(pattern, includeSysTables), (s, c, req, done) -> s.getTableNames(c, (MasterProtos.GetTableNamesRequest)req, done), resp -> ProtobufUtil.getTableNameArray(resp.getTableNamesList()))).call();
    }

    @Override
    public CompletableFuture<TableDescriptor> getTableDescriptor(TableName tableName) {
        CompletableFuture<TableDescriptor> future = new CompletableFuture<TableDescriptor>();
        this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetTableDescriptorsRequest(tableName), (s, c, req, done) -> s.getTableDescriptors(c, (MasterProtos.GetTableDescriptorsRequest)req, done), resp -> resp.getTableSchemaList())).call().whenComplete((tableSchemas, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (!tableSchemas.isEmpty()) {
                future.complete(ProtobufUtil.convertToTableDesc((HBaseProtos.TableSchema)tableSchemas.get(0)));
            } else {
                future.completeExceptionally(new TableNotFoundException(tableName.getNameAsString()));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> createTable(TableDescriptor desc) {
        return this.createTable(desc, null);
    }

    @Override
    public CompletableFuture<Void> createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) {
        try {
            return this.createTable(desc, this.getSplitKeys(startKey, endKey, numRegions));
        }
        catch (IllegalArgumentException e) {
            return this.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<Void> createTable(TableDescriptor desc, byte[][] splitKeys) {
        if (desc.getTableName() == null) {
            return this.failedFuture(new IllegalArgumentException("TableName cannot be null"));
        }
        if (splitKeys != null && splitKeys.length > 0) {
            Arrays.sort(splitKeys, Bytes.BYTES_COMPARATOR);
            byte[] lastKey = null;
            for (byte[] splitKey : splitKeys) {
                if (Bytes.compareTo(splitKey, HConstants.EMPTY_BYTE_ARRAY) == 0) {
                    return this.failedFuture(new IllegalArgumentException("Empty split key must not be passed in the split keys."));
                }
                if (lastKey != null && Bytes.equals(splitKey, lastKey)) {
                    return this.failedFuture(new IllegalArgumentException("All split keys must be unique, found duplicate: " + Bytes.toStringBinary(splitKey) + ", " + Bytes.toStringBinary(lastKey)));
                }
                lastKey = splitKey;
            }
        }
        return this.procedureCall(RequestConverter.buildCreateTableRequest(desc, splitKeys, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.createTable(c, (MasterProtos.CreateTableRequest)req, done), resp -> resp.getProcId(), new CreateTableProcedureBiConsumer(this, desc.getTableName()));
    }

    @Override
    public CompletableFuture<Void> deleteTable(TableName tableName) {
        return this.procedureCall(RequestConverter.buildDeleteTableRequest(tableName, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.deleteTable(c, (MasterProtos.DeleteTableRequest)req, done), resp -> resp.getProcId(), new DeleteTableProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<TableDescriptor[]> deleteTables(String regex) {
        return this.deleteTables(Pattern.compile(regex));
    }

    @Override
    public CompletableFuture<TableDescriptor[]> deleteTables(Pattern pattern) {
        return this.batchTableOperations(pattern, table -> this.deleteTable(table), "DELETE");
    }

    @Override
    public CompletableFuture<Void> truncateTable(TableName tableName, boolean preserveSplits) {
        return this.procedureCall(RequestConverter.buildTruncateTableRequest(tableName, preserveSplits, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.truncateTable(c, (MasterProtos.TruncateTableRequest)req, done), resp -> resp.getProcId(), new TruncateTableProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<Void> enableTable(TableName tableName) {
        return this.procedureCall(RequestConverter.buildEnableTableRequest(tableName, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.enableTable(c, (MasterProtos.EnableTableRequest)req, done), resp -> resp.getProcId(), new EnableTableProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<TableDescriptor[]> enableTables(String regex) {
        return this.enableTables(Pattern.compile(regex));
    }

    @Override
    public CompletableFuture<TableDescriptor[]> enableTables(Pattern pattern) {
        return this.batchTableOperations(pattern, table -> this.enableTable(table), "ENABLE");
    }

    @Override
    public CompletableFuture<Void> disableTable(TableName tableName) {
        return this.procedureCall(RequestConverter.buildDisableTableRequest(tableName, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.disableTable(c, (MasterProtos.DisableTableRequest)req, done), resp -> resp.getProcId(), new DisableTableProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<TableDescriptor[]> disableTables(String regex) {
        return this.disableTables(Pattern.compile(regex));
    }

    @Override
    public CompletableFuture<TableDescriptor[]> disableTables(Pattern pattern) {
        return this.batchTableOperations(pattern, table -> this.disableTable(table), "DISABLE");
    }

    @Override
    public CompletableFuture<Boolean> isTableEnabled(TableName tableName) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        AsyncMetaTableAccessor.getTableState(this.metaTable, tableName).whenComplete((state, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (state.isPresent()) {
                future.complete(((TableState)state.get()).inStates(TableState.State.ENABLED));
            } else {
                future.completeExceptionally(new TableNotFoundException(tableName));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Boolean> isTableDisabled(TableName tableName) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        AsyncMetaTableAccessor.getTableState(this.metaTable, tableName).whenComplete((state, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (state.isPresent()) {
                future.complete(((TableState)state.get()).inStates(TableState.State.DISABLED));
            } else {
                future.completeExceptionally(new TableNotFoundException(tableName));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Boolean> isTableAvailable(TableName tableName) {
        return this.isTableAvailable(tableName, null);
    }

    @Override
    public CompletableFuture<Boolean> isTableAvailable(TableName tableName, byte[][] splitKeys) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        this.isTableEnabled(tableName).whenComplete((enabled, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (!enabled.booleanValue()) {
                future.complete(false);
            } else {
                AsyncMetaTableAccessor.getTableRegionsAndLocations(this.metaTable, Optional.of(tableName)).whenComplete((locations, error1) -> {
                    if (error1 != null) {
                        future.completeExceptionally((Throwable)error1);
                        return;
                    }
                    int notDeployed = 0;
                    int regionCount = 0;
                    block0: for (Pair pair : locations) {
                        HRegionInfo info = (HRegionInfo)pair.getFirst();
                        if (pair.getSecond() == null) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Table " + tableName + " has not deployed region " + ((HRegionInfo)pair.getFirst()).getEncodedName()));
                            }
                            ++notDeployed;
                            continue;
                        }
                        if (splitKeys != null && !Bytes.equals(info.getStartKey(), HConstants.EMPTY_BYTE_ARRAY)) {
                            for (byte[] splitKey : splitKeys) {
                                if (!Bytes.equals(info.getStartKey(), splitKey)) continue;
                                ++regionCount;
                                continue block0;
                            }
                            continue;
                        }
                        ++regionCount;
                    }
                    if (notDeployed > 0) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Table " + tableName + " has " + notDeployed + " regions"));
                        }
                        future.complete(false);
                    } else if (splitKeys != null && regionCount != splitKeys.length + 1) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Table " + tableName + " expected to have " + (splitKeys.length + 1) + " regions, but only " + regionCount + " available"));
                        }
                        future.complete(false);
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Table " + tableName + " should be available"));
                        }
                        future.complete(true);
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Pair<Integer, Integer>> getAlterStatus(TableName tableName) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetSchemaAlterStatusRequest(tableName), (s, c, req, done) -> s.getSchemaAlterStatus(c, (MasterProtos.GetSchemaAlterStatusRequest)req, done), resp -> new Pair<Integer, Integer>(resp.getYetToUpdateRegions(), resp.getTotalRegions()))).call();
    }

    @Override
    public CompletableFuture<Void> addColumnFamily(TableName tableName, HColumnDescriptor columnFamily) {
        return this.procedureCall(RequestConverter.buildAddColumnRequest(tableName, columnFamily, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.addColumn(c, (MasterProtos.AddColumnRequest)req, done), resp -> resp.getProcId(), new AddColumnFamilyProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<Void> deleteColumnFamily(TableName tableName, byte[] columnFamily) {
        return this.procedureCall(RequestConverter.buildDeleteColumnRequest(tableName, columnFamily, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.deleteColumn(c, (MasterProtos.DeleteColumnRequest)req, done), resp -> resp.getProcId(), new DeleteColumnFamilyProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<Void> modifyColumnFamily(TableName tableName, HColumnDescriptor columnFamily) {
        return this.procedureCall(RequestConverter.buildModifyColumnRequest(tableName, columnFamily, this.ng.getNonceGroup(), this.ng.newNonce()), (s, c, req, done) -> s.modifyColumn(c, (MasterProtos.ModifyColumnRequest)req, done), resp -> resp.getProcId(), new ModifyColumnFamilyProcedureBiConsumer(this, tableName));
    }

    @Override
    public CompletableFuture<Void> createNamespace(NamespaceDescriptor descriptor) {
        return this.procedureCall(RequestConverter.buildCreateNamespaceRequest(descriptor), (s, c, req, done) -> s.createNamespace(c, (MasterProtos.CreateNamespaceRequest)req, done), resp -> resp.getProcId(), new CreateNamespaceProcedureBiConsumer(this, descriptor.getName()));
    }

    @Override
    public CompletableFuture<Void> modifyNamespace(NamespaceDescriptor descriptor) {
        return this.procedureCall(RequestConverter.buildModifyNamespaceRequest(descriptor), (s, c, req, done) -> s.modifyNamespace(c, (MasterProtos.ModifyNamespaceRequest)req, done), resp -> resp.getProcId(), new ModifyNamespaceProcedureBiConsumer(this, descriptor.getName()));
    }

    @Override
    public CompletableFuture<Void> deleteNamespace(String name) {
        return this.procedureCall(RequestConverter.buildDeleteNamespaceRequest(name), (s, c, req, done) -> s.deleteNamespace(c, (MasterProtos.DeleteNamespaceRequest)req, done), resp -> resp.getProcId(), new DeleteNamespaceProcedureBiConsumer(this, name));
    }

    @Override
    public CompletableFuture<NamespaceDescriptor> getNamespaceDescriptor(String name) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetNamespaceDescriptorRequest(name), (s, c, req, done) -> s.getNamespaceDescriptor(c, (MasterProtos.GetNamespaceDescriptorRequest)req, done), resp -> ProtobufUtil.toNamespaceDescriptor(resp.getNamespaceDescriptor()))).call();
    }

    @Override
    public CompletableFuture<NamespaceDescriptor[]> listNamespaceDescriptors() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.ListNamespaceDescriptorsRequest.newBuilder().build(), (s, c, req, done) -> s.listNamespaceDescriptors(c, (MasterProtos.ListNamespaceDescriptorsRequest)req, done), resp -> ProtobufUtil.getNamespaceDescriptorArray(resp))).call();
    }

    @Override
    public CompletableFuture<Boolean> setBalancerRunning(boolean on) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildSetBalancerRunningRequest(on, true), (s, c, req, done) -> s.setBalancerRunning(c, (MasterProtos.SetBalancerRunningRequest)req, done), resp -> resp.getPrevBalanceValue())).call();
    }

    @Override
    public CompletableFuture<Boolean> balancer() {
        return this.balancer(false);
    }

    @Override
    public CompletableFuture<Boolean> balancer(boolean force) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildBalanceRequest(force), (s, c, req, done) -> s.balance(c, (MasterProtos.BalanceRequest)req, done), resp -> resp.getBalancerRan())).call();
    }

    @Override
    public CompletableFuture<Boolean> isBalancerEnabled() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildIsBalancerEnabledRequest(), (s, c, req, done) -> s.isBalancerEnabled(c, (MasterProtos.IsBalancerEnabledRequest)req, done), resp -> resp.getEnabled())).call();
    }

    @Override
    public CompletableFuture<Void> closeRegion(String regionname, String serverName) {
        return this.closeRegion(Bytes.toBytes(regionname), serverName);
    }

    @Override
    public CompletableFuture<Void> closeRegion(byte[] regionName, String serverName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegion(regionName).whenComplete((p, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            if (p == null || p.getFirst() == null) {
                future.completeExceptionally(new UnknownRegionException(Bytes.toStringBinary(regionName)));
                return;
            }
            if (serverName != null) {
                this.closeRegion(ServerName.valueOf(serverName), (HRegionInfo)p.getFirst()).whenComplete((p2, err2) -> {
                    if (err2 != null) {
                        future.completeExceptionally((Throwable)err2);
                    } else {
                        future.complete(null);
                    }
                });
            } else if (p.getSecond() == null) {
                future.completeExceptionally(new NotServingRegionException(regionName));
            } else {
                this.closeRegion((ServerName)p.getSecond(), (HRegionInfo)p.getFirst()).whenComplete((p2, err2) -> {
                    if (err2 != null) {
                        future.completeExceptionally((Throwable)err2);
                    } else {
                        future.complete(null);
                    }
                });
            }
        });
        return future;
    }

    CompletableFuture<Pair<HRegionInfo, ServerName>> getRegion(byte[] regionName) {
        if (regionName == null) {
            return this.failedFuture(new IllegalArgumentException("Pass region name"));
        }
        CompletableFuture<Pair<HRegionInfo, ServerName>> future = new CompletableFuture<Pair<HRegionInfo, ServerName>>();
        AsyncMetaTableAccessor.getRegion(this.metaTable, regionName).whenComplete((p, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else if (p != null) {
                future.complete((Pair<HRegionInfo, ServerName>)p);
            } else {
                this.metaTable.scanAll(new Scan().setReadType(Scan.ReadType.PREAD).addFamily(HConstants.CATALOG_FAMILY)).whenComplete((results, err2) -> {
                    if (err2 != null) {
                        future.completeExceptionally((Throwable)err2);
                        return;
                    }
                    String encodedName = Bytes.toString(regionName);
                    if (results != null && !results.isEmpty()) {
                        for (Result r : results) {
                            RegionLocations rl;
                            if (r.isEmpty() || MetaTableAccessor.getHRegionInfo(r) == null || (rl = MetaTableAccessor.getRegionLocations(r)) == null) continue;
                            for (HRegionLocation h : rl.getRegionLocations()) {
                                if (h == null || !encodedName.equals(h.getRegionInfo().getEncodedName())) continue;
                                future.complete(new Pair<HRegionInfo, ServerName>(h.getRegionInfo(), h.getServerName()));
                                return;
                            }
                        }
                    }
                    future.complete(null);
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Boolean> closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) {
        return this.newAdminCaller().action((controller, stub) -> this.adminCall(controller, stub, ProtobufUtil.buildCloseRegionRequest(ServerName.valueOf(serverName), encodedRegionName), (s, c, req, done) -> s.closeRegion(controller, (AdminProtos.CloseRegionRequest)req, done), resp -> resp.getClosed())).serverName(ServerName.valueOf(serverName)).call();
    }

    @Override
    public CompletableFuture<Void> closeRegion(ServerName sn, HRegionInfo hri) {
        return this.newAdminCaller().action((controller, stub) -> this.adminCall(controller, stub, ProtobufUtil.buildCloseRegionRequest(sn, hri.getRegionName()), (s, c, req, done) -> s.closeRegion(controller, (AdminProtos.CloseRegionRequest)req, done), resp -> null)).serverName(sn).call();
    }

    @Override
    public CompletableFuture<List<HRegionInfo>> getOnlineRegions(ServerName sn) {
        return this.newAdminCaller().action((controller, stub) -> this.adminCall(controller, stub, RequestConverter.buildGetOnlineRegionRequest(), (s, c, req, done) -> s.getOnlineRegion(c, (AdminProtos.GetOnlineRegionRequest)req, done), resp -> ProtobufUtil.getRegionInfos(resp))).serverName(sn).call();
    }

    @Override
    public CompletableFuture<Void> flush(TableName tableName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.tableExists(tableName).whenComplete((exists, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else if (!exists.booleanValue()) {
                future.completeExceptionally(new TableNotFoundException(tableName));
            } else {
                this.isTableEnabled(tableName).whenComplete((tableEnabled, err2) -> {
                    if (err2 != null) {
                        future.completeExceptionally((Throwable)err2);
                    } else if (!tableEnabled.booleanValue()) {
                        future.completeExceptionally(new TableNotEnabledException(tableName));
                    } else {
                        this.execProcedure(FLUSH_TABLE_PROCEDURE_SIGNATURE, tableName.getNameAsString(), new HashMap<String, String>()).whenComplete((ret, err3) -> {
                            if (err3 != null) {
                                future.completeExceptionally((Throwable)err3);
                            } else {
                                future.complete((Void)ret);
                            }
                        });
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> flushRegion(byte[] regionName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegion(regionName).whenComplete((p, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            if (p == null || p.getFirst() == null) {
                future.completeExceptionally(new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary(regionName)));
                return;
            }
            if (p.getSecond() == null) {
                future.completeExceptionally(new NoServerForRegionException(Bytes.toStringBinary(regionName)));
                return;
            }
            this.newAdminCaller().serverName((ServerName)p.getSecond()).action((controller, stub) -> this.adminCall(controller, stub, RequestConverter.buildFlushRegionRequest(((HRegionInfo)p.getFirst()).getRegionName()), (s, c, req, done) -> s.flushRegion(c, (AdminProtos.FlushRegionRequest)req, done), resp -> null)).call().whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> compact(TableName tableName) {
        return this.compact(tableName, null, false, CompactType.NORMAL);
    }

    @Override
    public CompletableFuture<Void> compact(TableName tableName, byte[] columnFamily) {
        return this.compact(tableName, columnFamily, false, CompactType.NORMAL);
    }

    @Override
    public CompletableFuture<Void> compactRegion(byte[] regionName) {
        return this.compactRegion(regionName, null, false);
    }

    @Override
    public CompletableFuture<Void> compactRegion(byte[] regionName, byte[] columnFamily) {
        return this.compactRegion(regionName, columnFamily, false);
    }

    @Override
    public CompletableFuture<Void> majorCompact(TableName tableName) {
        return this.compact(tableName, null, true, CompactType.NORMAL);
    }

    @Override
    public CompletableFuture<Void> majorCompact(TableName tableName, byte[] columnFamily) {
        return this.compact(tableName, columnFamily, true, CompactType.NORMAL);
    }

    @Override
    public CompletableFuture<Void> majorCompactRegion(byte[] regionName) {
        return this.compactRegion(regionName, null, true);
    }

    @Override
    public CompletableFuture<Void> majorCompactRegion(byte[] regionName, byte[] columnFamily) {
        return this.compactRegion(regionName, columnFamily, true);
    }

    @Override
    public CompletableFuture<Void> compactRegionServer(ServerName sn) {
        return this.compactRegionServer(sn, false);
    }

    @Override
    public CompletableFuture<Void> majorCompactRegionServer(ServerName sn) {
        return this.compactRegionServer(sn, true);
    }

    private CompletableFuture<Void> compactRegionServer(ServerName sn, boolean major) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getOnlineRegions(sn).whenComplete((hRegionInfos, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            ArrayList compactFutures = new ArrayList();
            if (hRegionInfos != null) {
                hRegionInfos.forEach(region -> compactFutures.add(this.compact(sn, (HRegionInfo)region, major, null)));
            }
            CompletableFuture.allOf(compactFutures.toArray(new CompletableFuture[compactFutures.size()])).whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    private CompletableFuture<Void> compactRegion(byte[] regionName, byte[] columnFamily, boolean major) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegion(regionName).whenComplete((p, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            if (p == null || p.getFirst() == null) {
                future.completeExceptionally(new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary(regionName)));
                return;
            }
            if (p.getSecond() == null) {
                future.completeExceptionally(new NoServerForRegionException(Bytes.toStringBinary(regionName)));
                return;
            }
            this.compact((ServerName)p.getSecond(), (HRegionInfo)p.getFirst(), major, columnFamily).whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    private CompletableFuture<List<HRegionLocation>> getTableHRegionLocations(TableName tableName) {
        CompletableFuture<List<HRegionLocation>> future = new CompletableFuture<List<HRegionLocation>>();
        if (TableName.META_TABLE_NAME.equals(tableName)) {
            AsyncRegistry registry = AsyncRegistryFactory.getRegistry(this.connection.getConfiguration());
            registry.getMetaRegionLocation().whenComplete((metaRegions, err) -> {
                if (err != null) {
                    future.completeExceptionally((Throwable)err);
                } else if (metaRegions == null || metaRegions.isEmpty() || metaRegions.getDefaultRegionLocation() == null) {
                    future.completeExceptionally(new IOException("meta region does not found"));
                } else {
                    future.complete(Collections.singletonList(metaRegions.getDefaultRegionLocation()));
                }
                IOUtils.closeQuietly(registry);
            });
        } else {
            AsyncMetaTableAccessor.getTableRegionsAndLocations(this.metaTable, Optional.of(tableName)).whenComplete((locations, err) -> {
                if (err != null) {
                    future.completeExceptionally((Throwable)err);
                } else if (locations == null || locations.isEmpty()) {
                    future.complete(Collections.emptyList());
                } else {
                    List regionLocations = locations.stream().map(loc -> new HRegionLocation((HRegionInfo)loc.getFirst(), (ServerName)loc.getSecond())).collect(Collectors.toList());
                    future.complete(regionLocations);
                }
            });
        }
        return future;
    }

    private CompletableFuture<Void> compact(TableName tableName, byte[] columnFamily, boolean major, CompactType compactType) {
        if (CompactType.MOB.equals((Object)compactType)) {
            return this.failedFuture(new UnsupportedOperationException("MOB compact does not support"));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getTableHRegionLocations(tableName).whenComplete((locations, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            ArrayList<CompletableFuture<Void>> compactFutures = new ArrayList<CompletableFuture<Void>>();
            for (HRegionLocation location : locations) {
                if (location.getRegionInfo() == null || location.getRegionInfo().isOffline() || location.getServerName() == null) continue;
                compactFutures.add(this.compact(location.getServerName(), location.getRegionInfo(), major, columnFamily));
            }
            CompletableFuture.allOf(compactFutures.toArray(new CompletableFuture[compactFutures.size()])).whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    private CompletableFuture<Void> compact(ServerName sn, HRegionInfo hri, boolean major, byte[] family) {
        return this.newAdminCaller().serverName(sn).action((controller, stub) -> this.adminCall(controller, stub, RequestConverter.buildCompactRegionRequest(hri.getRegionName(), major, family), (s, c, req, done) -> s.compactRegion(c, (AdminProtos.CompactRegionRequest)req, done), resp -> null)).call();
    }

    private byte[] toEncodeRegionName(byte[] regionName) {
        try {
            return HRegionInfo.isEncodedRegionName(regionName) ? regionName : Bytes.toBytes(HRegionInfo.encodeRegionName(regionName));
        }
        catch (IOException e) {
            return regionName;
        }
    }

    private void checkAndGetTableName(byte[] encodeRegionName, AtomicReference<TableName> tableName, CompletableFuture<TableName> result) {
        this.getRegion(encodeRegionName).whenComplete((p, err) -> {
            if (err != null) {
                result.completeExceptionally((Throwable)err);
                return;
            }
            if (p == null) {
                result.completeExceptionally(new UnknownRegionException("Can't invoke merge on unknown region " + Bytes.toStringBinary(encodeRegionName)));
                return;
            }
            if (((HRegionInfo)p.getFirst()).getReplicaId() != 0) {
                result.completeExceptionally(new IllegalArgumentException("Can't invoke merge on non-default regions directly"));
                return;
            }
            if (!tableName.compareAndSet(null, ((HRegionInfo)p.getFirst()).getTable())) {
                if (!((TableName)tableName.get()).equals(((HRegionInfo)p.getFirst()).getTable())) {
                    result.completeExceptionally(new IllegalArgumentException("Cannot merge regions from two different tables " + tableName.get() + " and " + ((HRegionInfo)p.getFirst()).getTable()));
                } else {
                    result.complete((TableName)tableName.get());
                }
            }
        });
    }

    private CompletableFuture<TableName> checkRegionsAndGetTableName(byte[] encodeRegionNameA, byte[] encodeRegionNameB) {
        AtomicReference<TableName> tableNameRef = new AtomicReference<TableName>();
        CompletableFuture<TableName> future = new CompletableFuture<TableName>();
        this.checkAndGetTableName(encodeRegionNameA, tableNameRef, future);
        this.checkAndGetTableName(encodeRegionNameB, tableNameRef, future);
        return future;
    }

    @Override
    public CompletableFuture<Void> mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        byte[] encodeRegionNameA = this.toEncodeRegionName(nameOfRegionA);
        byte[] encodeRegionNameB = this.toEncodeRegionName(nameOfRegionB);
        this.checkRegionsAndGetTableName(encodeRegionNameA, encodeRegionNameB).whenComplete((tableName, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            MasterProtos.MergeTableRegionsRequest request = null;
            try {
                request = RequestConverter.buildMergeTableRegionsRequest(new byte[][]{encodeRegionNameA, encodeRegionNameB}, forcible, this.ng.getNonceGroup(), this.ng.newNonce());
            }
            catch (DeserializationException e) {
                future.completeExceptionally(e);
                return;
            }
            this.procedureCall(request, (s, c, req, done) -> s.mergeTableRegions(c, (MasterProtos.MergeTableRegionsRequest)req, done), resp -> resp.getProcId(), new MergeTableRegionProcedureBiConsumer(this, (TableName)tableName)).whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> split(TableName tableName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.tableExists(tableName).whenComplete((exist, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            if (!exist.booleanValue()) {
                future.completeExceptionally(new TableNotFoundException(tableName));
                return;
            }
            this.metaTable.scanAll(new Scan().setReadType(Scan.ReadType.PREAD).addFamily(HConstants.CATALOG_FAMILY).withStartRow(MetaTableAccessor.getTableStartRowForMeta(tableName, MetaTableAccessor.QueryType.REGION)).withStopRow(MetaTableAccessor.getTableStopRowForMeta(tableName, MetaTableAccessor.QueryType.REGION))).whenComplete((results, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                    return;
                }
                if (results != null && !results.isEmpty()) {
                    ArrayList<CompletableFuture<Void>> splitFutures = new ArrayList<CompletableFuture<Void>>();
                    for (Result r : results) {
                        RegionLocations rl;
                        if (r.isEmpty() || MetaTableAccessor.getHRegionInfo(r) == null || (rl = MetaTableAccessor.getRegionLocations(r)) == null) continue;
                        for (HRegionLocation h : rl.getRegionLocations()) {
                            HRegionInfo hri;
                            if (h == null || h.getServerName() == null || (hri = h.getRegionInfo()) == null || hri.isSplitParent() || hri.getReplicaId() != 0) continue;
                            splitFutures.add(this.split(h.getServerName(), hri, null));
                        }
                    }
                    CompletableFuture.allOf(splitFutures.toArray(new CompletableFuture[splitFutures.size()])).whenComplete((ret, exception) -> {
                        if (exception != null) {
                            future.completeExceptionally((Throwable)exception);
                            return;
                        }
                        future.complete((Void)ret);
                    });
                } else {
                    future.complete(null);
                }
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> splitRegion(byte[] regionName) {
        return this.splitRegion(regionName, null);
    }

    @Override
    public CompletableFuture<Void> split(TableName tableName, byte[] splitPoint) {
        CompletableFuture<Void> result = new CompletableFuture<Void>();
        if (splitPoint == null) {
            return this.failedFuture(new IllegalArgumentException("splitPoint can not be null."));
        }
        this.connection.getRegionLocator(tableName).getRegionLocation(splitPoint).whenComplete((loc, err) -> {
            if (err != null) {
                result.completeExceptionally((Throwable)err);
            } else if (loc == null || loc.getRegionInfo() == null) {
                result.completeExceptionally(new IllegalArgumentException("Region does not found: rowKey=" + Bytes.toStringBinary(splitPoint)));
            } else {
                this.splitRegion(loc.getRegionInfo().getRegionName(), splitPoint).whenComplete((ret, err2) -> {
                    if (err2 != null) {
                        result.completeExceptionally((Throwable)err2);
                    } else {
                        result.complete((Void)ret);
                    }
                });
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<Void> splitRegion(byte[] regionName, byte[] splitPoint) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegion(regionName).whenComplete((p, err) -> {
            if (p == null) {
                future.completeExceptionally(new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary(regionName)));
                return;
            }
            if (p.getFirst() != null && ((HRegionInfo)p.getFirst()).getReplicaId() != 0) {
                future.completeExceptionally(new IllegalArgumentException("Can't split replicas directly. Replicas are auto-split when their primary is split."));
                return;
            }
            if (p.getSecond() == null) {
                future.completeExceptionally(new NoServerForRegionException(Bytes.toStringBinary(regionName)));
                return;
            }
            this.split((ServerName)p.getSecond(), (HRegionInfo)p.getFirst(), splitPoint).whenComplete((ret, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else {
                    future.complete((Void)ret);
                }
            });
        });
        return future;
    }

    @VisibleForTesting
    public CompletableFuture<Void> split(ServerName sn, HRegionInfo hri, byte[] splitPoint) {
        if (hri.getStartKey() != null && splitPoint != null && Bytes.compareTo(hri.getStartKey(), splitPoint) == 0) {
            return this.failedFuture(new IllegalArgumentException("should not give a splitkey which equals to startkey!"));
        }
        return this.newAdminCaller().action((controller, stub) -> this.adminCall(controller, stub, ProtobufUtil.buildSplitRegionRequest(hri.getRegionName(), splitPoint), (s, c, req, done) -> s.splitRegion(controller, (AdminProtos.SplitRegionRequest)req, done), resp -> null)).serverName(sn).call();
    }

    CompletableFuture<byte[]> getRegionName(byte[] regionNameOrEncodedRegionName) {
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        if (Bytes.equals(regionNameOrEncodedRegionName, HRegionInfo.FIRST_META_REGIONINFO.getRegionName()) || Bytes.equals(regionNameOrEncodedRegionName, HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes())) {
            future.complete(HRegionInfo.FIRST_META_REGIONINFO.getRegionName());
            return future;
        }
        this.getRegion(regionNameOrEncodedRegionName).whenComplete((p, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            }
            if (p != null && p.getFirst() != null) {
                future.complete(((HRegionInfo)p.getFirst()).getRegionName());
            } else {
                future.completeExceptionally(new IllegalArgumentException("Invalid region name or encoded region name: " + Bytes.toStringBinary(regionNameOrEncodedRegionName)));
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> assign(byte[] regionName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegionName(regionName).whenComplete((fullRegionName, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else {
                this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildAssignRegionRequest(fullRegionName), (s, c, req, done) -> s.assignRegion(c, (MasterProtos.AssignRegionRequest)req, done), resp -> null)).call().whenComplete((ret, err2) -> {
                    if (err2 != null) {
                        future.completeExceptionally((Throwable)err2);
                    } else {
                        future.complete((Void)ret);
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> unassign(byte[] regionName, boolean force) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegionName(regionName).whenComplete((fullRegionName, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else {
                this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildUnassignRegionRequest(fullRegionName, force), (s, c, req, done) -> s.unassignRegion(c, (MasterProtos.UnassignRegionRequest)req, done), resp -> null)).call().whenComplete((ret, err2) -> {
                    if (err2 != null) {
                        future.completeExceptionally((Throwable)err2);
                    } else {
                        future.complete((Void)ret);
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> offline(byte[] regionName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegionName(regionName).whenComplete((fullRegionName, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else {
                this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildOfflineRegionRequest(fullRegionName), (s, c, req, done) -> s.offlineRegion(c, (MasterProtos.OfflineRegionRequest)req, done), resp -> null)).call().whenComplete((ret, err2) -> {
                    if (err2 != null) {
                        future.completeExceptionally((Throwable)err2);
                    } else {
                        future.complete((Void)ret);
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> move(byte[] regionName, byte[] destServerName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getRegionName(regionName).whenComplete((fullRegionName, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else {
                MasterProtos.MoveRegionRequest request;
                try {
                    request = RequestConverter.buildMoveRegionRequest(Bytes.toBytes(HRegionInfo.encodeRegionName(fullRegionName)), destServerName);
                }
                catch (DeserializationException e) {
                    future.completeExceptionally(e);
                    return;
                }
                this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, request, (s, c, req, done) -> s.moveRegion(c, (MasterProtos.MoveRegionRequest)req, done), resp -> null)).call().whenComplete((ret, err2) -> {
                    if (err2 != null) {
                        future.completeExceptionally((Throwable)err2);
                    } else {
                        future.complete((Void)ret);
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> setQuota(QuotaSettings quota) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, QuotaSettings.buildSetQuotaRequestProto(quota), (s, c, req, done) -> s.setQuota(c, (MasterProtos.SetQuotaRequest)req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<List<QuotaSettings>> getQuota(QuotaFilter filter) {
        final CompletableFuture<List<QuotaSettings>> future = new CompletableFuture<List<QuotaSettings>>();
        Scan scan = QuotaTableUtil.makeScan(filter);
        this.connection.getRawTableBuilder(QuotaTableUtil.QUOTA_TABLE_NAME).build().scan(scan, new RawScanResultConsumer(){
            List<QuotaSettings> settings = new ArrayList<QuotaSettings>();

            @Override
            public void onNext(Result[] results, RawScanResultConsumer.ScanController controller) {
                for (Result result : results) {
                    try {
                        QuotaTableUtil.parseResultToCollection(result, this.settings);
                    }
                    catch (IOException e) {
                        controller.terminate();
                        future.completeExceptionally(e);
                    }
                }
            }

            @Override
            public void onError(Throwable error) {
                future.completeExceptionally(error);
            }

            @Override
            public void onComplete() {
                future.complete(this.settings);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildAddReplicationPeerRequest(peerId, peerConfig), (s, c, req, done) -> s.addReplicationPeer(c, (ReplicationProtos.AddReplicationPeerRequest)req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<Void> removeReplicationPeer(String peerId) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildRemoveReplicationPeerRequest(peerId), (s, c, req, done) -> s.removeReplicationPeer(c, (ReplicationProtos.RemoveReplicationPeerRequest)req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<Void> enableReplicationPeer(String peerId) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildEnableReplicationPeerRequest(peerId), (s, c, req, done) -> s.enableReplicationPeer(c, (ReplicationProtos.EnableReplicationPeerRequest)req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<Void> disableReplicationPeer(String peerId) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildDisableReplicationPeerRequest(peerId), (s, c, req, done) -> s.disableReplicationPeer(c, (ReplicationProtos.DisableReplicationPeerRequest)req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<ReplicationPeerConfig> getReplicationPeerConfig(String peerId) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildGetReplicationPeerConfigRequest(peerId), (s, c, req, done) -> s.getReplicationPeerConfig(c, (ReplicationProtos.GetReplicationPeerConfigRequest)req, done), resp -> ReplicationSerDeHelper.convert(resp.getPeerConfig()))).call();
    }

    @Override
    public CompletableFuture<Void> updateReplicationPeerConfig(String peerId, ReplicationPeerConfig peerConfig) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildUpdateReplicationPeerConfigRequest(peerId, peerConfig), (s, c, req, done) -> s.updateReplicationPeerConfig(c, (ReplicationProtos.UpdateReplicationPeerConfigRequest)req, done), resp -> null)).call();
    }

    @Override
    public CompletableFuture<Void> appendReplicationPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) {
        if (tableCfs == null) {
            return this.failedFuture(new ReplicationException("tableCfs is null"));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getReplicationPeerConfig(id).whenComplete((peerConfig, error) -> {
            if (!this.completeExceptionally(future, (Throwable)error)) {
                ReplicationSerDeHelper.appendTableCFsToReplicationPeerConfig(tableCfs, peerConfig);
                this.updateReplicationPeerConfig(id, (ReplicationPeerConfig)peerConfig).whenComplete((result, err) -> {
                    if (!this.completeExceptionally(future, (Throwable)error)) {
                        future.complete((Void)result);
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> removeReplicationPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) {
        if (tableCfs == null) {
            return this.failedFuture(new ReplicationException("tableCfs is null"));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.getReplicationPeerConfig(id).whenComplete((peerConfig, error) -> {
            if (!this.completeExceptionally(future, (Throwable)error)) {
                try {
                    ReplicationSerDeHelper.removeTableCFsFromReplicationPeerConfig(tableCfs, peerConfig, id);
                }
                catch (ReplicationException e) {
                    future.completeExceptionally(e);
                    return;
                }
                this.updateReplicationPeerConfig(id, (ReplicationPeerConfig)peerConfig).whenComplete((result, err) -> {
                    if (!this.completeExceptionally(future, (Throwable)error)) {
                        future.complete((Void)result);
                    }
                });
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers() {
        return this.listReplicationPeers((Pattern)null);
    }

    @Override
    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers(String regex) {
        return this.listReplicationPeers(Pattern.compile(regex));
    }

    @Override
    public CompletableFuture<List<ReplicationPeerDescription>> listReplicationPeers(Pattern pattern) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, RequestConverter.buildListReplicationPeersRequest(pattern), (s, c, req, done) -> s.listReplicationPeers(c, (ReplicationProtos.ListReplicationPeersRequest)req, done), resp -> resp.getPeerDescList().stream().map(ReplicationSerDeHelper::toReplicationPeerDescription).collect(Collectors.toList()))).call();
    }

    @Override
    public CompletableFuture<List<TableCFs>> listReplicatedTableCFs() {
        CompletableFuture<List<TableCFs>> future = new CompletableFuture<List<TableCFs>>();
        this.listTables().whenComplete((tables, error) -> {
            if (!this.completeExceptionally(future, (Throwable)error)) {
                ArrayList replicatedTableCFs = new ArrayList();
                Arrays.asList(tables).forEach(table -> {
                    HashMap<String, Integer> cfs = new HashMap<String, Integer>();
                    Arrays.asList(table.getColumnFamilies()).stream().filter(column -> column.getScope() != 0).forEach(column -> cfs.put(column.getNameAsString(), column.getScope()));
                    if (!cfs.isEmpty()) {
                        replicatedTableCFs.add(new TableCFs(table.getTableName(), cfs));
                    }
                });
                future.complete(replicatedTableCFs);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> snapshot(String snapshotName, TableName tableName) {
        return this.snapshot(snapshotName, tableName, SnapshotType.FLUSH);
    }

    @Override
    public CompletableFuture<Void> snapshot(String snapshotName, TableName tableName, SnapshotType type) {
        return this.snapshot(new SnapshotDescription(snapshotName, tableName, type));
    }

    @Override
    public CompletableFuture<Void> snapshot(SnapshotDescription snapshotDesc) {
        SnapshotProtos.SnapshotDescription snapshot = ProtobufUtil.createHBaseProtosSnapshotDesc(snapshotDesc);
        try {
            ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        }
        catch (IllegalArgumentException e) {
            return this.failedFuture(e);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        MasterProtos.SnapshotRequest request = MasterProtos.SnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, request, (s, c, req, done) -> s.snapshot(c, (MasterProtos.SnapshotRequest)req, done), resp -> resp.getExpectedTimeout())).call().whenComplete((expectedTimeout, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            TimerTask pollingTask = new TimerTask((Long)expectedTimeout, snapshotDesc, future, snapshot){
                int tries = 0;
                long startTime = EnvironmentEdgeManager.currentTime();
                long endTime = this.startTime + this.val$expectedTimeout;
                long maxPauseTime = this.val$expectedTimeout / (long)AsyncHBaseAdmin.access$100(AsyncHBaseAdmin.this);
                final /* synthetic */ Long val$expectedTimeout;
                final /* synthetic */ SnapshotDescription val$snapshotDesc;
                final /* synthetic */ CompletableFuture val$future;
                final /* synthetic */ SnapshotProtos.SnapshotDescription val$snapshot;
                {
                    this.val$expectedTimeout = l;
                    this.val$snapshotDesc = snapshotDescription;
                    this.val$future = completableFuture;
                    this.val$snapshot = snapshotDescription2;
                }

                @Override
                public void run(Timeout timeout) throws Exception {
                    if (EnvironmentEdgeManager.currentTime() < this.endTime) {
                        AsyncHBaseAdmin.this.isSnapshotFinished(this.val$snapshotDesc).whenComplete((done, err) -> {
                            if (err != null) {
                                this.val$future.completeExceptionally((Throwable)err);
                            } else if (done.booleanValue()) {
                                this.val$future.complete(null);
                            } else {
                                long pauseTime = ConnectionUtils.getPauseTime(TimeUnit.NANOSECONDS.toMillis(AsyncHBaseAdmin.this.pauseNs), ++this.tries);
                                pauseTime = Math.min(pauseTime, this.maxPauseTime);
                                AsyncConnectionImpl.RETRY_TIMER.newTimeout(this, pauseTime, TimeUnit.MILLISECONDS);
                            }
                        });
                    } else {
                        this.val$future.completeExceptionally(new SnapshotCreationException("Snapshot '" + this.val$snapshot.getName() + "' wasn't completed in expectedTime:" + this.val$expectedTimeout + " ms", this.val$snapshotDesc));
                    }
                }
            };
            AsyncConnectionImpl.RETRY_TIMER.newTimeout(pollingTask, 1L, TimeUnit.MILLISECONDS);
        });
        return future;
    }

    @Override
    public CompletableFuture<Boolean> isSnapshotFinished(SnapshotDescription snapshot) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(ProtobufUtil.createHBaseProtosSnapshotDesc(snapshot)).build(), (s, c, req, done) -> s.isSnapshotDone(c, (MasterProtos.IsSnapshotDoneRequest)req, done), resp -> resp.getDone())).call();
    }

    @Override
    public CompletableFuture<Void> restoreSnapshot(String snapshotName) {
        boolean takeFailSafeSnapshot = this.connection.getConfiguration().getBoolean("hbase.snapshot.restore.take.failsafe.snapshot", false);
        return this.restoreSnapshot(snapshotName, takeFailSafeSnapshot);
    }

    private CompletableFuture<Void> restoreSnapshotWithFailSafe(String snapshotName, TableName tableName, boolean takeFailSafeSnapshot) {
        if (takeFailSafeSnapshot) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            String failSafeSnapshotSnapshotNameFormat = this.connection.getConfiguration().get("hbase.snapshot.restore.failsafe.name", "hbase-failsafe-{snapshot.name}-{restore.timestamp}");
            String failSafeSnapshotSnapshotName = failSafeSnapshotSnapshotNameFormat.replace("{snapshot.name}", snapshotName).replace("{table.name}", tableName.toString().replace(':', '.')).replace("{restore.timestamp}", String.valueOf(EnvironmentEdgeManager.currentTime()));
            LOG.info((Object)("Taking restore-failsafe snapshot: " + failSafeSnapshotSnapshotName));
            this.snapshot(failSafeSnapshotSnapshotName, tableName).whenComplete((ret, err) -> {
                if (err != null) {
                    future.completeExceptionally((Throwable)err);
                } else {
                    this.internalRestoreSnapshot(snapshotName, tableName).whenComplete((void2, err2) -> {
                        if (err2 != null) {
                            this.internalRestoreSnapshot(failSafeSnapshotSnapshotName, tableName).whenComplete((void3, err3) -> {
                                if (err3 != null) {
                                    future.completeExceptionally((Throwable)err3);
                                } else {
                                    String msg = "Restore snapshot=" + snapshotName + " failed. Rollback to snapshot=" + failSafeSnapshotSnapshotName + " succeeded.";
                                    future.completeExceptionally(new RestoreSnapshotException(msg));
                                }
                            });
                        } else {
                            LOG.info((Object)("Deleting restore-failsafe snapshot: " + failSafeSnapshotSnapshotName));
                            this.deleteSnapshot(failSafeSnapshotSnapshotName).whenComplete((ret3, err3) -> {
                                if (err3 != null) {
                                    LOG.error((Object)("Unable to remove the failsafe snapshot: " + failSafeSnapshotSnapshotName), err3);
                                    future.completeExceptionally((Throwable)err3);
                                } else {
                                    future.complete((Void)ret3);
                                }
                            });
                        }
                    });
                }
            });
            return future;
        }
        return this.internalRestoreSnapshot(snapshotName, tableName);
    }

    @Override
    public CompletableFuture<Void> restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.listSnapshots(snapshotName).whenComplete((snapshotDescriptions, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            TableName tableName = null;
            if (snapshotDescriptions != null && !snapshotDescriptions.isEmpty()) {
                for (SnapshotDescription snap : snapshotDescriptions) {
                    if (!snap.getName().equals(snapshotName)) continue;
                    tableName = snap.getTableName();
                    break;
                }
            }
            if (tableName == null) {
                future.completeExceptionally(new RestoreSnapshotException("Unable to find the table name for snapshot=" + snapshotName));
                return;
            }
            TableName finalTableName = tableName;
            this.tableExists(finalTableName).whenComplete((exists, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                } else if (!exists.booleanValue()) {
                    this.completeConditionalOnFuture(future, this.internalRestoreSnapshot(snapshotName, finalTableName));
                } else {
                    this.isTableDisabled(finalTableName).whenComplete((disabled, err4) -> {
                        if (err4 != null) {
                            future.completeExceptionally((Throwable)err4);
                        } else if (!disabled.booleanValue()) {
                            future.completeExceptionally(new TableNotDisabledException(finalTableName));
                        } else {
                            this.completeConditionalOnFuture(future, this.restoreSnapshotWithFailSafe(snapshotName, finalTableName, takeFailSafeSnapshot));
                        }
                    });
                }
            });
        });
        return future;
    }

    private <T> void completeConditionalOnFuture(CompletableFuture<T> dependentFuture, CompletableFuture<T> parentFuture) {
        parentFuture.whenComplete((res, err) -> {
            if (err != null) {
                dependentFuture.completeExceptionally((Throwable)err);
            } else {
                dependentFuture.complete(res);
            }
        });
    }

    @Override
    public CompletableFuture<Void> cloneSnapshot(String snapshotName, TableName tableName) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.tableExists(tableName).whenComplete((exists, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else if (exists.booleanValue()) {
                future.completeExceptionally(new TableExistsException(tableName));
            } else {
                this.completeConditionalOnFuture(future, this.internalRestoreSnapshot(snapshotName, tableName));
            }
        });
        return future;
    }

    private CompletableFuture<Void> internalRestoreSnapshot(String snapshotName, TableName tableName) {
        SnapshotProtos.SnapshotDescription snapshot = SnapshotProtos.SnapshotDescription.newBuilder().setName(snapshotName).setTable(tableName.getNameAsString()).build();
        try {
            ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        }
        catch (IllegalArgumentException e) {
            return this.failedFuture(e);
        }
        return this.waitProcedureResult(this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.RestoreSnapshotRequest.newBuilder().setSnapshot(snapshot).setNonceGroup(this.ng.getNonceGroup()).setNonce(this.ng.newNonce()).build(), (s, c, req, done) -> s.restoreSnapshot(c, (MasterProtos.RestoreSnapshotRequest)req, done), resp -> resp.getProcId())).call());
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listSnapshots() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.GetCompletedSnapshotsRequest.newBuilder().build(), (s, c, req, done) -> s.getCompletedSnapshots(c, (MasterProtos.GetCompletedSnapshotsRequest)req, done), resp -> resp.getSnapshotsList().stream().map(ProtobufUtil::createSnapshotDesc).collect(Collectors.toList()))).call();
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listSnapshots(String regex) {
        return this.listSnapshots(Pattern.compile(regex));
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listSnapshots(Pattern pattern) {
        CompletableFuture<List<SnapshotDescription>> future = new CompletableFuture<List<SnapshotDescription>>();
        this.listSnapshots().whenComplete((snapshotDescList, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            if (snapshotDescList == null || snapshotDescList.isEmpty()) {
                future.complete(Collections.emptyList());
                return;
            }
            future.complete(snapshotDescList.stream().filter(snap -> pattern.matcher(snap.getName()).matches()).collect(Collectors.toList()));
        });
        return future;
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(String tableNameRegex, String snapshotNameRegex) {
        return this.listTableSnapshots(Pattern.compile(tableNameRegex), Pattern.compile(snapshotNameRegex));
    }

    @Override
    public CompletableFuture<List<SnapshotDescription>> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        CompletableFuture<List<SnapshotDescription>> future = new CompletableFuture<List<SnapshotDescription>>();
        this.listTableNames(tableNamePattern, false).whenComplete((tableNames, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            if (tableNames == null || ((TableName[])tableNames).length <= 0) {
                future.complete(Collections.emptyList());
                return;
            }
            List<TableName> tableNameList = Arrays.asList(tableNames);
            this.listSnapshots(snapshotNamePattern).whenComplete((snapshotDescList, err2) -> {
                if (err2 != null) {
                    future.completeExceptionally((Throwable)err2);
                    return;
                }
                if (snapshotDescList == null || snapshotDescList.isEmpty()) {
                    future.complete(Collections.emptyList());
                    return;
                }
                future.complete(snapshotDescList.stream().filter(snap -> snap != null && tableNameList.contains(snap.getTableName())).collect(Collectors.toList()));
            });
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> deleteSnapshot(String snapshotName) {
        return this.internalDeleteSnapshot(new SnapshotDescription(snapshotName));
    }

    @Override
    public CompletableFuture<Void> deleteSnapshots(String regex) {
        return this.deleteSnapshots(Pattern.compile(regex));
    }

    @Override
    public CompletableFuture<Void> deleteSnapshots(Pattern snapshotNamePattern) {
        return this.deleteTableSnapshots(null, snapshotNamePattern);
    }

    @Override
    public CompletableFuture<Void> deleteTableSnapshots(String tableNameRegex, String snapshotNameRegex) {
        return this.deleteTableSnapshots(Pattern.compile(tableNameRegex), Pattern.compile(snapshotNameRegex));
    }

    @Override
    public CompletableFuture<Void> deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.listTableSnapshots(tableNamePattern, snapshotNamePattern).whenComplete((snapshotDescriptions, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            if (snapshotDescriptions == null || snapshotDescriptions.isEmpty()) {
                future.complete(null);
                return;
            }
            ArrayList deleteSnapshotFutures = new ArrayList();
            snapshotDescriptions.forEach(snapDesc -> deleteSnapshotFutures.add(this.internalDeleteSnapshot((SnapshotDescription)snapDesc)));
            CompletableFuture.allOf(deleteSnapshotFutures.toArray(new CompletableFuture[deleteSnapshotFutures.size()])).thenAccept(v -> future.complete((Void)v));
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> execProcedure(String signature, String instance, Map<String, String> props) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        HBaseProtos.ProcedureDescription procDesc = ProtobufUtil.buildProcedureDescription(signature, instance, props);
        this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.ExecProcedureRequest.newBuilder().setProcedure(procDesc).build(), (s, c, req, done) -> s.execProcedure(c, (MasterProtos.ExecProcedureRequest)req, done), resp -> resp.getExpectedTimeout())).call().whenComplete((expectedTimeout, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            TimerTask pollingTask = new TimerTask((Long)expectedTimeout, signature, instance, props, future){
                int tries = 0;
                long startTime = EnvironmentEdgeManager.currentTime();
                long endTime = this.startTime + this.val$expectedTimeout;
                long maxPauseTime = this.val$expectedTimeout / (long)AsyncHBaseAdmin.access$100(AsyncHBaseAdmin.this);
                final /* synthetic */ Long val$expectedTimeout;
                final /* synthetic */ String val$signature;
                final /* synthetic */ String val$instance;
                final /* synthetic */ Map val$props;
                final /* synthetic */ CompletableFuture val$future;
                {
                    this.val$expectedTimeout = l;
                    this.val$signature = string;
                    this.val$instance = string2;
                    this.val$props = map;
                    this.val$future = completableFuture;
                }

                @Override
                public void run(Timeout timeout) throws Exception {
                    if (EnvironmentEdgeManager.currentTime() < this.endTime) {
                        AsyncHBaseAdmin.this.isProcedureFinished(this.val$signature, this.val$instance, this.val$props).whenComplete((done, err) -> {
                            if (err != null) {
                                this.val$future.completeExceptionally((Throwable)err);
                                return;
                            }
                            if (done.booleanValue()) {
                                this.val$future.complete(null);
                            } else {
                                long pauseTime = ConnectionUtils.getPauseTime(TimeUnit.NANOSECONDS.toMillis(AsyncHBaseAdmin.this.pauseNs), ++this.tries);
                                pauseTime = Math.min(pauseTime, this.maxPauseTime);
                                AsyncConnectionImpl.RETRY_TIMER.newTimeout(this, pauseTime, TimeUnit.MICROSECONDS);
                            }
                        });
                    } else {
                        this.val$future.completeExceptionally(new IOException("Procedure '" + this.val$signature + " : " + this.val$instance + "' wasn't completed in expectedTime:" + this.val$expectedTimeout + " ms"));
                    }
                }
            };
            AsyncConnectionImpl.RETRY_TIMER.newTimeout(pollingTask, 1L, TimeUnit.MILLISECONDS);
        });
        return future;
    }

    @Override
    public CompletableFuture<byte[]> execProcedureWithRet(String signature, String instance, Map<String, String> props) {
        HBaseProtos.ProcedureDescription proDesc = ProtobufUtil.buildProcedureDescription(signature, instance, props);
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.ExecProcedureRequest.newBuilder().setProcedure(proDesc).build(), (s, c, req, done) -> s.execProcedureWithRet(c, (MasterProtos.ExecProcedureRequest)req, done), resp -> resp.hasReturnData() ? resp.getReturnData().toByteArray() : null)).call();
    }

    @Override
    public CompletableFuture<Boolean> isProcedureFinished(String signature, String instance, Map<String, String> props) {
        HBaseProtos.ProcedureDescription proDesc = ProtobufUtil.buildProcedureDescription(signature, instance, props);
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.IsProcedureDoneRequest.newBuilder().setProcedure(proDesc).build(), (s, c, req, done) -> s.isProcedureDone(c, (MasterProtos.IsProcedureDoneRequest)req, done), resp -> resp.getDone())).call();
    }

    @Override
    public CompletableFuture<Boolean> abortProcedure(long procId, boolean mayInterruptIfRunning) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.AbortProcedureRequest.newBuilder().setProcId(procId).build(), (s, c, req, done) -> s.abortProcedure(c, (MasterProtos.AbortProcedureRequest)req, done), resp -> resp.getIsProcedureAborted())).call();
    }

    @Override
    public CompletableFuture<ProcedureInfo[]> listProcedures() {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.ListProceduresRequest.newBuilder().build(), (s, c, req, done) -> s.listProcedures(c, (MasterProtos.ListProceduresRequest)req, done), resp -> (ProcedureInfo[])resp.getProcedureList().stream().map(ProtobufUtil::toProcedureInfo).toArray(ProcedureInfo[]::new))).call();
    }

    private CompletableFuture<Void> internalDeleteSnapshot(SnapshotDescription snapshot) {
        return this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(ProtobufUtil.createHBaseProtosSnapshotDesc(snapshot)).build(), (s, c, req, done) -> s.deleteSnapshot(c, (MasterProtos.DeleteSnapshotRequest)req, done), resp -> null)).call();
    }

    private byte[][] getSplitKeys(byte[] startKey, byte[] endKey, int numRegions) {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo(startKey, endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            return new byte[][]{startKey, endKey};
        }
        byte[][] splitKeys = Bytes.split(startKey, endKey, numRegions - 3);
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        return splitKeys;
    }

    private CompletableFuture<Void> waitProcedureResult(CompletableFuture<Long> procFuture) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        procFuture.whenComplete((procId, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            this.getProcedureResult((long)procId, future);
        });
        return future;
    }

    private void getProcedureResult(long procId, CompletableFuture<Void> future) {
        this.newMasterCaller().action((controller, stub) -> this.call(controller, stub, MasterProtos.GetProcedureResultRequest.newBuilder().setProcId(procId).build(), (s, c, req, done) -> s.getProcedureResult(c, (MasterProtos.GetProcedureResultRequest)req, done), resp -> resp)).call().whenComplete((response, error) -> {
            if (error != null) {
                LOG.warn((Object)("failed to get the procedure result procId=" + procId), ConnectionUtils.translateException(error));
                AsyncConnectionImpl.RETRY_TIMER.newTimeout(t -> this.getProcedureResult(procId, future), this.pauseNs, TimeUnit.NANOSECONDS);
                return;
            }
            if (response.getState() == MasterProtos.GetProcedureResultResponse.State.RUNNING) {
                AsyncConnectionImpl.RETRY_TIMER.newTimeout(t -> this.getProcedureResult(procId, future), this.pauseNs, TimeUnit.NANOSECONDS);
                return;
            }
            if (response.hasException()) {
                IOException ioe = ForeignExceptionUtil.toIOException(response.getException());
                future.completeExceptionally(ioe);
            } else {
                future.complete(null);
            }
        });
    }

    private <T> CompletableFuture<T> failedFuture(Throwable error) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(error);
        return future;
    }

    private <T> boolean completeExceptionally(CompletableFuture<T> future, Throwable error) {
        if (error != null) {
            future.completeExceptionally(error);
            return true;
        }
        return false;
    }

    static /* synthetic */ int access$100(AsyncHBaseAdmin x0) {
        return x0.maxAttempts;
    }

    private class MergeTableRegionProcedureBiConsumer
    extends TableProcedureBiConsumer {
        MergeTableRegionProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "MERGE_REGIONS";
        }
    }

    private class ModifyNamespaceProcedureBiConsumer
    extends NamespaceProcedureBiConsumer {
        ModifyNamespaceProcedureBiConsumer(AsyncAdmin admin, String namespaceName) {
            super(admin, namespaceName);
        }

        @Override
        String getOperationType() {
            return "MODIFY_NAMESPACE";
        }
    }

    private class DeleteNamespaceProcedureBiConsumer
    extends NamespaceProcedureBiConsumer {
        DeleteNamespaceProcedureBiConsumer(AsyncAdmin admin, String namespaceName) {
            super(admin, namespaceName);
        }

        @Override
        String getOperationType() {
            return "DELETE_NAMESPACE";
        }
    }

    private class CreateNamespaceProcedureBiConsumer
    extends NamespaceProcedureBiConsumer {
        CreateNamespaceProcedureBiConsumer(AsyncAdmin admin, String namespaceName) {
            super(admin, namespaceName);
        }

        @Override
        String getOperationType() {
            return "CREATE_NAMESPACE";
        }
    }

    private class ModifyColumnFamilyProcedureBiConsumer
    extends TableProcedureBiConsumer {
        ModifyColumnFamilyProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "MODIFY_COLUMN_FAMILY";
        }
    }

    private class DeleteColumnFamilyProcedureBiConsumer
    extends TableProcedureBiConsumer {
        DeleteColumnFamilyProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "DELETE_COLUMN_FAMILY";
        }
    }

    private class AddColumnFamilyProcedureBiConsumer
    extends TableProcedureBiConsumer {
        AddColumnFamilyProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "ADD_COLUMN_FAMILY";
        }
    }

    private class DisableTableProcedureBiConsumer
    extends TableProcedureBiConsumer {
        DisableTableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "DISABLE";
        }
    }

    private class EnableTableProcedureBiConsumer
    extends TableProcedureBiConsumer {
        EnableTableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "ENABLE";
        }
    }

    private class TruncateTableProcedureBiConsumer
    extends TableProcedureBiConsumer {
        TruncateTableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "TRUNCATE";
        }
    }

    private class DeleteTableProcedureBiConsumer
    extends TableProcedureBiConsumer {
        DeleteTableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "DELETE";
        }

        @Override
        void onFinished() {
            this.admin.getConnection().getLocator().clearCache(this.tableName);
            super.onFinished();
        }
    }

    private class CreateTableProcedureBiConsumer
    extends TableProcedureBiConsumer {
        CreateTableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin, tableName);
        }

        @Override
        String getOperationType() {
            return "CREATE";
        }
    }

    private abstract class NamespaceProcedureBiConsumer
    extends ProcedureBiConsumer {
        protected final String namespaceName;

        NamespaceProcedureBiConsumer(AsyncAdmin admin, String namespaceName) {
            super(admin);
            this.namespaceName = namespaceName;
        }

        abstract String getOperationType();

        String getDescription() {
            return "Operation: " + this.getOperationType() + ", Namespace: " + this.namespaceName;
        }

        @Override
        void onFinished() {
            LOG.info((Object)(this.getDescription() + " completed"));
        }

        @Override
        void onError(Throwable error) {
            LOG.info((Object)(this.getDescription() + " failed with " + error.getMessage()));
        }
    }

    private abstract class TableProcedureBiConsumer
    extends ProcedureBiConsumer {
        protected final TableName tableName;

        TableProcedureBiConsumer(AsyncAdmin admin, TableName tableName) {
            super(admin);
            this.tableName = tableName;
        }

        abstract String getOperationType();

        String getDescription() {
            return "Operation: " + this.getOperationType() + ", Table Name: " + this.tableName.getNameWithNamespaceInclAsString();
        }

        @Override
        void onFinished() {
            LOG.info((Object)(this.getDescription() + " completed"));
        }

        @Override
        void onError(Throwable error) {
            LOG.info((Object)(this.getDescription() + " failed with " + error.getMessage()));
        }
    }

    private abstract class ProcedureBiConsumer
    implements BiConsumer<Void, Throwable> {
        protected final AsyncAdmin admin;

        ProcedureBiConsumer(AsyncAdmin admin) {
            this.admin = admin;
        }

        abstract void onFinished();

        abstract void onError(Throwable var1);

        @Override
        public void accept(Void v, Throwable error) {
            if (error != null) {
                this.onError(error);
                return;
            }
            this.onFinished();
        }
    }

    @FunctionalInterface
    private static interface TableOperator {
        public CompletableFuture<Void> operate(TableName var1);
    }

    @FunctionalInterface
    private static interface Converter<D, S> {
        public D convert(S var1) throws IOException;
    }

    @FunctionalInterface
    private static interface AdminRpcCall<RESP, REQ> {
        public void call(AdminProtos.AdminService.Interface var1, HBaseRpcController var2, REQ var3, RpcCallback<RESP> var4);
    }

    @FunctionalInterface
    private static interface MasterRpcCall<RESP, REQ> {
        public void call(MasterProtos.MasterService.Interface var1, HBaseRpcController var2, REQ var3, RpcCallback<RESP> var4);
    }
}

