/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.RegionLoad;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.procedure2.LockInfo;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Public
public interface Admin
extends Abortable,
Closeable {
    public int getOperationTimeout();

    @Override
    public void abort(String var1, Throwable var2);

    @Override
    public boolean isAborted();

    public Connection getConnection();

    public boolean tableExists(TableName var1) throws IOException;

    public HTableDescriptor[] listTables() throws IOException;

    public HTableDescriptor[] listTables(Pattern var1) throws IOException;

    public HTableDescriptor[] listTables(String var1) throws IOException;

    public HTableDescriptor[] listTables(Pattern var1, boolean var2) throws IOException;

    public HTableDescriptor[] listTables(String var1, boolean var2) throws IOException;

    public TableName[] listTableNames() throws IOException;

    public TableName[] listTableNames(Pattern var1) throws IOException;

    public TableName[] listTableNames(String var1) throws IOException;

    public TableName[] listTableNames(Pattern var1, boolean var2) throws IOException;

    public TableName[] listTableNames(String var1, boolean var2) throws IOException;

    public HTableDescriptor getTableDescriptor(TableName var1) throws TableNotFoundException, IOException;

    public void createTable(HTableDescriptor var1) throws IOException;

    public void createTable(HTableDescriptor var1, byte[] var2, byte[] var3, int var4) throws IOException;

    public void createTable(HTableDescriptor var1, byte[][] var2) throws IOException;

    public Future<Void> createTableAsync(HTableDescriptor var1, byte[][] var2) throws IOException;

    public void deleteTable(TableName var1) throws IOException;

    public Future<Void> deleteTableAsync(TableName var1) throws IOException;

    public HTableDescriptor[] deleteTables(String var1) throws IOException;

    public HTableDescriptor[] deleteTables(Pattern var1) throws IOException;

    public void truncateTable(TableName var1, boolean var2) throws IOException;

    public Future<Void> truncateTableAsync(TableName var1, boolean var2) throws IOException;

    public void enableTable(TableName var1) throws IOException;

    public Future<Void> enableTableAsync(TableName var1) throws IOException;

    public HTableDescriptor[] enableTables(String var1) throws IOException;

    public HTableDescriptor[] enableTables(Pattern var1) throws IOException;

    public Future<Void> disableTableAsync(TableName var1) throws IOException;

    public void disableTable(TableName var1) throws IOException;

    public HTableDescriptor[] disableTables(String var1) throws IOException;

    public HTableDescriptor[] disableTables(Pattern var1) throws IOException;

    public boolean isTableEnabled(TableName var1) throws IOException;

    public boolean isTableDisabled(TableName var1) throws IOException;

    public boolean isTableAvailable(TableName var1) throws IOException;

    public boolean isTableAvailable(TableName var1, byte[][] var2) throws IOException;

    public Pair<Integer, Integer> getAlterStatus(TableName var1) throws IOException;

    @Deprecated
    public Pair<Integer, Integer> getAlterStatus(byte[] var1) throws IOException;

    @Deprecated
    public void addColumn(TableName var1, HColumnDescriptor var2) throws IOException;

    public void addColumnFamily(TableName var1, HColumnDescriptor var2) throws IOException;

    public Future<Void> addColumnFamilyAsync(TableName var1, HColumnDescriptor var2) throws IOException;

    @Deprecated
    public void deleteColumn(TableName var1, byte[] var2) throws IOException;

    public void deleteColumnFamily(TableName var1, byte[] var2) throws IOException;

    public Future<Void> deleteColumnFamilyAsync(TableName var1, byte[] var2) throws IOException;

    @Deprecated
    public void modifyColumn(TableName var1, HColumnDescriptor var2) throws IOException;

    public void modifyColumnFamily(TableName var1, HColumnDescriptor var2) throws IOException;

    public Future<Void> modifyColumnFamilyAsync(TableName var1, HColumnDescriptor var2) throws IOException;

    public void closeRegion(String var1, String var2) throws IOException;

    public void closeRegion(byte[] var1, String var2) throws IOException;

    public boolean closeRegionWithEncodedRegionName(String var1, String var2) throws IOException;

    public void closeRegion(ServerName var1, HRegionInfo var2) throws IOException;

    public List<HRegionInfo> getOnlineRegions(ServerName var1) throws IOException;

    public void flush(TableName var1) throws IOException;

    public void flushRegion(byte[] var1) throws IOException;

    public void compact(TableName var1) throws IOException;

    public void compactRegion(byte[] var1) throws IOException;

    public void compact(TableName var1, byte[] var2) throws IOException;

    public void compactRegion(byte[] var1, byte[] var2) throws IOException;

    public void majorCompact(TableName var1) throws IOException;

    public void majorCompactRegion(byte[] var1) throws IOException;

    public void majorCompact(TableName var1, byte[] var2) throws IOException;

    public void majorCompactRegion(byte[] var1, byte[] var2) throws IOException;

    public void compactRegionServer(ServerName var1, boolean var2) throws IOException, InterruptedException;

    public void move(byte[] var1, byte[] var2) throws IOException;

    public void assign(byte[] var1) throws IOException;

    public void unassign(byte[] var1, boolean var2) throws IOException;

    public void offline(byte[] var1) throws IOException;

    public boolean setBalancerRunning(boolean var1, boolean var2) throws IOException;

    public boolean balancer() throws IOException;

    public boolean balancer(boolean var1) throws IOException;

    public boolean isBalancerEnabled() throws IOException;

    public boolean normalize() throws IOException;

    public boolean isNormalizerEnabled() throws IOException;

    public boolean setNormalizerRunning(boolean var1) throws IOException;

    public boolean enableCatalogJanitor(boolean var1) throws IOException;

    public int runCatalogScan() throws IOException;

    public boolean isCatalogJanitorEnabled() throws IOException;

    public boolean setCleanerChoreRunning(boolean var1) throws IOException;

    public boolean runCleanerChore() throws IOException;

    public boolean isCleanerChoreEnabled() throws IOException;

    @Deprecated
    public void mergeRegions(byte[] var1, byte[] var2, boolean var3) throws IOException;

    public Future<Void> mergeRegionsAsync(byte[] var1, byte[] var2, boolean var3) throws IOException;

    public Future<Void> mergeRegionsAsync(byte[][] var1, boolean var2) throws IOException;

    public void split(TableName var1) throws IOException;

    public void splitRegion(byte[] var1) throws IOException;

    public void split(TableName var1, byte[] var2) throws IOException;

    public void splitRegion(byte[] var1, byte[] var2) throws IOException;

    public void modifyTable(TableName var1, HTableDescriptor var2) throws IOException;

    public Future<Void> modifyTableAsync(TableName var1, HTableDescriptor var2) throws IOException;

    public void shutdown() throws IOException;

    public void stopMaster() throws IOException;

    public boolean isMasterInMaintenanceMode() throws IOException;

    public void stopRegionServer(String var1) throws IOException;

    public ClusterStatus getClusterStatus() throws IOException;

    public Map<byte[], RegionLoad> getRegionLoad(ServerName var1) throws IOException;

    public Map<byte[], RegionLoad> getRegionLoad(ServerName var1, TableName var2) throws IOException;

    public Configuration getConfiguration();

    public void createNamespace(NamespaceDescriptor var1) throws IOException;

    public Future<Void> createNamespaceAsync(NamespaceDescriptor var1) throws IOException;

    public void modifyNamespace(NamespaceDescriptor var1) throws IOException;

    public Future<Void> modifyNamespaceAsync(NamespaceDescriptor var1) throws IOException;

    public void deleteNamespace(String var1) throws IOException;

    public Future<Void> deleteNamespaceAsync(String var1) throws IOException;

    public NamespaceDescriptor getNamespaceDescriptor(String var1) throws NamespaceNotFoundException, IOException;

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException;

    public HTableDescriptor[] listTableDescriptorsByNamespace(String var1) throws IOException;

    public TableName[] listTableNamesByNamespace(String var1) throws IOException;

    public List<HRegionInfo> getTableRegions(TableName var1) throws IOException;

    @Override
    public void close() throws IOException;

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> var1) throws IOException;

    public HTableDescriptor[] getTableDescriptors(List<String> var1) throws IOException;

    public boolean abortProcedure(long var1, boolean var3) throws IOException;

    public Future<Boolean> abortProcedureAsync(long var1, boolean var3) throws IOException;

    public ProcedureInfo[] listProcedures() throws IOException;

    public LockInfo[] listLocks() throws IOException;

    public void rollWALWriter(ServerName var1) throws IOException, FailedLogCloseException;

    public String[] getMasterCoprocessors() throws IOException;

    public CompactionState getCompactionState(TableName var1) throws IOException;

    public CompactionState getCompactionStateForRegion(byte[] var1) throws IOException;

    public long getLastMajorCompactionTimestamp(TableName var1) throws IOException;

    public long getLastMajorCompactionTimestampForRegion(byte[] var1) throws IOException;

    public void snapshot(String var1, TableName var2) throws IOException, SnapshotCreationException, IllegalArgumentException;

    public void snapshot(byte[] var1, TableName var2) throws IOException, SnapshotCreationException, IllegalArgumentException;

    public void snapshot(String var1, TableName var2, SnapshotType var3) throws IOException, SnapshotCreationException, IllegalArgumentException;

    public void snapshot(SnapshotDescription var1) throws IOException, SnapshotCreationException, IllegalArgumentException;

    public void takeSnapshotAsync(SnapshotDescription var1) throws IOException, SnapshotCreationException;

    public boolean isSnapshotFinished(SnapshotDescription var1) throws IOException, HBaseSnapshotException, UnknownSnapshotException;

    public void restoreSnapshot(byte[] var1) throws IOException, RestoreSnapshotException;

    public void restoreSnapshot(String var1) throws IOException, RestoreSnapshotException;

    public Future<Void> restoreSnapshotAsync(String var1) throws IOException, RestoreSnapshotException;

    public void restoreSnapshot(byte[] var1, boolean var2) throws IOException, RestoreSnapshotException;

    public void restoreSnapshot(String var1, boolean var2) throws IOException, RestoreSnapshotException;

    public void restoreSnapshot(String var1, boolean var2, boolean var3) throws IOException, RestoreSnapshotException;

    public void cloneSnapshot(byte[] var1, TableName var2) throws IOException, TableExistsException, RestoreSnapshotException;

    public void cloneSnapshot(String var1, TableName var2, boolean var3) throws IOException, TableExistsException, RestoreSnapshotException;

    public void cloneSnapshot(String var1, TableName var2) throws IOException, TableExistsException, RestoreSnapshotException;

    public Future<Void> cloneSnapshotAsync(String var1, TableName var2) throws IOException, TableExistsException;

    public void execProcedure(String var1, String var2, Map<String, String> var3) throws IOException;

    public byte[] execProcedureWithRet(String var1, String var2, Map<String, String> var3) throws IOException;

    public boolean isProcedureFinished(String var1, String var2, Map<String, String> var3) throws IOException;

    public List<SnapshotDescription> listSnapshots() throws IOException;

    public List<SnapshotDescription> listSnapshots(String var1) throws IOException;

    public List<SnapshotDescription> listSnapshots(Pattern var1) throws IOException;

    public List<SnapshotDescription> listTableSnapshots(String var1, String var2) throws IOException;

    public List<SnapshotDescription> listTableSnapshots(Pattern var1, Pattern var2) throws IOException;

    public void deleteSnapshot(byte[] var1) throws IOException;

    public void deleteSnapshot(String var1) throws IOException;

    public void deleteSnapshots(String var1) throws IOException;

    public void deleteSnapshots(Pattern var1) throws IOException;

    public void deleteTableSnapshots(String var1, String var2) throws IOException;

    public void deleteTableSnapshots(Pattern var1, Pattern var2) throws IOException;

    public void setQuota(QuotaSettings var1) throws IOException;

    public QuotaRetriever getQuotaRetriever(QuotaFilter var1) throws IOException;

    public CoprocessorRpcChannel coprocessorService();

    public CoprocessorRpcChannel coprocessorService(ServerName var1);

    public void updateConfiguration(ServerName var1) throws IOException;

    public void updateConfiguration() throws IOException;

    public int getMasterInfoPort() throws IOException;

    public void compact(TableName var1, CompactType var2) throws IOException, InterruptedException;

    public void compact(TableName var1, byte[] var2, CompactType var3) throws IOException, InterruptedException;

    public void majorCompact(TableName var1, CompactType var2) throws IOException, InterruptedException;

    public void majorCompact(TableName var1, byte[] var2, CompactType var3) throws IOException, InterruptedException;

    public CompactionState getCompactionState(TableName var1, CompactType var2) throws IOException;

    public List<SecurityCapability> getSecurityCapabilities() throws IOException;

    public boolean[] setSplitOrMergeEnabled(boolean var1, boolean var2, MasterSwitchType ... var3) throws IOException;

    public boolean isSplitOrMergeEnabled(MasterSwitchType var1) throws IOException;

    default public void addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig) throws IOException {
    }

    default public void removeReplicationPeer(String peerId) throws IOException {
    }

    default public void enableReplicationPeer(String peerId) throws IOException {
    }

    default public void disableReplicationPeer(String peerId) throws IOException {
    }

    default public ReplicationPeerConfig getReplicationPeerConfig(String peerId) throws IOException {
        return new ReplicationPeerConfig();
    }

    default public void updateReplicationPeerConfig(String peerId, ReplicationPeerConfig peerConfig) throws IOException {
    }

    default public void appendReplicationPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException, IOException {
    }

    default public void removeReplicationPeerTableCFs(String id, Map<TableName, ? extends Collection<String>> tableCfs) throws ReplicationException, IOException {
    }

    default public List<ReplicationPeerDescription> listReplicationPeers() throws IOException {
        return new ArrayList<ReplicationPeerDescription>();
    }

    default public List<ReplicationPeerDescription> listReplicationPeers(String regex) throws IOException {
        return new ArrayList<ReplicationPeerDescription>();
    }

    default public List<ReplicationPeerDescription> listReplicationPeers(Pattern pattern) throws IOException {
        return new ArrayList<ReplicationPeerDescription>();
    }

    public void drainRegionServers(List<ServerName> var1) throws IOException;

    public List<ServerName> listDrainingRegionServers() throws IOException;

    public void removeDrainFromRegionServers(List<ServerName> var1) throws IOException;

    public List<TableCFs> listReplicatedTableCFs() throws IOException;

    public void enableTableReplication(TableName var1) throws IOException;

    public void disableTableReplication(TableName var1) throws IOException;

    public void clearCompactionQueues(ServerName var1, Set<String> var2) throws IOException, InterruptedException;
}

