/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class NoTagsKeyValue
extends KeyValue {
    public NoTagsKeyValue(byte[] bytes, int offset, int length) {
        super(bytes, offset, length);
    }

    @Override
    public int getTagsLength() {
        return 0;
    }

    @Override
    public int write(OutputStream out, boolean withTags) throws IOException {
        out.write(this.bytes, this.offset, this.length);
        return this.length;
    }

    @Override
    public int getSerializedSize(boolean withTags) {
        return this.length;
    }

    @Override
    public Cell deepClone() {
        byte[] copy = Bytes.copy(this.bytes, this.offset, this.length);
        NoTagsKeyValue kv = new NoTagsKeyValue(copy, 0, copy.length);
        kv.setSequenceId(this.getSequenceId());
        return kv;
    }
}

