/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.RegionServerCallable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.ExceptionUtil;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.PairOfSameType;

@InterfaceAudience.Private
public class MetaTableAccessor {
    private static final Log LOG = LogFactory.getLog(MetaTableAccessor.class);
    private static final Log METALOG = LogFactory.getLog((String)"org.apache.hadoop.hbase.META");
    private static final byte[] daughterNameCq = Bytes.toBytes("_DAUGHTER_");
    private static final byte[] parentNameCq = Bytes.toBytes("_PARENT_");
    private static final byte[] tableNameCq = Bytes.toBytes("_TABLENAME_");
    static final byte[] META_REGION_PREFIX;
    protected static final char META_REPLICA_ID_DELIMITER = '_';
    private static final Pattern SERVER_COLUMN_PATTERN;

    @Deprecated
    public static NavigableMap<HRegionInfo, ServerName> allTableRegions(Connection connection, TableName tableName) throws IOException {
        final TreeMap<HRegionInfo, ServerName> regions = new TreeMap<HRegionInfo, ServerName>();
        TableVisitorBase visitor = new TableVisitorBase(tableName){

            @Override
            public boolean visitInternal(Result result) throws IOException {
                RegionLocations locations = MetaTableAccessor.getRegionLocations(result);
                if (locations == null) {
                    return true;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null) continue;
                    HRegionInfo regionInfo = loc.getRegionInfo();
                    regions.put(regionInfo, loc.getServerName());
                }
                return true;
            }
        };
        MetaTableAccessor.scanMetaForTableRegions(connection, visitor, tableName);
        return regions;
    }

    public static void fullScanRegions(Connection connection, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.REGION, visitor);
    }

    public static List<Result> fullScanRegions(Connection connection) throws IOException {
        return MetaTableAccessor.fullScan(connection, QueryType.REGION);
    }

    public static void fullScanTables(Connection connection, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.TABLE, visitor);
    }

    public static List<Result> fullScan(Connection connection, QueryType type) throws IOException {
        CollectAllVisitor v = new CollectAllVisitor();
        MetaTableAccessor.scanMeta(connection, null, null, type, (Visitor)v);
        return v.getResults();
    }

    static Table getMetaHTable(Connection connection) throws IOException {
        if (connection == null) {
            throw new NullPointerException("No connection");
        }
        if (connection.isClosed()) {
            throw new IOException("connection is closed");
        }
        return connection.getTable(TableName.META_TABLE_NAME);
    }

    private static Result get(Table t, Get g) throws IOException {
        if (t == null) {
            return null;
        }
        try {
            Result result = t.get(g);
            return result;
        }
        finally {
            t.close();
        }
    }

    @Deprecated
    public static Pair<HRegionInfo, ServerName> getRegion(Connection connection, byte[] regionName) throws IOException {
        HRegionLocation location = MetaTableAccessor.getRegionLocation(connection, regionName);
        return location == null ? null : new Pair<HRegionInfo, ServerName>(location.getRegionInfo(), location.getServerName());
    }

    public static HRegionLocation getRegionLocation(Connection connection, byte[] regionName) throws IOException {
        byte[] row = regionName;
        HRegionInfo parsedInfo = null;
        try {
            parsedInfo = MetaTableAccessor.parseRegionInfoFromRegionName(regionName);
            row = MetaTableAccessor.getMetaKeyForRegion(parsedInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Get get = new Get(row);
        get.addFamily(HConstants.CATALOG_FAMILY);
        Result r = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
        return locations == null ? null : locations.getRegionLocation(parsedInfo == null ? 0 : parsedInfo.getReplicaId());
    }

    public static HRegionLocation getRegionLocation(Connection connection, HRegionInfo regionInfo) throws IOException {
        byte[] row = MetaTableAccessor.getMetaKeyForRegion(regionInfo);
        Get get = new Get(row);
        get.addFamily(HConstants.CATALOG_FAMILY);
        Result r = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        return MetaTableAccessor.getRegionLocation(r, regionInfo, regionInfo.getReplicaId());
    }

    public static byte[] getMetaKeyForRegion(HRegionInfo regionInfo) {
        return RegionReplicaUtil.getRegionInfoForDefaultReplica(regionInfo).getRegionName();
    }

    protected static HRegionInfo parseRegionInfoFromRegionName(byte[] regionName) throws IOException {
        byte[][] fields = HRegionInfo.parseRegionName(regionName);
        long regionId = Long.parseLong(Bytes.toString(fields[2]));
        int replicaId = fields.length > 3 ? Integer.parseInt(Bytes.toString(fields[3]), 16) : 0;
        return new HRegionInfo(TableName.valueOf(fields[0]), fields[1], fields[1], false, regionId, replicaId);
    }

    public static Result getRegionResult(Connection connection, byte[] regionName) throws IOException {
        Get get = new Get(regionName);
        get.addFamily(HConstants.CATALOG_FAMILY);
        return MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
    }

    @Nullable
    public static Pair<HRegionInfo, HRegionInfo> getRegionsFromMergeQualifier(Connection connection, byte[] regionName) throws IOException {
        Result result = MetaTableAccessor.getRegionResult(connection, regionName);
        HRegionInfo mergeA = MetaTableAccessor.getHRegionInfo(result, HConstants.MERGEA_QUALIFIER);
        HRegionInfo mergeB = MetaTableAccessor.getHRegionInfo(result, HConstants.MERGEB_QUALIFIER);
        if (mergeA == null && mergeB == null) {
            return null;
        }
        return new Pair<HRegionInfo, HRegionInfo>(mergeA, mergeB);
    }

    public static boolean tableExists(Connection connection, TableName tableName) throws IOException {
        return tableName.equals(TableName.META_TABLE_NAME) || MetaTableAccessor.getTableState(connection, tableName) != null;
    }

    @VisibleForTesting
    public static List<HRegionInfo> getAllRegions(Connection connection, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<HRegionInfo, ServerName>> result = MetaTableAccessor.getTableRegionsAndLocations(connection, null, excludeOfflinedSplitParents);
        return MetaTableAccessor.getListOfHRegionInfos(result);
    }

    public static List<HRegionInfo> getTableRegions(Connection connection, TableName tableName) throws IOException {
        return MetaTableAccessor.getTableRegions(connection, tableName, false);
    }

    public static List<HRegionInfo> getTableRegions(Connection connection, TableName tableName, boolean excludeOfflinedSplitParents) throws IOException {
        List<Pair<HRegionInfo, ServerName>> result = MetaTableAccessor.getTableRegionsAndLocations(connection, tableName, excludeOfflinedSplitParents);
        return MetaTableAccessor.getListOfHRegionInfos(result);
    }

    @Nullable
    static List<HRegionInfo> getListOfHRegionInfos(List<Pair<HRegionInfo, ServerName>> pairs) {
        if (pairs == null || pairs.isEmpty()) {
            return null;
        }
        ArrayList<HRegionInfo> result = new ArrayList<HRegionInfo>(pairs.size());
        for (Pair<HRegionInfo, ServerName> pair : pairs) {
            result.add(pair.getFirst());
        }
        return result;
    }

    static boolean isInsideTable(HRegionInfo current, TableName tableName) {
        return tableName.equals(current.getTable());
    }

    public static byte[] getTableStartRowForMeta(TableName tableName, QueryType type) {
        if (tableName == null) {
            return null;
        }
        switch (type) {
            case REGION: {
                byte[] startRow = new byte[tableName.getName().length + 2];
                System.arraycopy(tableName.getName(), 0, startRow, 0, tableName.getName().length);
                startRow[startRow.length - 2] = 44;
                startRow[startRow.length - 1] = 44;
                return startRow;
            }
        }
        return tableName.getName();
    }

    public static byte[] getTableStopRowForMeta(TableName tableName, QueryType type) {
        byte[] stopRow;
        if (tableName == null) {
            return null;
        }
        switch (type) {
            case REGION: {
                stopRow = new byte[tableName.getName().length + 3];
                System.arraycopy(tableName.getName(), 0, stopRow, 0, tableName.getName().length);
                stopRow[stopRow.length - 3] = 32;
                stopRow[stopRow.length - 2] = 44;
                stopRow[stopRow.length - 1] = 44;
                break;
            }
            default: {
                stopRow = new byte[tableName.getName().length + 1];
                System.arraycopy(tableName.getName(), 0, stopRow, 0, tableName.getName().length);
                stopRow[stopRow.length - 1] = 32;
            }
        }
        return stopRow;
    }

    @Deprecated
    public static Scan getScanForTableName(Connection connection, TableName tableName) {
        byte[] startKey = MetaTableAccessor.getTableStartRowForMeta(tableName, QueryType.REGION);
        byte[] stopKey = MetaTableAccessor.getTableStopRowForMeta(tableName, QueryType.REGION);
        Scan scan = MetaTableAccessor.getMetaScan(connection, -1);
        scan.setStartRow(startKey);
        scan.setStopRow(stopKey);
        return scan;
    }

    private static Scan getMetaScan(Connection connection, int rowUpperLimit) {
        Scan scan = new Scan();
        int scannerCaching = connection.getConfiguration().getInt("hbase.meta.scanner.caching", 100);
        if (connection.getConfiguration().getBoolean("hbase.meta.replicas.use", false)) {
            scan.setConsistency(Consistency.TIMELINE);
        }
        if (rowUpperLimit > 0) {
            scan.setLimit(rowUpperLimit);
            scan.setReadType(Scan.ReadType.PREAD);
        }
        scan.setCaching(scannerCaching);
        return scan;
    }

    public static List<Pair<HRegionInfo, ServerName>> getTableRegionsAndLocations(Connection connection, TableName tableName) throws IOException {
        return MetaTableAccessor.getTableRegionsAndLocations(connection, tableName, true);
    }

    public static List<Pair<HRegionInfo, ServerName>> getTableRegionsAndLocations(Connection connection, @Nullable TableName tableName, final boolean excludeOfflinedSplitParents) throws IOException {
        if (tableName != null && tableName.equals(TableName.META_TABLE_NAME)) {
            throw new IOException("This method can't be used to locate meta regions; use MetaTableLocator instead");
        }
        CollectingVisitor<Pair<HRegionInfo, ServerName>> visitor = new CollectingVisitor<Pair<HRegionInfo, ServerName>>(){
            private RegionLocations current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                this.current = MetaTableAccessor.getRegionLocations(r);
                if (this.current == null || this.current.getRegionLocation().getRegionInfo() == null) {
                    LOG.warn((Object)("No serialized HRegionInfo in " + r));
                    return true;
                }
                HRegionInfo hri = this.current.getRegionLocation().getRegionInfo();
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                return super.visit(r);
            }

            @Override
            void add(Result r) {
                if (this.current == null) {
                    return;
                }
                for (HRegionLocation loc : this.current.getRegionLocations()) {
                    if (loc == null) continue;
                    this.results.add(new Pair<HRegionInfo, ServerName>(loc.getRegionInfo(), loc.getServerName()));
                }
            }
        };
        MetaTableAccessor.scanMeta(connection, MetaTableAccessor.getTableStartRowForMeta(tableName, QueryType.REGION), MetaTableAccessor.getTableStopRowForMeta(tableName, QueryType.REGION), QueryType.REGION, (Visitor)visitor);
        return visitor.getResults();
    }

    public static NavigableMap<HRegionInfo, Result> getServerUserRegions(Connection connection, final ServerName serverName) throws IOException {
        final TreeMap<HRegionInfo, Result> hris = new TreeMap<HRegionInfo, Result>();
        CollectingVisitor<Result> v = new CollectingVisitor<Result>(){

            @Override
            void add(Result r) {
                if (r == null || r.isEmpty()) {
                    return;
                }
                RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
                if (locations == null) {
                    return;
                }
                for (HRegionLocation loc : locations.getRegionLocations()) {
                    if (loc == null || loc.getServerName() == null || !loc.getServerName().equals(serverName)) continue;
                    hris.put(loc.getRegionInfo(), r);
                }
            }
        };
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.REGION, (Visitor)v);
        return hris;
    }

    public static void fullScanMetaAndPrint(Connection connection) throws IOException {
        Visitor v = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                if (r == null || r.isEmpty()) {
                    return true;
                }
                LOG.info((Object)("fullScanMetaAndPrint.Current Meta Row: " + r));
                TableState state = MetaTableAccessor.getTableState(r);
                if (state != null) {
                    LOG.info((Object)("Table State: " + state));
                } else {
                    RegionLocations locations = MetaTableAccessor.getRegionLocations(r);
                    if (locations == null) {
                        return true;
                    }
                    for (HRegionLocation loc : locations.getRegionLocations()) {
                        if (loc == null) continue;
                        LOG.info((Object)("fullScanMetaAndPrint.HRI Print= " + loc.getRegionInfo()));
                    }
                }
                return true;
            }
        };
        MetaTableAccessor.scanMeta(connection, null, null, QueryType.ALL, v);
    }

    public static void scanMetaForTableRegions(Connection connection, Visitor visitor, TableName tableName) throws IOException {
        MetaTableAccessor.scanMeta(connection, tableName, QueryType.REGION, Integer.MAX_VALUE, visitor);
    }

    public static void scanMeta(Connection connection, TableName table, QueryType type, int maxRows, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, MetaTableAccessor.getTableStartRowForMeta(table, type), MetaTableAccessor.getTableStopRowForMeta(table, type), type, maxRows, visitor);
    }

    public static void scanMeta(Connection connection, @Nullable byte[] startRow, @Nullable byte[] stopRow, QueryType type, Visitor visitor) throws IOException {
        MetaTableAccessor.scanMeta(connection, startRow, stopRow, type, Integer.MAX_VALUE, visitor);
    }

    public static void scanMeta(Connection connection, Visitor visitor, TableName tableName, byte[] row, int rowLimit) throws IOException {
        byte[] startRow = null;
        byte[] stopRow = null;
        if (tableName != null) {
            startRow = MetaTableAccessor.getTableStartRowForMeta(tableName, QueryType.REGION);
            if (row != null) {
                HRegionInfo closestRi = MetaTableAccessor.getClosestRegionInfo(connection, tableName, row);
                startRow = HRegionInfo.createRegionName(tableName, closestRi.getStartKey(), "00000000000000", false);
            }
            stopRow = MetaTableAccessor.getTableStopRowForMeta(tableName, QueryType.REGION);
        }
        MetaTableAccessor.scanMeta(connection, startRow, stopRow, QueryType.REGION, rowLimit, visitor);
    }

    public static void scanMeta(Connection connection, @Nullable byte[] startRow, @Nullable byte[] stopRow, QueryType type, int maxRows, Visitor visitor) throws IOException {
        int rowUpperLimit = maxRows > 0 ? maxRows : Integer.MAX_VALUE;
        Scan scan = MetaTableAccessor.getMetaScan(connection, rowUpperLimit);
        for (byte[] family : type.getFamilies()) {
            scan.addFamily(family);
        }
        if (startRow != null) {
            scan.setStartRow(startRow);
        }
        if (stopRow != null) {
            scan.setStopRow(stopRow);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Scanning META starting at row=" + Bytes.toStringBinary(startRow) + " stopping at row=" + Bytes.toStringBinary(stopRow) + " for max=" + rowUpperLimit + " with caching=" + scan.getCaching()));
        }
        int currentRow = 0;
        try (Table metaTable = MetaTableAccessor.getMetaHTable(connection);
             ResultScanner scanner = metaTable.getScanner(scan);){
            Result data;
            while ((data = scanner.next()) != null) {
                if (data.isEmpty()) continue;
                if (!visitor.visit(data)) {
                } else if (++currentRow < rowUpperLimit) continue;
                break;
            }
        }
        if (visitor != null && visitor instanceof Closeable) {
            try {
                ((Closeable)((Object)visitor)).close();
            }
            catch (Throwable t) {
                ExceptionUtil.rethrowIfInterrupt(t);
                LOG.debug((Object)"Got exception in closing the meta scanner visitor", t);
            }
        }
    }

    @NonNull
    public static HRegionInfo getClosestRegionInfo(Connection connection, @NonNull TableName tableName, @NonNull byte[] row) throws IOException {
        byte[] searchRow = HRegionInfo.createRegionName(tableName, row, "99999999999999", false);
        Scan scan = MetaTableAccessor.getMetaScan(connection, 1);
        scan.setReversed(true);
        scan.setStartRow(searchRow);
        try (ResultScanner resultScanner = MetaTableAccessor.getMetaHTable(connection).getScanner(scan);){
            Result result = resultScanner.next();
            if (result == null) {
                throw new TableNotFoundException("Cannot find row in META  for table: " + tableName + ", row=" + Bytes.toStringBinary(row));
            }
            HRegionInfo regionInfo = MetaTableAccessor.getHRegionInfo(result);
            if (regionInfo == null) {
                throw new IOException("HRegionInfo was null or empty in Meta for " + tableName + ", row=" + Bytes.toStringBinary(row));
            }
            HRegionInfo hRegionInfo = regionInfo;
            return hRegionInfo;
        }
    }

    protected static byte[] getCatalogFamily() {
        return HConstants.CATALOG_FAMILY;
    }

    protected static byte[] getTableFamily() {
        return HConstants.TABLE_FAMILY;
    }

    protected static byte[] getRegionInfoColumn() {
        return HConstants.REGIONINFO_QUALIFIER;
    }

    protected static byte[] getStateColumn() {
        return HConstants.TABLE_STATE_QUALIFIER;
    }

    @VisibleForTesting
    public static byte[] getServerColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVER_QUALIFIER : Bytes.toBytes("server_" + String.format("%04X", replicaId));
    }

    @VisibleForTesting
    public static byte[] getStartCodeColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STARTCODE_QUALIFIER : Bytes.toBytes("serverstartcode_" + String.format("%04X", replicaId));
    }

    @VisibleForTesting
    public static byte[] getSeqNumColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SEQNUM_QUALIFIER : Bytes.toBytes("seqnumDuringOpen_" + String.format("%04X", replicaId));
    }

    @VisibleForTesting
    static int parseReplicaIdFromServerColumn(byte[] serverColumn) {
        String serverStr = Bytes.toString(serverColumn);
        Matcher matcher = SERVER_COLUMN_PATTERN.matcher(serverStr);
        if (matcher.matches() && matcher.groupCount() > 0) {
            String group = matcher.group(1);
            if (group != null && group.length() > 0) {
                return Integer.parseInt(group.substring(1), 16);
            }
            return 0;
        }
        return -1;
    }

    @InterfaceAudience.Private
    @Nullable
    public static ServerName getServerName(Result r, int replicaId) {
        byte[] serverColumn = MetaTableAccessor.getServerColumn(replicaId);
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), serverColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        String hostAndPort = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        byte[] startcodeColumn = MetaTableAccessor.getStartCodeColumn(replicaId);
        cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), startcodeColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return null;
        }
        try {
            return ServerName.valueOf(hostAndPort, Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Ignoring invalid region for server " + hostAndPort + "; cell=" + cell), (Throwable)e);
            return null;
        }
    }

    private static long getSeqNumDuringOpen(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getSeqNumColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return -1L;
        }
        return Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    @Nullable
    public static RegionLocations getRegionLocations(Result r) {
        Map.Entry entry;
        if (r == null) {
            return null;
        }
        HRegionInfo regionInfo = MetaTableAccessor.getHRegionInfo(r, MetaTableAccessor.getRegionInfoColumn());
        if (regionInfo == null) {
            return null;
        }
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>(1);
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyMap = r.getNoVersionMap();
        locations.add(MetaTableAccessor.getRegionLocation(r, regionInfo, 0));
        NavigableMap infoMap = (NavigableMap)familyMap.get(MetaTableAccessor.getCatalogFamily());
        if (infoMap == null) {
            return new RegionLocations(locations);
        }
        int replicaId = 0;
        byte[] serverColumn = MetaTableAccessor.getServerColumn(replicaId);
        NavigableMap serverMap = null;
        serverMap = infoMap.tailMap(serverColumn, false);
        if (serverMap.isEmpty()) {
            return new RegionLocations(locations);
        }
        Iterator iterator = serverMap.entrySet().iterator();
        while (iterator.hasNext() && (replicaId = MetaTableAccessor.parseReplicaIdFromServerColumn((byte[])(entry = iterator.next()).getKey())) >= 0) {
            HRegionLocation location = MetaTableAccessor.getRegionLocation(r, regionInfo, replicaId);
            if (location == null || location.getServerName() == null) {
                locations.add(null);
                continue;
            }
            locations.add(location);
        }
        return new RegionLocations(locations);
    }

    private static HRegionLocation getRegionLocation(Result r, HRegionInfo regionInfo, int replicaId) {
        ServerName serverName = MetaTableAccessor.getServerName(r, replicaId);
        long seqNum = MetaTableAccessor.getSeqNumDuringOpen(r, replicaId);
        HRegionInfo replicaInfo = RegionReplicaUtil.getRegionInfoForReplica(regionInfo, replicaId);
        return new HRegionLocation(replicaInfo, serverName, seqNum);
    }

    public static HRegionInfo getHRegionInfo(Result data) {
        return MetaTableAccessor.getHRegionInfo(data, HConstants.REGIONINFO_QUALIFIER);
    }

    @Nullable
    private static HRegionInfo getHRegionInfo(Result r, byte[] qualifier) {
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getCatalogFamily(), qualifier);
        if (cell == null) {
            return null;
        }
        return HRegionInfo.parseFromOrNull(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static PairOfSameType<HRegionInfo> getDaughterRegions(Result data) {
        HRegionInfo splitA = MetaTableAccessor.getHRegionInfo(data, HConstants.SPLITA_QUALIFIER);
        HRegionInfo splitB = MetaTableAccessor.getHRegionInfo(data, HConstants.SPLITB_QUALIFIER);
        return new PairOfSameType<HRegionInfo>(splitA, splitB);
    }

    public static PairOfSameType<HRegionInfo> getMergeRegions(Result data) {
        HRegionInfo mergeA = MetaTableAccessor.getHRegionInfo(data, HConstants.MERGEA_QUALIFIER);
        HRegionInfo mergeB = MetaTableAccessor.getHRegionInfo(data, HConstants.MERGEB_QUALIFIER);
        return new PairOfSameType<HRegionInfo>(mergeA, mergeB);
    }

    @Nullable
    public static TableState getTableState(Connection conn, TableName tableName) throws IOException {
        Table metaHTable = MetaTableAccessor.getMetaHTable(conn);
        Get get = new Get(tableName.getName()).addColumn(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getStateColumn());
        long time = EnvironmentEdgeManager.currentTime();
        get.setTimeRange(0L, time);
        Result result = metaHTable.get(get);
        return MetaTableAccessor.getTableState(result);
    }

    public static Map<TableName, TableState> getTableStates(Connection conn) throws IOException {
        final LinkedHashMap<TableName, TableState> states = new LinkedHashMap<TableName, TableState>();
        Visitor collector = new Visitor(){

            @Override
            public boolean visit(Result r) throws IOException {
                TableState state = MetaTableAccessor.getTableState(r);
                if (state != null) {
                    states.put(state.getTableName(), state);
                }
                return true;
            }
        };
        MetaTableAccessor.fullScanTables(conn, collector);
        return states;
    }

    public static void updateTableState(Connection conn, TableName tableName, TableState.State actual) throws IOException {
        MetaTableAccessor.updateTableState(conn, new TableState(tableName, actual));
    }

    @Nullable
    public static TableState getTableState(Result r) throws IOException {
        Cell cell = r.getColumnLatestCell(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getStateColumn());
        if (cell == null) {
            return null;
        }
        try {
            return TableState.parseFrom(TableName.valueOf(r.getRow()), Arrays.copyOfRange(cell.getValueArray(), cell.getValueOffset(), cell.getValueOffset() + cell.getValueLength()));
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    public static int getRegionCount(Configuration c, TableName tableName) throws IOException {
        try (Connection connection = ConnectionFactory.createConnection(c);){
            int n = MetaTableAccessor.getRegionCount(connection, tableName);
            return n;
        }
    }

    public static int getRegionCount(Connection connection, TableName tableName) throws IOException {
        try (RegionLocator locator = connection.getRegionLocator(tableName);){
            List<HRegionLocation> locations = locator.getAllRegionLocations();
            int n = locations == null ? 0 : locations.size();
            return n;
        }
    }

    public static Put makePutFromRegionInfo(HRegionInfo regionInfo) throws IOException {
        return MetaTableAccessor.makePutFromRegionInfo(regionInfo, EnvironmentEdgeManager.currentTime());
    }

    public static Put makePutFromRegionInfo(HRegionInfo regionInfo, long ts) throws IOException {
        Put put = new Put(regionInfo.getRegionName(), ts);
        MetaTableAccessor.addRegionInfo(put, regionInfo);
        return put;
    }

    public static Delete makeDeleteFromRegionInfo(HRegionInfo regionInfo) {
        long now = EnvironmentEdgeManager.currentTime();
        return MetaTableAccessor.makeDeleteFromRegionInfo(regionInfo, now);
    }

    public static Delete makeDeleteFromRegionInfo(HRegionInfo regionInfo, long ts) {
        if (regionInfo == null) {
            throw new IllegalArgumentException("Can't make a delete for null region");
        }
        Delete delete = new Delete(regionInfo.getRegionName());
        delete.addFamily(MetaTableAccessor.getCatalogFamily(), ts);
        return delete;
    }

    public static Put makeBarrierPut(byte[] encodedRegionName, long seq, byte[] tableName) {
        byte[] seqBytes = Bytes.toBytes(seq);
        return new Put(encodedRegionName).addImmutable(HConstants.REPLICATION_BARRIER_FAMILY, seqBytes, seqBytes).addImmutable(HConstants.REPLICATION_META_FAMILY, tableNameCq, tableName);
    }

    public static Put makeDaughterPut(byte[] encodedRegionName, byte[] value) {
        return new Put(encodedRegionName).addImmutable(HConstants.REPLICATION_META_FAMILY, daughterNameCq, value);
    }

    public static Put makeParentPut(byte[] encodedRegionName, byte[] value) {
        return new Put(encodedRegionName).addImmutable(HConstants.REPLICATION_META_FAMILY, parentNameCq, value);
    }

    public static Put addDaughtersToPut(Put put, HRegionInfo splitA, HRegionInfo splitB) {
        if (splitA != null) {
            put.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, splitA.toByteArray());
        }
        if (splitB != null) {
            put.addImmutable(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, splitB.toByteArray());
        }
        return put;
    }

    public static void putToMetaTable(Connection connection, Put ... puts) throws IOException {
        MetaTableAccessor.put(MetaTableAccessor.getMetaHTable(connection), Arrays.asList(puts));
    }

    private static void put(Table t, List<Put> puts) throws IOException {
        try {
            if (METALOG.isDebugEnabled()) {
                METALOG.debug((Object)MetaTableAccessor.mutationsToString(puts));
            }
            t.put(puts);
        }
        finally {
            t.close();
        }
    }

    public static void putsToMetaTable(Connection connection, List<Put> ps) throws IOException {
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            if (METALOG.isDebugEnabled()) {
                METALOG.debug((Object)MetaTableAccessor.mutationsToString(ps));
            }
            t.put(ps);
        }
    }

    static void deleteFromMetaTable(Connection connection, Delete d) throws IOException {
        ArrayList<Delete> dels = new ArrayList<Delete>(1);
        dels.add(d);
        MetaTableAccessor.deleteFromMetaTable(connection, dels);
    }

    public static void deleteFromMetaTable(Connection connection, List<Delete> deletes) throws IOException {
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            if (METALOG.isDebugEnabled()) {
                METALOG.debug((Object)MetaTableAccessor.mutationsToString(deletes));
            }
            t.delete(deletes);
        }
    }

    public static void removeRegionReplicasFromMeta(Set<byte[]> metaRows, int replicaIndexToDeleteFrom, int numReplicasToRemove, Connection connection) throws IOException {
        int absoluteIndex = replicaIndexToDeleteFrom + numReplicasToRemove;
        for (byte[] row : metaRows) {
            long now = EnvironmentEdgeManager.currentTime();
            Delete deleteReplicaLocations = new Delete(row);
            for (int i = replicaIndexToDeleteFrom; i < absoluteIndex; ++i) {
                deleteReplicaLocations.addColumns(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getServerColumn(i), now);
                deleteReplicaLocations.addColumns(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getSeqNumColumn(i), now);
                deleteReplicaLocations.addColumns(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getStartCodeColumn(i), now);
            }
            MetaTableAccessor.deleteFromMetaTable(connection, deleteReplicaLocations);
        }
    }

    public static void mutateMetaTable(Connection connection, List<Mutation> mutations) throws IOException {
        try (Table t = MetaTableAccessor.getMetaHTable(connection);){
            if (METALOG.isDebugEnabled()) {
                METALOG.debug((Object)MetaTableAccessor.mutationsToString(mutations));
            }
            t.batch(mutations, null);
        }
    }

    public static void addRegionToMeta(Connection connection, HRegionInfo regionInfo) throws IOException {
        MetaTableAccessor.putToMetaTable(connection, MetaTableAccessor.makePutFromRegionInfo(regionInfo));
        LOG.info((Object)("Added " + regionInfo.getRegionNameAsString()));
    }

    public static void addRegionToMeta(Table meta, HRegionInfo regionInfo) throws IOException {
        MetaTableAccessor.addRegionToMeta(meta, regionInfo, null, null);
    }

    public static void addRegionToMeta(Table meta, HRegionInfo regionInfo, HRegionInfo splitA, HRegionInfo splitB) throws IOException {
        Put put = MetaTableAccessor.makePutFromRegionInfo(regionInfo);
        MetaTableAccessor.addDaughtersToPut(put, splitA, splitB);
        meta.put(put);
        if (METALOG.isDebugEnabled()) {
            METALOG.debug((Object)MetaTableAccessor.mutationToString(put));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Added " + regionInfo.getRegionNameAsString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegionToMeta(Connection connection, HRegionInfo regionInfo, HRegionInfo splitA, HRegionInfo splitB) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            MetaTableAccessor.addRegionToMeta(meta, regionInfo, splitA, splitB);
        }
    }

    public static void addRegionsToMeta(Connection connection, List<HRegionInfo> regionInfos, int regionReplication) throws IOException {
        MetaTableAccessor.addRegionsToMeta(connection, regionInfos, regionReplication, Long.MAX_VALUE);
    }

    public static void addRegionsToMeta(Connection connection, List<HRegionInfo> regionInfos, int regionReplication, long ts) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        for (HRegionInfo regionInfo : regionInfos) {
            if (!RegionReplicaUtil.isDefaultReplica(regionInfo)) continue;
            Put put = MetaTableAccessor.makePutFromRegionInfo(regionInfo, ts);
            for (int i = 1; i < regionReplication; ++i) {
                MetaTableAccessor.addEmptyLocation(put, i);
            }
            puts.add(put);
        }
        MetaTableAccessor.putsToMetaTable(connection, puts);
        LOG.info((Object)("Added " + puts.size()));
    }

    public static void addDaughter(Connection connection, HRegionInfo regionInfo, ServerName sn, long openSeqNum) throws NotAllMetaRegionsOnlineException, IOException {
        long now = EnvironmentEdgeManager.currentTime();
        Put put = new Put(regionInfo.getRegionName(), now);
        MetaTableAccessor.addRegionInfo(put, regionInfo);
        if (sn != null) {
            MetaTableAccessor.addLocation(put, sn, openSeqNum, -1L, regionInfo.getReplicaId());
        }
        MetaTableAccessor.putToMetaTable(connection, put);
        LOG.info((Object)("Added daughter " + regionInfo.getEncodedName() + (sn == null ? ", serverName=null" : ", serverName=" + sn.toString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeRegions(Connection connection, HRegionInfo mergedRegion, HRegionInfo regionA, HRegionInfo regionB, ServerName sn, int regionReplication, long masterSystemTime, boolean saveBarrier) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            Mutation[] mutations;
            HRegionInfo copyOfMerged = new HRegionInfo(mergedRegion);
            long time = Math.max(EnvironmentEdgeManager.currentTime(), masterSystemTime);
            Put putOfMerged = MetaTableAccessor.makePutFromRegionInfo(copyOfMerged, time);
            putOfMerged.addImmutable(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER, regionA.toByteArray());
            putOfMerged.addImmutable(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER, regionB.toByteArray());
            Delete deleteA = MetaTableAccessor.makeDeleteFromRegionInfo(regionA, time);
            Delete deleteB = MetaTableAccessor.makeDeleteFromRegionInfo(regionB, time);
            if (sn != null) {
                MetaTableAccessor.addLocation(putOfMerged, sn, 1L, -1L, mergedRegion.getReplicaId());
            }
            for (int i = 1; i < regionReplication; ++i) {
                MetaTableAccessor.addEmptyLocation(putOfMerged, i);
            }
            byte[] tableRow = Bytes.toBytes(mergedRegion.getRegionNameAsString() + 44);
            if (saveBarrier) {
                Put putBarrierA = MetaTableAccessor.makeDaughterPut(regionA.getEncodedNameAsBytes(), mergedRegion.getEncodedNameAsBytes());
                Put putBarrierB = MetaTableAccessor.makeDaughterPut(regionB.getEncodedNameAsBytes(), mergedRegion.getEncodedNameAsBytes());
                Put putDaughter = MetaTableAccessor.makeParentPut(mergedRegion.getEncodedNameAsBytes(), Bytes.toBytes(regionA.getEncodedName() + "," + regionB.getEncodedName()));
                mutations = new Mutation[]{putOfMerged, deleteA, deleteB, putBarrierA, putBarrierB, putDaughter};
            } else {
                mutations = new Mutation[]{putOfMerged, deleteA, deleteB};
            }
            MetaTableAccessor.multiMutate(connection, meta, tableRow, mutations);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitRegion(Connection connection, HRegionInfo parent, HRegionInfo splitA, HRegionInfo splitB, ServerName sn, int regionReplication, boolean saveBarrier) throws IOException {
        try (Table meta = MetaTableAccessor.getMetaHTable(connection);){
            Mutation[] mutations;
            HRegionInfo copyOfParent = new HRegionInfo(parent);
            copyOfParent.setOffline(true);
            copyOfParent.setSplit(true);
            Put putParent = MetaTableAccessor.makePutFromRegionInfo(copyOfParent);
            MetaTableAccessor.addDaughtersToPut(putParent, splitA, splitB);
            Put putA = MetaTableAccessor.makePutFromRegionInfo(splitA);
            Put putB = MetaTableAccessor.makePutFromRegionInfo(splitB);
            MetaTableAccessor.addLocation(putA, sn, 1L, -1L, splitA.getReplicaId());
            MetaTableAccessor.addLocation(putB, sn, 1L, -1L, splitB.getReplicaId());
            for (int i = 1; i < regionReplication; ++i) {
                MetaTableAccessor.addEmptyLocation(putA, i);
                MetaTableAccessor.addEmptyLocation(putB, i);
            }
            if (saveBarrier) {
                Put parentPut = MetaTableAccessor.makeDaughterPut(parent.getEncodedNameAsBytes(), Bytes.toBytes(splitA.getEncodedName() + "," + splitB.getEncodedName()));
                Put daughterPutA = MetaTableAccessor.makeParentPut(splitA.getEncodedNameAsBytes(), parent.getEncodedNameAsBytes());
                Put daughterPutB = MetaTableAccessor.makeParentPut(splitB.getEncodedNameAsBytes(), parent.getEncodedNameAsBytes());
                mutations = new Mutation[]{putParent, putA, putB, parentPut, daughterPutA, daughterPutB};
            } else {
                mutations = new Mutation[]{putParent, putA, putB};
            }
            byte[] tableRow = Bytes.toBytes(parent.getRegionNameAsString() + 44);
            MetaTableAccessor.multiMutate(connection, meta, tableRow, mutations);
        }
    }

    public static void updateTableState(Connection connection, TableState state) throws IOException {
        Put put = MetaTableAccessor.makePutFromTableState(state);
        MetaTableAccessor.putToMetaTable(connection, put);
        LOG.info((Object)("Updated table " + state.getTableName() + " state to " + (Object)((Object)state.getState()) + " in META"));
    }

    public static Put makePutFromTableState(TableState state) {
        long time = EnvironmentEdgeManager.currentTime();
        Put put = new Put(state.getTableName().getName(), time);
        put.addColumn(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getStateColumn(), state.convert().toByteArray());
        return put;
    }

    public static void deleteTableState(Connection connection, TableName table) throws IOException {
        long time = EnvironmentEdgeManager.currentTime();
        Delete delete = new Delete(table.getName());
        delete.addColumns(MetaTableAccessor.getTableFamily(), MetaTableAccessor.getStateColumn(), time);
        MetaTableAccessor.deleteFromMetaTable(connection, delete);
        LOG.info((Object)("Deleted table " + table + " state from META"));
    }

    private static void multiMutate(Connection connection, Table table, byte[] row, Mutation ... mutations) throws IOException {
        MetaTableAccessor.multiMutate(connection, table, row, Arrays.asList(mutations));
    }

    public static void multiMutate(Connection connection, final Table table, byte[] row, final List<Mutation> mutations) throws IOException {
        if (METALOG.isDebugEnabled()) {
            METALOG.debug((Object)MetaTableAccessor.mutationsToString(mutations));
        }
        RegionServerCallable<MultiRowMutationProtos.MutateRowsResponse, MultiRowMutationProtos.MultiRowMutationService.BlockingInterface> callable = new RegionServerCallable<MultiRowMutationProtos.MutateRowsResponse, MultiRowMutationProtos.MultiRowMutationService.BlockingInterface>(connection, table.getName(), row, null){

            @Override
            protected MultiRowMutationProtos.MutateRowsResponse rpcCall() throws Exception {
                MultiRowMutationProtos.MutateRowsRequest.Builder builder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
                for (Mutation mutation : mutations) {
                    if (mutation instanceof Put) {
                        builder.addMutationRequest(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.PUT, mutation));
                        continue;
                    }
                    if (mutation instanceof Delete) {
                        builder.addMutationRequest(ProtobufUtil.toMutation(ClientProtos.MutationProto.MutationType.DELETE, mutation));
                        continue;
                    }
                    throw new DoNotRetryIOException("multi in MetaEditor doesn't support " + mutation.getClass().getName());
                }
                HRegionLocation hrl = this.getLocation();
                HBaseProtos.RegionSpecifier region = ProtobufUtil.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, hrl.getRegionInfo().getRegionName());
                builder.setRegion(region);
                return ((MultiRowMutationProtos.MultiRowMutationService.BlockingInterface)this.getStub()).mutateRows(null, builder.build());
            }

            @Override
            protected void setStubByServiceName(ServerName serviceName) throws IOException {
                CoprocessorRpcChannel channel = table.coprocessorService(this.getRow());
                this.setStub(MultiRowMutationProtos.MultiRowMutationService.newBlockingStub(channel));
            }
        };
        int writeTimeout = connection.getConfiguration().getInt("hbase.rpc.write.timeout", connection.getConfiguration().getInt("hbase.rpc.timeout", 60000));
        callable.prepare(false);
        callable.call(writeTimeout);
    }

    public static void updateRegionLocation(Connection connection, HRegionInfo regionInfo, ServerName sn, long openSeqNum, long masterSystemTime) throws IOException {
        MetaTableAccessor.updateLocation(connection, regionInfo, sn, openSeqNum, masterSystemTime);
    }

    public static void updateReplicationPositions(Connection connection, String peerId, Map<String, Long> positions) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>(positions.entrySet().size());
        for (Map.Entry<String, Long> entry : positions.entrySet()) {
            long value = Math.abs(entry.getValue());
            Put put = new Put(Bytes.toBytes(entry.getKey()));
            put.addImmutable(HConstants.REPLICATION_POSITION_FAMILY, Bytes.toBytes(peerId), Bytes.toBytes(value));
            puts.add(put);
        }
        MetaTableAccessor.getMetaHTable(connection).put(puts);
    }

    private static void updateLocation(Connection connection, HRegionInfo regionInfo, ServerName sn, long openSeqNum, long masterSystemTime) throws IOException {
        long time = Math.max(EnvironmentEdgeManager.currentTime(), masterSystemTime);
        Put put = new Put(MetaTableAccessor.getMetaKeyForRegion(regionInfo), time);
        MetaTableAccessor.addRegionInfo(put, regionInfo);
        MetaTableAccessor.addLocation(put, sn, openSeqNum, time, regionInfo.getReplicaId());
        MetaTableAccessor.putToMetaTable(connection, put);
        LOG.info((Object)("Updated row " + regionInfo.getRegionNameAsString() + " with server=" + sn));
    }

    public static void deleteRegion(Connection connection, HRegionInfo regionInfo) throws IOException {
        long time = EnvironmentEdgeManager.currentTime();
        Delete delete = new Delete(regionInfo.getRegionName());
        delete.addFamily(MetaTableAccessor.getCatalogFamily(), time);
        MetaTableAccessor.deleteFromMetaTable(connection, delete);
        LOG.info((Object)("Deleted " + regionInfo.getRegionNameAsString()));
    }

    public static void deleteRegions(Connection connection, List<HRegionInfo> regionsInfo) throws IOException {
        MetaTableAccessor.deleteRegions(connection, regionsInfo, EnvironmentEdgeManager.currentTime());
    }

    public static void deleteRegions(Connection connection, List<HRegionInfo> regionsInfo, long ts) throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>(regionsInfo.size());
        for (HRegionInfo hri : regionsInfo) {
            Delete e = new Delete(hri.getRegionName());
            e.addFamily(MetaTableAccessor.getCatalogFamily(), ts);
            deletes.add(e);
        }
        MetaTableAccessor.deleteFromMetaTable(connection, deletes);
        LOG.info((Object)("Deleted " + regionsInfo));
    }

    public static void mutateRegions(Connection connection, List<HRegionInfo> regionsToRemove, List<HRegionInfo> regionsToAdd) throws IOException {
        ArrayList<Mutation> mutation = new ArrayList<Mutation>();
        if (regionsToRemove != null) {
            for (HRegionInfo hri : regionsToRemove) {
                mutation.add(MetaTableAccessor.makeDeleteFromRegionInfo(hri));
            }
        }
        if (regionsToAdd != null) {
            for (HRegionInfo hri : regionsToAdd) {
                mutation.add(MetaTableAccessor.makePutFromRegionInfo(hri));
            }
        }
        MetaTableAccessor.mutateMetaTable(connection, mutation);
        if (regionsToRemove != null && regionsToRemove.size() > 0) {
            LOG.debug((Object)("Deleted " + HRegionInfo.getShortNameToLog(regionsToRemove)));
        }
        if (regionsToAdd != null && regionsToAdd.size() > 0) {
            LOG.debug((Object)("Added " + HRegionInfo.getShortNameToLog(regionsToAdd)));
        }
    }

    public static void overwriteRegions(Connection connection, List<HRegionInfo> regionInfos, int regionReplication) throws IOException {
        long now = EnvironmentEdgeManager.currentTime();
        MetaTableAccessor.deleteRegions(connection, regionInfos, now);
        MetaTableAccessor.addRegionsToMeta(connection, regionInfos, regionReplication, now + 1L);
        LOG.info((Object)("Overwritten " + regionInfos));
    }

    public static void deleteMergeQualifiers(Connection connection, HRegionInfo mergedRegion) throws IOException {
        long time = EnvironmentEdgeManager.currentTime();
        Delete delete = new Delete(mergedRegion.getRegionName());
        delete.addColumns(MetaTableAccessor.getCatalogFamily(), HConstants.MERGEA_QUALIFIER, time);
        delete.addColumns(MetaTableAccessor.getCatalogFamily(), HConstants.MERGEB_QUALIFIER, time);
        MetaTableAccessor.deleteFromMetaTable(connection, delete);
        LOG.info((Object)("Deleted references in merged region " + mergedRegion.getRegionNameAsString() + ", qualifier=" + Bytes.toStringBinary(HConstants.MERGEA_QUALIFIER) + " and qualifier=" + Bytes.toStringBinary(HConstants.MERGEB_QUALIFIER)));
    }

    public static Put addRegionInfo(Put p, HRegionInfo hri) throws IOException {
        p.addImmutable(MetaTableAccessor.getCatalogFamily(), HConstants.REGIONINFO_QUALIFIER, hri.toByteArray());
        return p;
    }

    public static Put addLocation(Put p, ServerName sn, long openSeqNum, long time, int replicaId) {
        if (time <= 0L) {
            time = EnvironmentEdgeManager.currentTime();
        }
        p.addImmutable(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getServerColumn(replicaId), time, Bytes.toBytes(sn.getHostAndPort()));
        p.addImmutable(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getStartCodeColumn(replicaId), time, Bytes.toBytes(sn.getStartcode()));
        p.addImmutable(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getSeqNumColumn(replicaId), time, Bytes.toBytes(openSeqNum));
        return p;
    }

    public static Put addEmptyLocation(Put p, int replicaId) {
        long now = EnvironmentEdgeManager.currentTime();
        p.addImmutable(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getServerColumn(replicaId), now, null);
        p.addImmutable(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getStartCodeColumn(replicaId), now, null);
        p.addImmutable(MetaTableAccessor.getCatalogFamily(), MetaTableAccessor.getSeqNumColumn(replicaId), now, null);
        return p;
    }

    private static String mutationsToString(List<? extends Mutation> mutations) throws IOException {
        StringBuilder sb = new StringBuilder();
        String prefix = "";
        for (Mutation mutation : mutations) {
            sb.append(prefix).append(MetaTableAccessor.mutationToString(mutation));
            prefix = ", ";
        }
        return sb.toString();
    }

    private static String mutationToString(Mutation p) throws IOException {
        return p.getClass().getSimpleName() + p.toJSON();
    }

    public static long getReplicationPositionForOnePeer(Connection connection, byte[] encodedRegionName, String peerId) throws IOException {
        Get get = new Get(encodedRegionName);
        get.addColumn(HConstants.REPLICATION_POSITION_FAMILY, Bytes.toBytes(peerId));
        Result r = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        if (r.isEmpty()) {
            return -1L;
        }
        Cell cell = r.rawCells()[0];
        return Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    public static Map<String, Long> getReplicationPositionForAllPeer(Connection connection, byte[] encodedRegionName) throws IOException {
        Get get = new Get(encodedRegionName);
        get.addFamily(HConstants.REPLICATION_POSITION_FAMILY);
        Result r = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        HashMap<String, Long> map = new HashMap<String, Long>((int)((double)r.size() / 0.75 + 1.0));
        for (Cell c : r.listCells()) {
            map.put(Bytes.toString(c.getQualifierArray(), c.getQualifierOffset(), c.getQualifierLength()), Bytes.toLong(c.getValueArray(), c.getValueOffset(), c.getValueLength()));
        }
        return map;
    }

    public static List<Long> getReplicationBarriers(Connection connection, byte[] encodedRegionName) throws IOException {
        Get get = new Get(encodedRegionName);
        get.addFamily(HConstants.REPLICATION_BARRIER_FAMILY);
        Result r = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        ArrayList<Long> list = new ArrayList<Long>();
        if (!r.isEmpty()) {
            for (Cell cell : r.rawCells()) {
                list.add(Bytes.toLong(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
            }
        }
        return list;
    }

    public static Map<String, List<Long>> getAllBarriers(Connection connection) throws IOException {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        Scan scan = new Scan();
        scan.addFamily(HConstants.REPLICATION_BARRIER_FAMILY);
        try (Table t = MetaTableAccessor.getMetaHTable(connection);
             ResultScanner scanner = t.getScanner(scan);){
            Result result;
            while ((result = scanner.next()) != null) {
                String key = Bytes.toString(result.getRow());
                ArrayList<Long> list = new ArrayList<Long>(result.rawCells().length);
                for (Cell cell : result.rawCells()) {
                    list.add(Bytes.toLong(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
                }
                map.put(key, list);
            }
        }
        return map;
    }

    public static String getSerialReplicationDaughterRegion(Connection connection, byte[] encodedName) throws IOException {
        Get get = new Get(encodedName);
        get.addColumn(HConstants.REPLICATION_META_FAMILY, daughterNameCq);
        Result result = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        if (!result.isEmpty()) {
            Cell c = result.rawCells()[0];
            return Bytes.toString(c.getValueArray(), c.getValueOffset(), c.getValueLength());
        }
        return null;
    }

    public static String getSerialReplicationParentRegion(Connection connection, byte[] encodedName) throws IOException {
        Get get = new Get(encodedName);
        get.addColumn(HConstants.REPLICATION_META_FAMILY, parentNameCq);
        Result result = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        if (!result.isEmpty()) {
            Cell c = result.rawCells()[0];
            return Bytes.toString(c.getValueArray(), c.getValueOffset(), c.getValueLength());
        }
        return null;
    }

    public static String getSerialReplicationTableName(Connection connection, byte[] encodedName) throws IOException {
        Get get = new Get(encodedName);
        get.addColumn(HConstants.REPLICATION_META_FAMILY, tableNameCq);
        Result result = MetaTableAccessor.get(MetaTableAccessor.getMetaHTable(connection), get);
        if (!result.isEmpty()) {
            Cell c = result.rawCells()[0];
            return Bytes.toString(c.getValueArray(), c.getValueOffset(), c.getValueLength());
        }
        return null;
    }

    static {
        int len = HRegionInfo.FIRST_META_REGIONINFO.getRegionName().length - 2;
        META_REGION_PREFIX = new byte[len];
        System.arraycopy(HRegionInfo.FIRST_META_REGIONINFO.getRegionName(), 0, META_REGION_PREFIX, 0, len);
        SERVER_COLUMN_PATTERN = Pattern.compile("^server(_[0-9a-fA-F]{4})?$");
    }

    public static abstract class TableVisitorBase
    extends DefaultVisitorBase {
        private TableName tableName;

        public TableVisitorBase(TableName tableName) {
            this.tableName = tableName;
        }

        @Override
        public final boolean visit(Result rowResult) throws IOException {
            HRegionInfo info = MetaTableAccessor.getHRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.getTable().equals(this.tableName)) {
                return false;
            }
            return super.visit(rowResult);
        }
    }

    public static abstract class DefaultVisitorBase
    implements Visitor {
        public abstract boolean visitInternal(Result var1) throws IOException;

        @Override
        public boolean visit(Result rowResult) throws IOException {
            HRegionInfo info = MetaTableAccessor.getHRegionInfo(rowResult);
            if (info == null) {
                return true;
            }
            if (!info.isOffline() && !info.isSplit()) {
                return this.visitInternal(rowResult);
            }
            return true;
        }
    }

    static class CollectAllVisitor
    extends CollectingVisitor<Result> {
        CollectAllVisitor() {
        }

        @Override
        void add(Result r) {
            this.results.add(r);
        }
    }

    static abstract class CollectingVisitor<T>
    implements Visitor {
        final List<T> results = new ArrayList<T>();

        CollectingVisitor() {
        }

        @Override
        public boolean visit(Result r) throws IOException {
            if (r == null || r.isEmpty()) {
                return true;
            }
            this.add(r);
            return true;
        }

        abstract void add(Result var1);

        List<T> getResults() {
            return this.results;
        }
    }

    public static interface CloseableVisitor
    extends Visitor,
    Closeable {
    }

    public static interface Visitor {
        public boolean visit(Result var1) throws IOException;
    }

    @InterfaceAudience.Private
    public static enum QueryType {
        ALL(HConstants.TABLE_FAMILY, HConstants.CATALOG_FAMILY),
        REGION(new byte[][]{HConstants.CATALOG_FAMILY}),
        TABLE(new byte[][]{HConstants.TABLE_FAMILY});

        private final byte[][] families;

        private QueryType(byte[] ... families) {
            this.families = families;
        }

        byte[][] getFamilies() {
            return this.families;
        }
    }
}

