/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class IndividualBytesFieldCell
implements ExtendedCell {
    private static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 9 + 8 + 5 * ClassSize.REFERENCE);
    private byte[] row;
    private byte[] family;
    private byte[] qualifier;
    private byte[] value;
    private byte[] tags;
    private long timestamp;
    private byte type;
    private long seqId;

    public IndividualBytesFieldCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, KeyValue.Type type, byte[] value) {
        this(row, family, qualifier, timestamp, type, 0L, value, null);
    }

    public IndividualBytesFieldCell(byte[] row, byte[] family, byte[] qualifier, long timestamp, KeyValue.Type type, long seqId, byte[] value, byte[] tags) {
        KeyValue.checkParameters(row, row == null ? 0 : row.length, family, family == null ? 0 : family.length, qualifier == null ? 0 : qualifier.length, value == null ? 0 : value.length);
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + timestamp);
        }
        TagUtil.checkForTagsLength(tags == null ? 0 : tags.length);
        this.row = row;
        this.family = family;
        this.qualifier = qualifier;
        this.value = value;
        this.tags = tags;
        this.timestamp = timestamp;
        this.type = type.getCode();
        this.seqId = seqId;
    }

    @Override
    public int write(OutputStream out, boolean withTags) throws IOException {
        ByteBufferUtils.putInt(out, KeyValueUtil.keyLength(this));
        ByteBufferUtils.putInt(out, this.getValueLength());
        CellUtil.writeFlatKey((Cell)this, out);
        out.write(this.getValueArray());
        if (withTags && this.getTagsLength() > 0) {
            out.write((byte)(0xFF & this.tags.length >> 8));
            out.write((byte)(0xFF & this.tags.length));
            out.write(this.tags);
        }
        return this.getSerializedSize(withTags);
    }

    @Override
    public void write(ByteBuffer buf, int offset) {
        KeyValueUtil.appendTo(this, buf, offset, true);
    }

    @Override
    public int getSerializedSize(boolean withTags) {
        return KeyValueUtil.length(this.getRowLength(), this.getFamilyLength(), this.getQualifierLength(), this.getValueLength(), this.getTagsLength(), withTags);
    }

    private long heapOverhead() {
        return FIXED_OVERHEAD + (long)ClassSize.ARRAY + (long)(this.family == null ? 0 : ClassSize.ARRAY) + (long)(this.qualifier == null ? 0 : ClassSize.ARRAY) + (long)(this.value == null ? 0 : ClassSize.ARRAY) + (long)(this.tags == null ? 0 : ClassSize.ARRAY);
    }

    @Override
    public Cell deepClone() {
        return new KeyValue(this);
    }

    @Override
    public byte[] getRowArray() {
        return this.row;
    }

    @Override
    public int getRowOffset() {
        return 0;
    }

    @Override
    public short getRowLength() {
        return (short)this.row.length;
    }

    @Override
    public byte[] getFamilyArray() {
        return this.family == null ? HConstants.EMPTY_BYTE_ARRAY : this.family;
    }

    @Override
    public int getFamilyOffset() {
        return 0;
    }

    @Override
    public byte getFamilyLength() {
        return this.family == null ? (byte)0 : (byte)this.family.length;
    }

    @Override
    public byte[] getQualifierArray() {
        return this.qualifier == null ? HConstants.EMPTY_BYTE_ARRAY : this.qualifier;
    }

    @Override
    public int getQualifierOffset() {
        return 0;
    }

    @Override
    public int getQualifierLength() {
        return this.qualifier == null ? 0 : this.qualifier.length;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public byte getTypeByte() {
        return this.type;
    }

    @Override
    public long getSequenceId() {
        return this.seqId;
    }

    @Override
    public byte[] getValueArray() {
        return this.value == null ? HConstants.EMPTY_BYTE_ARRAY : this.value;
    }

    @Override
    public int getValueOffset() {
        return 0;
    }

    @Override
    public int getValueLength() {
        return this.value == null ? 0 : this.value.length;
    }

    @Override
    public byte[] getTagsArray() {
        return this.tags == null ? HConstants.EMPTY_BYTE_ARRAY : this.tags;
    }

    @Override
    public int getTagsOffset() {
        return 0;
    }

    @Override
    public int getTagsLength() {
        return this.tags == null ? 0 : this.tags.length;
    }

    @Override
    public long heapSize() {
        return this.heapOverhead() + (long)ClassSize.align(this.getRowLength()) + (long)ClassSize.align(this.getFamilyLength()) + (long)ClassSize.align(this.getQualifierLength()) + (long)ClassSize.align(this.getValueLength()) + (long)ClassSize.align(this.getTagsLength());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void setSequenceId(long seqId) {
        if (seqId < 0L) {
            throw new IllegalArgumentException("Sequence Id cannot be negative. ts=" + seqId);
        }
        this.seqId = seqId;
    }

    @Override
    public void setTimestamp(long ts) {
        if (ts < 0L) {
            throw new IllegalArgumentException("Timestamp cannot be negative. ts=" + ts);
        }
        this.timestamp = ts;
    }

    @Override
    public void setTimestamp(byte[] ts, int tsOffset) {
        this.setTimestamp(Bytes.toLong(ts, tsOffset));
    }
}

