/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.MobCompactPartitionPolicy;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.exceptions.HBaseException;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.PrettyPrinter;

@InterfaceAudience.Public
public class HColumnDescriptor
implements Comparable<HColumnDescriptor> {
    private static final byte COLUMN_DESCRIPTOR_VERSION = 11;
    public static final String IN_MEMORY_COMPACTION = "IN_MEMORY_COMPACTION";
    public static final String COMPRESSION = "COMPRESSION";
    public static final String COMPRESSION_COMPACT = "COMPRESSION_COMPACT";
    public static final String ENCODE_ON_DISK = "ENCODE_ON_DISK";
    public static final String DATA_BLOCK_ENCODING = "DATA_BLOCK_ENCODING";
    public static final String BLOCKCACHE = "BLOCKCACHE";
    public static final String CACHE_DATA_ON_WRITE = "CACHE_DATA_ON_WRITE";
    public static final String CACHE_INDEX_ON_WRITE = "CACHE_INDEX_ON_WRITE";
    public static final String CACHE_BLOOMS_ON_WRITE = "CACHE_BLOOMS_ON_WRITE";
    public static final String EVICT_BLOCKS_ON_CLOSE = "EVICT_BLOCKS_ON_CLOSE";
    public static final String CACHE_DATA_IN_L1 = "CACHE_DATA_IN_L1";
    public static final String PREFETCH_BLOCKS_ON_OPEN = "PREFETCH_BLOCKS_ON_OPEN";
    public static final String BLOCKSIZE = "BLOCKSIZE";
    public static final String LENGTH = "LENGTH";
    public static final String TTL = "TTL";
    public static final String BLOOMFILTER = "BLOOMFILTER";
    public static final String FOREVER = "FOREVER";
    public static final String REPLICATION_SCOPE = "REPLICATION_SCOPE";
    public static final byte[] REPLICATION_SCOPE_BYTES = Bytes.toBytes("REPLICATION_SCOPE");
    public static final String MIN_VERSIONS = "MIN_VERSIONS";
    public static final String KEEP_DELETED_CELLS = "KEEP_DELETED_CELLS";
    public static final String COMPRESS_TAGS = "COMPRESS_TAGS";
    public static final String ENCRYPTION = "ENCRYPTION";
    public static final String ENCRYPTION_KEY = "ENCRYPTION_KEY";
    public static final String IS_MOB = "IS_MOB";
    public static final byte[] IS_MOB_BYTES = Bytes.toBytes("IS_MOB");
    public static final String MOB_THRESHOLD = "MOB_THRESHOLD";
    public static final byte[] MOB_THRESHOLD_BYTES = Bytes.toBytes("MOB_THRESHOLD");
    public static final long DEFAULT_MOB_THRESHOLD = 102400L;
    public static final String MOB_COMPACT_PARTITION_POLICY = "MOB_COMPACT_PARTITION_POLICY";
    public static final byte[] MOB_COMPACT_PARTITION_POLICY_BYTES = Bytes.toBytes("MOB_COMPACT_PARTITION_POLICY");
    public static final MobCompactPartitionPolicy DEFAULT_MOB_COMPACT_PARTITION_POLICY = MobCompactPartitionPolicy.DAILY;
    public static final String DFS_REPLICATION = "DFS_REPLICATION";
    public static final short DEFAULT_DFS_REPLICATION = 0;
    public static final String STORAGE_POLICY = "STORAGE_POLICY";
    public static final String DEFAULT_COMPRESSION = Compression.Algorithm.NONE.getName();
    public static final boolean DEFAULT_ENCODE_ON_DISK = true;
    public static final String DEFAULT_DATA_BLOCK_ENCODING = DataBlockEncoding.NONE.toString();
    public static final int DEFAULT_VERSIONS = HBaseConfiguration.create().getInt("hbase.column.max.version", 1);
    public static final int DEFAULT_MIN_VERSIONS = 0;
    private volatile Integer blocksize = null;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final KeepDeletedCells DEFAULT_KEEP_DELETED = KeepDeletedCells.FALSE;
    public static final boolean DEFAULT_BLOCKCACHE = true;
    public static final boolean DEFAULT_CACHE_DATA_ON_WRITE = false;
    public static final boolean DEFAULT_CACHE_DATA_IN_L1 = false;
    public static final boolean DEFAULT_CACHE_INDEX_ON_WRITE = false;
    public static final int DEFAULT_BLOCKSIZE = 65536;
    public static final String DEFAULT_BLOOMFILTER = BloomType.ROW.toString();
    public static final boolean DEFAULT_CACHE_BLOOMS_ON_WRITE = false;
    public static final int DEFAULT_TTL = Integer.MAX_VALUE;
    public static final int DEFAULT_REPLICATION_SCOPE = 0;
    public static final boolean DEFAULT_EVICT_BLOCKS_ON_CLOSE = false;
    public static final boolean DEFAULT_COMPRESS_TAGS = true;
    public static final boolean DEFAULT_PREFETCH_BLOCKS_ON_OPEN = false;
    private static final Map<String, String> DEFAULT_VALUES = new HashMap<String, String>();
    private static final Set<Bytes> RESERVED_KEYWORDS = new HashSet<Bytes>();
    private static final int UNINITIALIZED = -1;
    private byte[] name;
    private final Map<Bytes, Bytes> values = new HashMap<Bytes, Bytes>();
    private final Map<String, String> configuration = new HashMap<String, String>();
    private int cachedMaxVersions = -1;

    public HColumnDescriptor(String familyName) {
        this(Bytes.toBytes(familyName));
    }

    public HColumnDescriptor(byte[] familyName) {
        HColumnDescriptor.isLegalFamilyName(familyName);
        this.name = familyName;
        this.setMaxVersions(DEFAULT_VERSIONS);
        this.setMinVersions(0);
        this.setKeepDeletedCells(DEFAULT_KEEP_DELETED);
        this.setInMemory(false);
        this.setBlockCacheEnabled(true);
        this.setTimeToLive(Integer.MAX_VALUE);
        this.setCompressionType(Compression.Algorithm.valueOf(DEFAULT_COMPRESSION.toUpperCase(Locale.ROOT)));
        this.setDataBlockEncoding(DataBlockEncoding.valueOf(DEFAULT_DATA_BLOCK_ENCODING.toUpperCase(Locale.ROOT)));
        this.setBloomFilterType(BloomType.valueOf(DEFAULT_BLOOMFILTER.toUpperCase(Locale.ROOT)));
        this.setBlocksize(65536);
        this.setScope(0);
    }

    public HColumnDescriptor(HColumnDescriptor desc) {
        this.name = (byte[])desc.name.clone();
        for (Map.Entry<Bytes, Bytes> entry : desc.values.entrySet()) {
            this.values.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : desc.configuration.entrySet()) {
            this.configuration.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.setMaxVersions(desc.getMaxVersions());
    }

    public static byte[] isLegalFamilyName(byte[] b) {
        if (b == null) {
            return b;
        }
        Preconditions.checkArgument(b.length != 0, "Family name can not be empty");
        if (b[0] == 46) {
            throw new IllegalArgumentException("Family names cannot start with a period: " + Bytes.toString(b));
        }
        for (int i = 0; i < b.length; ++i) {
            if (!Character.isISOControl(b[i]) && b[i] != 58 && b[i] != 92 && b[i] != 47) continue;
            throw new IllegalArgumentException("Illegal character <" + b[i] + ">. Family names cannot contain control characters or colons: " + Bytes.toString(b));
        }
        byte[] recoveredEdit = Bytes.toBytes("recovered.edits");
        if (Bytes.equals(recoveredEdit, b)) {
            throw new IllegalArgumentException("Family name cannot be: recovered.edits");
        }
        return b;
    }

    public byte[] getName() {
        return this.name;
    }

    public String getNameAsString() {
        return Bytes.toString(this.name);
    }

    public byte[] getValue(byte[] key) {
        Bytes ibw = this.values.get(new Bytes(key));
        if (ibw == null) {
            return null;
        }
        return ibw.get();
    }

    public String getValue(String key) {
        byte[] value = this.getValue(Bytes.toBytes(key));
        if (value == null) {
            return null;
        }
        return Bytes.toString(value);
    }

    public Map<Bytes, Bytes> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public HColumnDescriptor setValue(byte[] key, byte[] value) {
        if (Bytes.compareTo(Bytes.toBytes("VERSIONS"), key) == 0) {
            this.cachedMaxVersions = -1;
        }
        this.values.put(new Bytes(key), new Bytes(value));
        return this;
    }

    public void remove(byte[] key) {
        this.values.remove(new Bytes(key));
    }

    public HColumnDescriptor setValue(String key, String value) {
        if (value == null) {
            this.remove(Bytes.toBytes(key));
        } else {
            this.setValue(Bytes.toBytes(key), Bytes.toBytes(value));
        }
        return this;
    }

    @Deprecated
    public Compression.Algorithm getCompression() {
        return this.getCompressionType();
    }

    @Deprecated
    public Compression.Algorithm getCompactionCompression() {
        return this.getCompactionCompressionType();
    }

    public int getMaxVersions() {
        if (this.cachedMaxVersions == -1) {
            String v = this.getValue("VERSIONS");
            this.cachedMaxVersions = Integer.parseInt(v);
        }
        return this.cachedMaxVersions;
    }

    public HColumnDescriptor setMaxVersions(int maxVersions) {
        if (maxVersions <= 0) {
            throw new IllegalArgumentException("Maximum versions must be positive");
        }
        if (maxVersions < this.getMinVersions()) {
            throw new IllegalArgumentException("Set MaxVersion to " + maxVersions + " while minVersion is " + this.getMinVersions() + ". Maximum versions must be >= minimum versions ");
        }
        this.setValue("VERSIONS", Integer.toString(maxVersions));
        this.cachedMaxVersions = maxVersions;
        return this;
    }

    public HColumnDescriptor setVersions(int minVersions, int maxVersions) {
        if (minVersions <= 0) {
            throw new IllegalArgumentException("Minimum versions must be positive");
        }
        if (maxVersions < minVersions) {
            throw new IllegalArgumentException("Unable to set MaxVersion to " + maxVersions + " and set MinVersion to " + minVersions + ", as maximum versions must be >= minimum versions.");
        }
        this.setMinVersions(minVersions);
        this.setMaxVersions(maxVersions);
        return this;
    }

    public synchronized int getBlocksize() {
        if (this.blocksize == null) {
            String value = this.getValue(BLOCKSIZE);
            this.blocksize = value != null ? Integer.decode(value) : Integer.valueOf(65536);
        }
        return this.blocksize;
    }

    public HColumnDescriptor setBlocksize(int s) {
        this.setValue(BLOCKSIZE, Integer.toString(s));
        this.blocksize = null;
        return this;
    }

    public Compression.Algorithm getCompressionType() {
        String n = this.getValue(COMPRESSION);
        if (n == null) {
            return Compression.Algorithm.NONE;
        }
        return Compression.Algorithm.valueOf(n.toUpperCase(Locale.ROOT));
    }

    public HColumnDescriptor setCompressionType(Compression.Algorithm type) {
        return this.setValue(COMPRESSION, type.getName().toUpperCase(Locale.ROOT));
    }

    public DataBlockEncoding getDataBlockEncoding() {
        String type = this.getValue(DATA_BLOCK_ENCODING);
        if (type == null) {
            type = DEFAULT_DATA_BLOCK_ENCODING;
        }
        return DataBlockEncoding.valueOf(type);
    }

    public HColumnDescriptor setDataBlockEncoding(DataBlockEncoding type) {
        String name = type != null ? type.toString() : DataBlockEncoding.NONE.toString();
        return this.setValue(DATA_BLOCK_ENCODING, name);
    }

    public HColumnDescriptor setCompressTags(boolean compressTags) {
        return this.setValue(COMPRESS_TAGS, String.valueOf(compressTags));
    }

    public boolean isCompressTags() {
        String compressTagsStr = this.getValue(COMPRESS_TAGS);
        boolean compressTags = true;
        if (compressTagsStr != null) {
            compressTags = Boolean.parseBoolean(compressTagsStr);
        }
        return compressTags;
    }

    public Compression.Algorithm getCompactionCompressionType() {
        String n = this.getValue(COMPRESSION_COMPACT);
        if (n == null) {
            return this.getCompressionType();
        }
        return Compression.Algorithm.valueOf(n.toUpperCase(Locale.ROOT));
    }

    public HColumnDescriptor setCompactionCompressionType(Compression.Algorithm type) {
        return this.setValue(COMPRESSION_COMPACT, type.getName().toUpperCase(Locale.ROOT));
    }

    public boolean isInMemory() {
        String value = this.getValue("IN_MEMORY");
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public HColumnDescriptor setInMemory(boolean inMemory) {
        return this.setValue("IN_MEMORY", Boolean.toString(inMemory));
    }

    public MemoryCompactionPolicy getInMemoryCompaction() {
        String value = this.getValue(IN_MEMORY_COMPACTION);
        if (value != null) {
            return MemoryCompactionPolicy.valueOf(value);
        }
        return null;
    }

    public HColumnDescriptor setInMemoryCompaction(MemoryCompactionPolicy inMemoryCompaction) {
        return this.setValue(IN_MEMORY_COMPACTION, inMemoryCompaction.toString());
    }

    public KeepDeletedCells getKeepDeletedCells() {
        String value = this.getValue(KEEP_DELETED_CELLS);
        if (value != null) {
            return KeepDeletedCells.valueOf(value.toUpperCase(Locale.ROOT));
        }
        return DEFAULT_KEEP_DELETED;
    }

    public HColumnDescriptor setKeepDeletedCells(KeepDeletedCells keepDeletedCells) {
        return this.setValue(KEEP_DELETED_CELLS, keepDeletedCells.toString());
    }

    public int getTimeToLive() {
        String value = this.getValue(TTL);
        return value != null ? Integer.parseInt(value) : Integer.MAX_VALUE;
    }

    public HColumnDescriptor setTimeToLive(int timeToLive) {
        return this.setValue(TTL, Integer.toString(timeToLive));
    }

    public HColumnDescriptor setTimeToLive(String timeToLive) throws HBaseException {
        return this.setValue(TTL, PrettyPrinter.valueOf(timeToLive, PrettyPrinter.Unit.TIME_INTERVAL));
    }

    public int getMinVersions() {
        String value = this.getValue(MIN_VERSIONS);
        return value != null ? Integer.parseInt(value) : 0;
    }

    public HColumnDescriptor setMinVersions(int minVersions) {
        return this.setValue(MIN_VERSIONS, Integer.toString(minVersions));
    }

    public boolean isBlockCacheEnabled() {
        String value = this.getValue(BLOCKCACHE);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return true;
    }

    public HColumnDescriptor setBlockCacheEnabled(boolean blockCacheEnabled) {
        return this.setValue(BLOCKCACHE, Boolean.toString(blockCacheEnabled));
    }

    public BloomType getBloomFilterType() {
        String n = this.getValue(BLOOMFILTER);
        if (n == null) {
            n = DEFAULT_BLOOMFILTER;
        }
        return BloomType.valueOf(n.toUpperCase(Locale.ROOT));
    }

    public HColumnDescriptor setBloomFilterType(BloomType bt) {
        return this.setValue(BLOOMFILTER, bt.toString());
    }

    public int getScope() {
        byte[] value = this.getValue(REPLICATION_SCOPE_BYTES);
        if (value != null) {
            return Integer.parseInt(Bytes.toString(value));
        }
        return 0;
    }

    public HColumnDescriptor setScope(int scope) {
        return this.setValue(REPLICATION_SCOPE, Integer.toString(scope));
    }

    public boolean isCacheDataOnWrite() {
        return this.setAndGetBoolean(CACHE_DATA_ON_WRITE, false);
    }

    public HColumnDescriptor setCacheDataOnWrite(boolean value) {
        return this.setValue(CACHE_DATA_ON_WRITE, Boolean.toString(value));
    }

    public boolean isCacheDataInL1() {
        return this.setAndGetBoolean(CACHE_DATA_IN_L1, false);
    }

    public HColumnDescriptor setCacheDataInL1(boolean value) {
        return this.setValue(CACHE_DATA_IN_L1, Boolean.toString(value));
    }

    private boolean setAndGetBoolean(String key, boolean defaultSetting) {
        String value = this.getValue(key);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultSetting;
    }

    public boolean isCacheIndexesOnWrite() {
        return this.setAndGetBoolean(CACHE_INDEX_ON_WRITE, false);
    }

    public HColumnDescriptor setCacheIndexesOnWrite(boolean value) {
        return this.setValue(CACHE_INDEX_ON_WRITE, Boolean.toString(value));
    }

    public boolean isCacheBloomsOnWrite() {
        return this.setAndGetBoolean(CACHE_BLOOMS_ON_WRITE, false);
    }

    public HColumnDescriptor setCacheBloomsOnWrite(boolean value) {
        return this.setValue(CACHE_BLOOMS_ON_WRITE, Boolean.toString(value));
    }

    public boolean isEvictBlocksOnClose() {
        return this.setAndGetBoolean(EVICT_BLOCKS_ON_CLOSE, false);
    }

    public HColumnDescriptor setEvictBlocksOnClose(boolean value) {
        return this.setValue(EVICT_BLOCKS_ON_CLOSE, Boolean.toString(value));
    }

    public boolean isPrefetchBlocksOnOpen() {
        return this.setAndGetBoolean(PREFETCH_BLOCKS_ON_OPEN, false);
    }

    public HColumnDescriptor setPrefetchBlocksOnOpen(boolean value) {
        return this.setValue(PREFETCH_BLOCKS_ON_OPEN, Boolean.toString(value));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(Bytes.toString(this.name));
        s.append("'");
        s.append((CharSequence)this.getValues(true));
        s.append('}');
        return s.toString();
    }

    public String toStringCustomizedValues() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(Bytes.toString(this.name));
        s.append("'");
        s.append((CharSequence)this.getValues(false));
        s.append('}');
        return s.toString();
    }

    private StringBuilder getValues(boolean printDefaults) {
        StringBuilder s = new StringBuilder();
        boolean hasConfigKeys = false;
        for (Map.Entry<Bytes, Bytes> entry : this.values.entrySet()) {
            if (!RESERVED_KEYWORDS.contains(entry.getKey())) {
                hasConfigKeys = true;
                continue;
            }
            String string = Bytes.toString(entry.getKey().get());
            String value = Bytes.toStringBinary(entry.getValue().get());
            if (!printDefaults && DEFAULT_VALUES.containsKey(string) && DEFAULT_VALUES.get(string).equalsIgnoreCase(value)) continue;
            s.append(", ");
            s.append(string);
            s.append(" => ");
            s.append('\'').append(PrettyPrinter.format(value, HColumnDescriptor.getUnit(string))).append('\'');
        }
        if (hasConfigKeys) {
            s.append(", ");
            s.append("METADATA").append(" => ");
            s.append('{');
            boolean printComma = false;
            for (Bytes bytes : this.values.keySet()) {
                if (RESERVED_KEYWORDS.contains(bytes)) continue;
                String key = Bytes.toString(bytes.get());
                String value = Bytes.toStringBinary(this.values.get(bytes).get());
                if (printComma) {
                    s.append(", ");
                }
                printComma = true;
                s.append('\'').append(key).append('\'');
                s.append(" => ");
                s.append('\'').append(PrettyPrinter.format(value, HColumnDescriptor.getUnit(key))).append('\'');
            }
            s.append('}');
        }
        if (!this.configuration.isEmpty()) {
            s.append(", ");
            s.append("CONFIGURATION").append(" => ");
            s.append('{');
            boolean printCommaForConfiguration = false;
            for (Map.Entry entry : this.configuration.entrySet()) {
                if (printCommaForConfiguration) {
                    s.append(", ");
                }
                printCommaForConfiguration = true;
                s.append('\'').append((String)entry.getKey()).append('\'');
                s.append(" => ");
                s.append('\'').append(PrettyPrinter.format((String)entry.getValue(), HColumnDescriptor.getUnit((String)entry.getKey()))).append('\'');
            }
            s.append("}");
        }
        return s;
    }

    public static PrettyPrinter.Unit getUnit(String key) {
        PrettyPrinter.Unit unit = key.equals(TTL) ? PrettyPrinter.Unit.TIME_INTERVAL : (key.equals(MOB_THRESHOLD) ? PrettyPrinter.Unit.LONG : (key.equals(IS_MOB) ? PrettyPrinter.Unit.BOOLEAN : PrettyPrinter.Unit.NONE));
        return unit;
    }

    public static Map<String, String> getDefaultValues() {
        return Collections.unmodifiableMap(DEFAULT_VALUES);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HColumnDescriptor)) {
            return false;
        }
        return this.compareTo((HColumnDescriptor)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.name);
        result ^= 0xB;
        result ^= this.values.hashCode();
        return result ^= this.configuration.hashCode();
    }

    @Override
    public int compareTo(HColumnDescriptor o) {
        int result = Bytes.compareTo(this.name, o.getName());
        if (result == 0) {
            result = this.values.hashCode() - o.values.hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        if (result == 0) {
            result = this.configuration.hashCode() - o.configuration.hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        return result;
    }

    public byte[] toByteArray() {
        return ProtobufUtil.prependPBMagic(ProtobufUtil.convertToColumnFamilySchema(this).toByteArray());
    }

    public static HColumnDescriptor parseFrom(byte[] bytes) throws DeserializationException {
        if (!ProtobufUtil.isPBMagicPrefix(bytes)) {
            throw new DeserializationException("No magic");
        }
        int pblen = ProtobufUtil.lengthOfPBMagic();
        HBaseProtos.ColumnFamilySchema.Builder builder = HBaseProtos.ColumnFamilySchema.newBuilder();
        HBaseProtos.ColumnFamilySchema cfs = null;
        try {
            ProtobufUtil.mergeFrom(builder, bytes, pblen, bytes.length - pblen);
            cfs = builder.build();
        }
        catch (IOException e) {
            throw new DeserializationException(e);
        }
        return ProtobufUtil.convertToHColumnDesc(cfs);
    }

    public String getConfigurationValue(String key) {
        return this.configuration.get(key);
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public HColumnDescriptor setConfiguration(String key, String value) {
        if (value == null) {
            this.removeConfiguration(key);
        } else {
            this.configuration.put(key, value);
        }
        return this;
    }

    public void removeConfiguration(String key) {
        this.configuration.remove(key);
    }

    public String getEncryptionType() {
        return this.getValue(ENCRYPTION);
    }

    public HColumnDescriptor setEncryptionType(String algorithm) {
        this.setValue(ENCRYPTION, algorithm);
        return this;
    }

    public byte[] getEncryptionKey() {
        return this.getValue(Bytes.toBytes(ENCRYPTION_KEY));
    }

    public HColumnDescriptor setEncryptionKey(byte[] keyBytes) {
        this.setValue(Bytes.toBytes(ENCRYPTION_KEY), keyBytes);
        return this;
    }

    public long getMobThreshold() {
        byte[] threshold = this.getValue(MOB_THRESHOLD_BYTES);
        return threshold != null && threshold.length == 8 ? Bytes.toLong(threshold) : 102400L;
    }

    public HColumnDescriptor setMobThreshold(long threshold) {
        this.setValue(MOB_THRESHOLD_BYTES, Bytes.toBytes(threshold));
        return this;
    }

    public boolean isMobEnabled() {
        byte[] isMobEnabled = this.getValue(IS_MOB_BYTES);
        return isMobEnabled != null && isMobEnabled.length == 1 && Bytes.toBoolean(isMobEnabled);
    }

    public HColumnDescriptor setMobEnabled(boolean isMobEnabled) {
        this.setValue(IS_MOB_BYTES, Bytes.toBytes(isMobEnabled));
        return this;
    }

    public MobCompactPartitionPolicy getMobCompactPartitionPolicy() {
        String policy = this.getValue(MOB_COMPACT_PARTITION_POLICY);
        if (policy == null) {
            return DEFAULT_MOB_COMPACT_PARTITION_POLICY;
        }
        return MobCompactPartitionPolicy.valueOf(policy.toUpperCase(Locale.ROOT));
    }

    public HColumnDescriptor setMobCompactPartitionPolicy(MobCompactPartitionPolicy policy) {
        return this.setValue(MOB_COMPACT_PARTITION_POLICY, policy.toString().toUpperCase(Locale.ROOT));
    }

    public short getDFSReplication() {
        String rf = this.getValue(DFS_REPLICATION);
        return rf == null ? (short)0 : Short.valueOf(rf);
    }

    public HColumnDescriptor setDFSReplication(short replication) {
        if (replication < 1 && replication != 0) {
            throw new IllegalArgumentException("DFS replication factor cannot be less than 1 if explicitly set.");
        }
        this.setValue(DFS_REPLICATION, Short.toString(replication));
        return this;
    }

    public String getStoragePolicy() {
        return this.getValue(STORAGE_POLICY);
    }

    public HColumnDescriptor setStoragePolicy(String policy) {
        this.setValue(STORAGE_POLICY, policy);
        return this;
    }

    static {
        DEFAULT_VALUES.put(BLOOMFILTER, DEFAULT_BLOOMFILTER);
        DEFAULT_VALUES.put(REPLICATION_SCOPE, String.valueOf(0));
        DEFAULT_VALUES.put("VERSIONS", String.valueOf(DEFAULT_VERSIONS));
        DEFAULT_VALUES.put(MIN_VERSIONS, String.valueOf(0));
        DEFAULT_VALUES.put(COMPRESSION, DEFAULT_COMPRESSION);
        DEFAULT_VALUES.put(TTL, String.valueOf(Integer.MAX_VALUE));
        DEFAULT_VALUES.put(BLOCKSIZE, String.valueOf(65536));
        DEFAULT_VALUES.put("IN_MEMORY", String.valueOf(false));
        DEFAULT_VALUES.put(BLOCKCACHE, String.valueOf(true));
        DEFAULT_VALUES.put(KEEP_DELETED_CELLS, String.valueOf((Object)DEFAULT_KEEP_DELETED));
        DEFAULT_VALUES.put(DATA_BLOCK_ENCODING, String.valueOf(DEFAULT_DATA_BLOCK_ENCODING));
        DEFAULT_VALUES.put(CACHE_DATA_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(CACHE_DATA_IN_L1, String.valueOf(false));
        DEFAULT_VALUES.put(CACHE_INDEX_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(CACHE_BLOOMS_ON_WRITE, String.valueOf(false));
        DEFAULT_VALUES.put(EVICT_BLOCKS_ON_CLOSE, String.valueOf(false));
        DEFAULT_VALUES.put(PREFETCH_BLOCKS_ON_OPEN, String.valueOf(false));
        for (String s : DEFAULT_VALUES.keySet()) {
            RESERVED_KEYWORDS.add(new Bytes(Bytes.toBytes(s)));
        }
        RESERVED_KEYWORDS.add(new Bytes(Bytes.toBytes(ENCRYPTION)));
        RESERVED_KEYWORDS.add(new Bytes(Bytes.toBytes(ENCRYPTION_KEY)));
        RESERVED_KEYWORDS.add(new Bytes(IS_MOB_BYTES));
        RESERVED_KEYWORDS.add(new Bytes(MOB_THRESHOLD_BYTES));
        RESERVED_KEYWORDS.add(new Bytes(MOB_COMPACT_PARTITION_POLICY_BYTES));
    }
}

