/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.counters;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.AbstractIterator;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Iterators;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.counters.AbstractCounter;
import org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.hadoop.mapreduce.util.ResourceBundles;

@InterfaceAudience.Private
public abstract class FrameworkCounterGroup<T extends Enum<T>, C extends Counter>
implements CounterGroupBase<C> {
    private static final Log LOG = LogFactory.getLog(FrameworkCounterGroup.class);
    private final Class<T> enumClass;
    private final Object[] counters;
    private String displayName = null;

    public FrameworkCounterGroup(Class<T> enumClass) {
        this.enumClass = enumClass;
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        this.counters = new Object[enums.length];
    }

    @Override
    public String getName() {
        return this.enumClass.getName();
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = ResourceBundles.getCounterGroupName(this.getName(), this.getName());
        }
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private T valueOf(String name) {
        return Enum.valueOf(this.enumClass, name);
    }

    @Override
    public void addCounter(C counter) {
        C ours = this.findCounter((T)counter.getName());
        if (ours != null) {
            ours.setValue(counter.getValue());
        } else {
            LOG.warn((Object)(counter.getName() + "is not a known counter."));
        }
    }

    @Override
    public C addCounter(String name, String displayName, long value) {
        C counter = this.findCounter((T)name);
        if (counter != null) {
            counter.setValue(value);
        } else {
            LOG.warn((Object)(name + "is not a known counter."));
        }
        return counter;
    }

    @Override
    public C findCounter(String counterName, String displayName) {
        return this.findCounter((T)counterName);
    }

    @Override
    public C findCounter(String counterName, boolean create) {
        try {
            return this.findCounter(this.valueOf(counterName));
        }
        catch (Exception e) {
            if (create) {
                throw new IllegalArgumentException(e);
            }
            return null;
        }
    }

    @Override
    public C findCounter(String counterName) {
        try {
            T enumValue = this.valueOf(counterName);
            return this.findCounter(enumValue);
        }
        catch (IllegalArgumentException e) {
            LOG.warn((Object)(counterName + " is not a recognized counter."));
            return null;
        }
    }

    private C findCounter(T key) {
        int i = ((Enum)key).ordinal();
        if (this.counters[i] == null) {
            this.counters[i] = this.newCounter(key);
        }
        return (C)((Counter)this.counters[i]);
    }

    protected abstract C newCounter(T var1);

    @Override
    public int size() {
        int n = 0;
        for (int i = 0; i < this.counters.length; ++i) {
            if (this.counters[i] == null) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void incrAllCounters(CounterGroupBase<C> other) {
        if (Preconditions.checkNotNull(other, "other counter group") instanceof FrameworkCounterGroup) {
            for (Counter counter : other) {
                C c = this.findCounter((T)((Enum)((FrameworkCounter)counter).key).name());
                if (c == null) continue;
                c.increment(counter.getValue());
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.size());
        for (int i = 0; i < this.counters.length; ++i) {
            Counter counter = (Counter)this.counters[i];
            if (counter == null) continue;
            WritableUtils.writeVInt(out, i);
            WritableUtils.writeVLong(out, counter.getValue());
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.clear();
        int len = WritableUtils.readVInt(in);
        Enum[] enums = (Enum[])this.enumClass.getEnumConstants();
        for (int i = 0; i < len; ++i) {
            int ord = WritableUtils.readVInt(in);
            C counter = this.newCounter(enums[ord]);
            counter.setValue(WritableUtils.readVLong(in));
            this.counters[ord] = counter;
        }
    }

    private void clear() {
        for (int i = 0; i < this.counters.length; ++i) {
            this.counters[i] = null;
        }
    }

    @Override
    public Iterator<C> iterator() {
        return new AbstractIterator<C>(){
            int i = 0;

            @Override
            protected C computeNext() {
                while (this.i < FrameworkCounterGroup.this.counters.length) {
                    Counter counter = (Counter)FrameworkCounterGroup.this.counters[this.i++];
                    if (counter == null) continue;
                    return counter;
                }
                return (Counter)this.endOfData();
            }
        };
    }

    public boolean equals(Object genericRight) {
        if (genericRight instanceof CounterGroupBase) {
            CounterGroupBase right = (CounterGroupBase)genericRight;
            return Iterators.elementsEqual(this.iterator(), right.iterator());
        }
        return false;
    }

    public synchronized int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.enumClass, this.counters, this.displayName});
    }

    @InterfaceAudience.Private
    public static class FrameworkCounter<T extends Enum<T>>
    extends AbstractCounter {
        final T key;
        final String groupName;
        private long value;

        public FrameworkCounter(T ref, String groupName) {
            this.key = ref;
            this.groupName = groupName;
        }

        @InterfaceAudience.Private
        public T getKey() {
            return this.key;
        }

        @InterfaceAudience.Private
        public String getGroupName() {
            return this.groupName;
        }

        @Override
        public String getName() {
            return ((Enum)this.key).name();
        }

        @Override
        public String getDisplayName() {
            return ResourceBundles.getCounterName(this.groupName, this.getName(), this.getName());
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public void setValue(long value) {
            this.value = value;
        }

        @Override
        public void increment(long incr) {
            this.value += incr;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            assert (false) : "shouldn't be called";
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            assert (false) : "shouldn't be called";
        }

        @Override
        public Counter getUnderlyingCounter() {
            return this;
        }
    }
}

