/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class UnsafeAvailChecker {
    private static final String CLASS_NAME = "sun.misc.Unsafe";
    private static final Log LOG = LogFactory.getLog(UnsafeAvailChecker.class);
    private static boolean avail = false;
    private static boolean unaligned = false;

    public static boolean isAvailable() {
        return avail;
    }

    public static boolean unaligned() {
        return unaligned;
    }

    private UnsafeAvailChecker() {
    }

    static {
        avail = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                Class<?> clazz = Class.forName(UnsafeAvailChecker.CLASS_NAME);
                Field f = clazz.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                Object theUnsafe = f.get(null);
                if (theUnsafe == null) {
                    LOG.warn((Object)"Could not get static instance from sun.misc.Unsafe");
                    return false;
                }
                try {
                    Method m = clazz.getDeclaredMethod("arrayBaseOffset", Class.class);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing arrayBaseOffset(Class)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing copyMemory(Object,long,Object,long,long)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("getByte", Object.class, Long.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing getByte(Object,long)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("getShort", Long.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing getShort(long)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("getShort", Object.class, Long.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing getShort(Object,long)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("getInt", Long.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing getInt(long)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("getInt", Object.class, Long.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing getInt(Object,long)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("getLong", Long.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing getLong(long)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("getLong", Object.class, Long.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing getLong(Object,long)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("putByte", Long.TYPE, Byte.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing putByte(long,byte)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing putByte(Object,long,byte)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("putShort", Long.TYPE, Short.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing putShort(long,short)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("putShort", Object.class, Long.TYPE, Short.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing putShort(Object,long,short)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("putInt", Long.TYPE, Integer.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing putInt(long,int)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing putInt(Object,long,int)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("putLong", Long.TYPE, Long.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing putLong(long,long)");
                        return false;
                    }
                    m = clazz.getDeclaredMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
                    if (m == null) {
                        LOG.warn((Object)"sun.misc.Unsafe is missing putLong(Object,long,long)");
                        return false;
                    }
                    return true;
                }
                catch (Throwable e) {
                    try {
                        LOG.warn((Object)"sun.misc.Unsafe is missing one or more required methods", e);
                    }
                    catch (Throwable e2) {
                        LOG.warn((Object)"sun.misc.Unsafe is not available/accessible", e2);
                    }
                }
                return false;
            }
        });
        if (avail) {
            String arch = System.getProperty("os.arch");
            if ("ppc64".equals(arch) || "ppc64le".equals(arch)) {
                unaligned = true;
            } else {
                try {
                    Class<?> clazz = Class.forName("java.nio.Bits");
                    Method m = clazz.getDeclaredMethod("unaligned", new Class[0]);
                    m.setAccessible(true);
                    unaligned = (Boolean)m.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    LOG.warn((Object)"java.nio.Bits#unaligned() check failed.Unsafe based read/write of primitive types won't be used", (Throwable)e);
                }
            }
        }
    }
}

