/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static boolean isInterrupt(Throwable t) {
        if (t instanceof InterruptedException) {
            return true;
        }
        if (t instanceof SocketTimeoutException) {
            return false;
        }
        return t instanceof InterruptedIOException || t instanceof ClosedByInterruptException;
    }

    public static void rethrowIfInterrupt(Throwable t) throws InterruptedIOException {
        InterruptedIOException iie = ExceptionUtil.asInterrupt(t);
        if (iie != null) {
            throw iie;
        }
    }

    public static InterruptedIOException asInterrupt(Throwable t) {
        if (t instanceof SocketTimeoutException) {
            return null;
        }
        if (t instanceof InterruptedIOException) {
            return (InterruptedIOException)t;
        }
        if (t instanceof InterruptedException || t instanceof ClosedByInterruptException) {
            InterruptedIOException iie = new InterruptedIOException("Origin: " + t.getClass().getSimpleName());
            iie.initCause(t);
            return iie;
        }
        return null;
    }
}

