/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Descriptors;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.RpcCallback;
import org.apache.hadoop.hbase.shaded.io.netty.util.Timeout;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.htrace.Span;
import org.apache.htrace.Trace;

@InterfaceAudience.Private
class Call {
    final int id;
    final Message param;
    CellScanner cells;
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Direct access is only allowed after done")
    Message response;
    Message responseDefaultType;
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Direct access is only allowed after done")
    IOException error;
    private boolean done;
    final Descriptors.MethodDescriptor md;
    final int timeout;
    final int priority;
    final MetricsConnection.CallStats callStats;
    final RpcCallback<Call> callback;
    final Span span;
    Timeout timeoutTask;

    protected Call(int id, Descriptors.MethodDescriptor md, Message param, CellScanner cells, Message responseDefaultType, int timeout, int priority, RpcCallback<Call> callback, MetricsConnection.CallStats callStats) {
        this.param = param;
        this.md = md;
        this.cells = cells;
        this.callStats = callStats;
        this.callStats.setStartTime(EnvironmentEdgeManager.currentTime());
        this.responseDefaultType = responseDefaultType;
        this.id = id;
        this.timeout = timeout;
        this.priority = priority;
        this.callback = callback;
        this.span = Trace.currentSpan();
    }

    public String toString() {
        return "callId: " + this.id + " methodName: " + this.md.getName() + " param {" + (this.param != null ? ProtobufUtil.getShortTextFormat(this.param) : "") + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(IOException error) {
        Call call = this;
        synchronized (call) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.error = error;
        }
        this.callback.run(this);
    }

    private void callComplete() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.callback.run(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setException(IOException error) {
        Call call = this;
        synchronized (call) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.error = error;
        }
        this.callComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Message response, CellScanner cells) {
        Call call = this;
        synchronized (call) {
            if (this.done) {
                return;
            }
            this.done = true;
            this.response = response;
            this.cells = cells;
        }
        this.callComplete();
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public long getStartTime() {
        return this.callStats.getStartTime();
    }
}

