/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultCache;

@InterfaceAudience.Private
class AllowPartialScanResultCache
extends ScanResultCache {
    private Cell lastCell;
    private boolean lastResultPartial;

    public AllowPartialScanResultCache(List<Result> cache) {
        super(cache);
    }

    private void recordLastResult(Result result) {
        this.lastCell = result.rawCells()[result.rawCells().length - 1];
        this.lastResultPartial = result.mayHaveMoreCellsInRow();
    }

    @Override
    public void loadResultsToCache(Result[] results, boolean isHeartbeatMessage) throws IOException {
        int i;
        if (results.length == 0) {
            if (!isHeartbeatMessage && this.lastResultPartial) {
                ++this.numberOfCompleteRows;
            }
            return;
        }
        for (i = 0; i < results.length; ++i) {
            Result r = ConnectionUtils.filterCells(results[i], this.lastCell);
            if (r == null) continue;
            results[i] = r;
            break;
        }
        if (i == results.length) {
            return;
        }
        if (this.lastResultPartial && !CellUtil.matchingRow(this.lastCell, results[0].getRow())) {
            ++this.numberOfCompleteRows;
        }
        this.recordLastResult(results[results.length - 1]);
        this.addResultArrayToCache(results, i, results.length);
    }

    @Override
    protected void checkUpdateNumberOfCompleteRowsAndCache(Result rs) {
        if (!rs.mayHaveMoreCellsInRow()) {
            ++this.numberOfCompleteRows;
        }
        this.addResultToCache(rs);
    }

    @Override
    public void clear() {
        super.clear();
    }
}

