/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.impl.pb.LocalResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContainerLaunchContextPBImpl
extends ContainerLaunchContext {
    YarnProtos.ContainerLaunchContextProto proto = YarnProtos.ContainerLaunchContextProto.getDefaultInstance();
    YarnProtos.ContainerLaunchContextProto.Builder builder = null;
    boolean viaProto = false;
    private Map<String, LocalResource> localResources = null;
    private ByteBuffer tokens = null;
    private Map<String, ByteBuffer> serviceData = null;
    private Map<String, String> environment = null;
    private List<String> commands = null;
    private Map<ApplicationAccessType, String> applicationACLS = null;

    public ContainerLaunchContextPBImpl() {
        this.builder = YarnProtos.ContainerLaunchContextProto.newBuilder();
    }

    public ContainerLaunchContextPBImpl(YarnProtos.ContainerLaunchContextProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ContainerLaunchContextProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ContainerLaunchContextPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    protected final ByteBuffer convertFromProtoFormat(ByteString byteString) {
        return ProtoUtils.convertFromProtoFormat(byteString);
    }

    protected final ByteString convertToProtoFormat(ByteBuffer byteBuffer) {
        return ProtoUtils.convertToProtoFormat(byteBuffer);
    }

    private void mergeLocalToBuilder() {
        if (this.localResources != null) {
            this.addLocalResourcesToProto();
        }
        if (this.tokens != null) {
            this.builder.setTokens(this.convertToProtoFormat(this.tokens));
        }
        if (this.serviceData != null) {
            this.addServiceDataToProto();
        }
        if (this.environment != null) {
            this.addEnvToProto();
        }
        if (this.commands != null) {
            this.addCommandsToProto();
        }
        if (this.applicationACLS != null) {
            this.addApplicationACLs();
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ContainerLaunchContextProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public List<String> getCommands() {
        this.initCommands();
        return this.commands;
    }

    private void initCommands() {
        if (this.commands != null) {
            return;
        }
        YarnProtos.ContainerLaunchContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<String> list = p.getCommandList();
        this.commands = new ArrayList<String>();
        for (String c : list) {
            this.commands.add(c);
        }
    }

    @Override
    public void setCommands(List<String> commands) {
        if (commands == null) {
            return;
        }
        this.initCommands();
        this.commands.clear();
        this.commands.addAll(commands);
    }

    private void addCommandsToProto() {
        this.maybeInitBuilder();
        this.builder.clearCommand();
        if (this.commands == null) {
            return;
        }
        this.builder.addAllCommand(this.commands);
    }

    @Override
    public Map<String, LocalResource> getLocalResources() {
        this.initLocalResources();
        return this.localResources;
    }

    private void initLocalResources() {
        if (this.localResources != null) {
            return;
        }
        YarnProtos.ContainerLaunchContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.StringLocalResourceMapProto> list = p.getLocalResourcesList();
        this.localResources = new HashMap<String, LocalResource>();
        for (YarnProtos.StringLocalResourceMapProto c : list) {
            this.localResources.put(c.getKey(), this.convertFromProtoFormat(c.getValue()));
        }
    }

    @Override
    public void setLocalResources(Map<String, LocalResource> localResources) {
        if (localResources == null) {
            return;
        }
        this.checkLocalResources(localResources);
        this.initLocalResources();
        this.localResources.clear();
        this.localResources.putAll(localResources);
    }

    private void checkLocalResources(Map<String, LocalResource> localResources) {
        for (Map.Entry<String, LocalResource> rsrcEntry : localResources.entrySet()) {
            if (rsrcEntry.getValue() == null || rsrcEntry.getValue().getResource() == null) {
                throw new NullPointerException("Null resource URL for local resource " + rsrcEntry.getKey() + " : " + rsrcEntry.getValue());
            }
            if (rsrcEntry.getValue().getType() == null) {
                throw new NullPointerException("Null resource type for local resource " + rsrcEntry.getKey() + " : " + rsrcEntry.getValue());
            }
            if (rsrcEntry.getValue().getVisibility() != null) continue;
            throw new NullPointerException("Null resource visibility for local resource " + rsrcEntry.getKey() + " : " + rsrcEntry.getValue());
        }
    }

    private void addLocalResourcesToProto() {
        this.maybeInitBuilder();
        this.builder.clearLocalResources();
        if (this.localResources == null) {
            return;
        }
        Iterable<YarnProtos.StringLocalResourceMapProto> iterable = new Iterable<YarnProtos.StringLocalResourceMapProto>(){

            @Override
            public Iterator<YarnProtos.StringLocalResourceMapProto> iterator() {
                return new Iterator<YarnProtos.StringLocalResourceMapProto>(){
                    Iterator<String> keyIter;
                    {
                        this.keyIter = ContainerLaunchContextPBImpl.this.localResources.keySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public YarnProtos.StringLocalResourceMapProto next() {
                        String key = this.keyIter.next();
                        return YarnProtos.StringLocalResourceMapProto.newBuilder().setKey(key).setValue(ContainerLaunchContextPBImpl.this.convertToProtoFormat((LocalResource)ContainerLaunchContextPBImpl.this.localResources.get(key))).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllLocalResources((Iterable<? extends YarnProtos.StringLocalResourceMapProto>)iterable);
    }

    @Override
    public ByteBuffer getTokens() {
        YarnProtos.ContainerLaunchContextProtoOrBuilder p;
        YarnProtos.ContainerLaunchContextProtoOrBuilder containerLaunchContextProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.tokens != null) {
            return this.tokens;
        }
        if (!p.hasTokens()) {
            return null;
        }
        this.tokens = this.convertFromProtoFormat(p.getTokens());
        return this.tokens;
    }

    @Override
    public void setTokens(ByteBuffer tokens) {
        this.maybeInitBuilder();
        if (tokens == null) {
            this.builder.clearTokens();
        }
        this.tokens = tokens;
    }

    @Override
    public Map<String, ByteBuffer> getServiceData() {
        this.initServiceData();
        return this.serviceData;
    }

    private void initServiceData() {
        if (this.serviceData != null) {
            return;
        }
        YarnProtos.ContainerLaunchContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.StringBytesMapProto> list = p.getServiceDataList();
        this.serviceData = new HashMap<String, ByteBuffer>();
        for (YarnProtos.StringBytesMapProto c : list) {
            this.serviceData.put(c.getKey(), this.convertFromProtoFormat(c.getValue()));
        }
    }

    @Override
    public void setServiceData(Map<String, ByteBuffer> serviceData) {
        if (serviceData == null) {
            return;
        }
        this.initServiceData();
        this.serviceData.putAll(serviceData);
    }

    private void addServiceDataToProto() {
        this.maybeInitBuilder();
        this.builder.clearServiceData();
        if (this.serviceData == null) {
            return;
        }
        Iterable<YarnProtos.StringBytesMapProto> iterable = new Iterable<YarnProtos.StringBytesMapProto>(){

            @Override
            public Iterator<YarnProtos.StringBytesMapProto> iterator() {
                return new Iterator<YarnProtos.StringBytesMapProto>(){
                    Iterator<String> keyIter;
                    {
                        this.keyIter = ContainerLaunchContextPBImpl.this.serviceData.keySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public YarnProtos.StringBytesMapProto next() {
                        String key = this.keyIter.next();
                        return YarnProtos.StringBytesMapProto.newBuilder().setKey(key).setValue(ContainerLaunchContextPBImpl.this.convertToProtoFormat((ByteBuffer)ContainerLaunchContextPBImpl.this.serviceData.get(key))).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllServiceData((Iterable<? extends YarnProtos.StringBytesMapProto>)iterable);
    }

    @Override
    public Map<String, String> getEnvironment() {
        this.initEnv();
        return this.environment;
    }

    private void initEnv() {
        if (this.environment != null) {
            return;
        }
        YarnProtos.ContainerLaunchContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.StringStringMapProto> list = p.getEnvironmentList();
        this.environment = new HashMap<String, String>();
        for (YarnProtos.StringStringMapProto c : list) {
            this.environment.put(c.getKey(), c.getValue());
        }
    }

    @Override
    public void setEnvironment(Map<String, String> env) {
        if (env == null) {
            return;
        }
        this.initEnv();
        this.environment.clear();
        this.environment.putAll(env);
    }

    private void addEnvToProto() {
        this.maybeInitBuilder();
        this.builder.clearEnvironment();
        if (this.environment == null) {
            return;
        }
        Iterable<YarnProtos.StringStringMapProto> iterable = new Iterable<YarnProtos.StringStringMapProto>(){

            @Override
            public Iterator<YarnProtos.StringStringMapProto> iterator() {
                return new Iterator<YarnProtos.StringStringMapProto>(){
                    Iterator<String> keyIter;
                    {
                        this.keyIter = ContainerLaunchContextPBImpl.this.environment.keySet().iterator();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public YarnProtos.StringStringMapProto next() {
                        String key = this.keyIter.next();
                        return YarnProtos.StringStringMapProto.newBuilder().setKey(key).setValue((String)ContainerLaunchContextPBImpl.this.environment.get(key)).build();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.keyIter.hasNext();
                    }
                };
            }
        };
        this.builder.addAllEnvironment((Iterable<? extends YarnProtos.StringStringMapProto>)iterable);
    }

    @Override
    public Map<ApplicationAccessType, String> getApplicationACLs() {
        this.initApplicationACLs();
        return this.applicationACLS;
    }

    private void initApplicationACLs() {
        if (this.applicationACLS != null) {
            return;
        }
        YarnProtos.ContainerLaunchContextProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ApplicationACLMapProto> list = p.getApplicationACLsList();
        this.applicationACLS = new HashMap<ApplicationAccessType, String>(list.size());
        for (YarnProtos.ApplicationACLMapProto aclProto : list) {
            this.applicationACLS.put(ProtoUtils.convertFromProtoFormat(aclProto.getAccessType()), aclProto.getAcl());
        }
    }

    private void addApplicationACLs() {
        this.maybeInitBuilder();
        this.builder.clearApplicationACLs();
        if (this.applicationACLS == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationACLMapProto> values = new Iterable<YarnProtos.ApplicationACLMapProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationACLMapProto> iterator() {
                return new Iterator<YarnProtos.ApplicationACLMapProto>(){
                    Iterator<ApplicationAccessType> aclsIterator;
                    {
                        this.aclsIterator = ContainerLaunchContextPBImpl.this.applicationACLS.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.aclsIterator.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationACLMapProto next() {
                        ApplicationAccessType key = this.aclsIterator.next();
                        return YarnProtos.ApplicationACLMapProto.newBuilder().setAcl((String)ContainerLaunchContextPBImpl.this.applicationACLS.get((Object)key)).setAccessType(ProtoUtils.convertToProtoFormat(key)).build();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplicationACLs((Iterable<? extends YarnProtos.ApplicationACLMapProto>)values);
    }

    @Override
    public void setApplicationACLs(Map<ApplicationAccessType, String> appACLs) {
        if (appACLs == null) {
            return;
        }
        this.initApplicationACLs();
        this.applicationACLS.clear();
        this.applicationACLS.putAll(appACLs);
    }

    private LocalResourcePBImpl convertFromProtoFormat(YarnProtos.LocalResourceProto p) {
        return new LocalResourcePBImpl(p);
    }

    private YarnProtos.LocalResourceProto convertToProtoFormat(LocalResource t) {
        return ((LocalResourcePBImpl)t).getProto();
    }
}

