/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.io.retry.AtMostOnce;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.Idempotent;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtocolTranslator;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RpcInvocationHandler;

@InterfaceAudience.Private
public class RetryInvocationHandler<T>
implements RpcInvocationHandler {
    public static final Log LOG = LogFactory.getLog(RetryInvocationHandler.class);
    private final FailoverProxyProvider<T> proxyProvider;
    private long proxyProviderFailoverCount = 0L;
    private volatile boolean hasMadeASuccessfulCall = false;
    private final RetryPolicy defaultPolicy;
    private final Map<String, RetryPolicy> methodNameToPolicyMap;
    private FailoverProxyProvider.ProxyInfo<T> currentProxy;

    protected RetryInvocationHandler(FailoverProxyProvider<T> proxyProvider, RetryPolicy retryPolicy) {
        this(proxyProvider, retryPolicy, Collections.emptyMap());
    }

    protected RetryInvocationHandler(FailoverProxyProvider<T> proxyProvider, RetryPolicy defaultPolicy, Map<String, RetryPolicy> methodNameToPolicyMap) {
        this.proxyProvider = proxyProvider;
        this.defaultPolicy = defaultPolicy;
        this.methodNameToPolicyMap = methodNameToPolicyMap;
        this.currentProxy = proxyProvider.getProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RetryPolicy policy = this.methodNameToPolicyMap.get(method.getName());
        if (policy == null) {
            policy = this.defaultPolicy;
        }
        int invocationFailoverCount = 0;
        boolean isRpc = RetryInvocationHandler.isRpcInvocation(this.currentProxy.proxy);
        int callId = isRpc ? Client.nextCallId() : -2;
        int retries = 0;
        while (true) {
            long invocationAttemptFailoverCount;
            FailoverProxyProvider<T> failoverProxyProvider = this.proxyProvider;
            synchronized (failoverProxyProvider) {
                invocationAttemptFailoverCount = this.proxyProviderFailoverCount;
            }
            if (isRpc) {
                Client.setCallIdAndRetryCount(callId, retries);
            }
            try {
                Object ret = this.invokeMethod(method, args);
                this.hasMadeASuccessfulCall = true;
                return ret;
            }
            catch (Exception e) {
                if (Thread.currentThread().isInterrupted()) {
                    throw e;
                }
                boolean isIdempotentOrAtMostOnce = this.proxyProvider.getInterface().getMethod(method.getName(), method.getParameterTypes()).isAnnotationPresent(Idempotent.class);
                if (!isIdempotentOrAtMostOnce) {
                    isIdempotentOrAtMostOnce = this.proxyProvider.getInterface().getMethod(method.getName(), method.getParameterTypes()).isAnnotationPresent(AtMostOnce.class);
                }
                RetryPolicy.RetryAction action = policy.shouldRetry(e, retries++, invocationFailoverCount, isIdempotentOrAtMostOnce);
                if (action.action == RetryPolicy.RetryAction.RetryDecision.FAIL) {
                    if (action.reason != null) {
                        LOG.warn((Object)("Exception while invoking " + this.currentProxy.proxy.getClass() + "." + method.getName() + " over " + this.currentProxy.proxyInfo + ". Not retrying because " + action.reason), (Throwable)e);
                    }
                    throw e;
                }
                boolean worthLogging = invocationFailoverCount != 0 || this.hasMadeASuccessfulCall;
                if (action.action == RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY && (worthLogging |= LOG.isDebugEnabled())) {
                    String msg = "Exception while invoking " + method.getName() + " of class " + this.currentProxy.proxy.getClass().getSimpleName() + " over " + this.currentProxy.proxyInfo;
                    if (invocationFailoverCount > 0) {
                        msg = msg + " after " + invocationFailoverCount + " fail over attempts";
                    }
                    msg = msg + ". Trying to fail over " + RetryInvocationHandler.formatSleepMessage(action.delayMillis);
                    LOG.info((Object)msg, (Throwable)e);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Exception while invoking " + method.getName() + " of class " + this.currentProxy.proxy.getClass().getSimpleName() + " over " + this.currentProxy.proxyInfo + ". Retrying " + RetryInvocationHandler.formatSleepMessage(action.delayMillis)), (Throwable)e);
                }
                if (action.delayMillis > 0L) {
                    Thread.sleep(action.delayMillis);
                }
                if (action.action != RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY) continue;
                FailoverProxyProvider<T> failoverProxyProvider2 = this.proxyProvider;
                synchronized (failoverProxyProvider2) {
                    if (invocationAttemptFailoverCount == this.proxyProviderFailoverCount) {
                        this.proxyProvider.performFailover(this.currentProxy.proxy);
                        ++this.proxyProviderFailoverCount;
                    } else {
                        LOG.warn((Object)"A failover has occurred since the start of this method invocation attempt.");
                    }
                    this.currentProxy = this.proxyProvider.getProxy();
                }
                ++invocationFailoverCount;
                continue;
            }
            break;
        }
    }

    private static String formatSleepMessage(long millis) {
        if (millis > 0L) {
            return "after sleeping for " + millis + "ms.";
        }
        return "immediately.";
    }

    protected Object invokeMethod(Method method, Object[] args) throws Throwable {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(this.currentProxy.proxy, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    @VisibleForTesting
    static boolean isRpcInvocation(Object proxy) {
        if (proxy instanceof ProtocolTranslator) {
            proxy = ((ProtocolTranslator)proxy).getUnderlyingProxyObject();
        }
        if (!Proxy.isProxyClass(proxy.getClass())) {
            return false;
        }
        InvocationHandler ih = Proxy.getInvocationHandler(proxy);
        return ih instanceof RpcInvocationHandler;
    }

    @Override
    public void close() throws IOException {
        this.proxyProvider.close();
    }

    @Override
    public Client.ConnectionId getConnectionId() {
        return RPC.getConnectionIdForProxy(this.currentProxy.proxy);
    }
}

