/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Row;

@InterfaceAudience.Private
public class Action<R>
implements Comparable<R> {
    private Row action;
    private int originalIndex;
    private long nonce = 0L;
    private int replicaId = 0;
    private int priority;

    public Action(Row action, int originalIndex) {
        this(action, originalIndex, -1);
    }

    public Action(Row action, int originalIndex, int priority) {
        this.action = action;
        this.originalIndex = originalIndex;
        this.priority = priority;
    }

    public Action(Action<R> action, int replicaId) {
        this.action = action.action;
        this.nonce = action.nonce;
        this.originalIndex = action.originalIndex;
        this.replicaId = replicaId;
    }

    public void setNonce(long nonce) {
        this.nonce = nonce;
    }

    public boolean hasNonce() {
        return this.nonce != 0L;
    }

    public Row getAction() {
        return this.action;
    }

    public int getOriginalIndex() {
        return this.originalIndex;
    }

    public int getReplicaId() {
        return this.replicaId;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(Object o) {
        return this.action.compareTo(((Action)o).getAction());
    }

    public int hashCode() {
        return this.action.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Action other = (Action)obj;
        return this.compareTo(other) == 0;
    }

    public long getNonce() {
        return this.nonce;
    }
}

