/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.inject.Inject;
import org.apache.hadoop.hbase.shaded.com.google.inject.Injector;
import org.apache.hadoop.hbase.shaded.com.google.inject.servlet.RequestScoped;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.Params;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public abstract class View
implements Params {
    public static final Logger LOG = LoggerFactory.getLogger(View.class);
    private ViewContext vc;
    @Inject
    Injector injector;

    public View() {
    }

    public View(ViewContext ctx) {
        this.vc = ctx;
    }

    public abstract void render();

    public ViewContext context() {
        if (this.vc == null) {
            if (this.injector == null) {
                throw new WebAppException(StringHelper.join("Error accessing ViewContext from a\n", "child constructor, either move the usage of the View methods\n", "out of the constructor or inject the ViewContext into the\n", "constructor"));
            }
            this.vc = (ViewContext)this.injector.getInstance(ViewContext.class);
        }
        return this.vc;
    }

    public Throwable error() {
        return this.context().rc.error;
    }

    public int status() {
        return this.context().rc.status;
    }

    public boolean inDevMode() {
        return this.context().rc.devMode;
    }

    public Injector injector() {
        return this.context().rc.injector;
    }

    public <T> T getInstance(Class<T> cls) {
        return (T)this.injector().getInstance(cls);
    }

    public HttpServletRequest request() {
        return this.context().rc.request;
    }

    public HttpServletResponse response() {
        return this.context().rc.response;
    }

    public Map<String, String> moreParams() {
        return this.context().rc.moreParams();
    }

    public Map<String, Cookie> cookies() {
        return this.context().rc.cookies();
    }

    public ServletOutputStream outputStream() {
        try {
            return this.response().getOutputStream();
        }
        catch (IOException e) {
            throw new WebAppException(e);
        }
    }

    public PrintWriter writer() {
        try {
            return this.response().getWriter();
        }
        catch (IOException e) {
            throw new WebAppException(e);
        }
    }

    public String $(String key, String defaultValue) {
        String value = this.moreParams().get(key);
        if (value == null) {
            value = this.request().getParameter(key);
        }
        return value == null ? defaultValue : value;
    }

    public String $(String key) {
        return this.$(key, "");
    }

    public void set(String key, String value) {
        this.moreParams().put(key, value);
    }

    public String root() {
        String root = System.getenv("APPLICATION_WEB_PROXY_BASE");
        if (root == null || root.isEmpty()) {
            root = "/";
        }
        return root;
    }

    public String prefix() {
        if (this.context().rc.prefix == null) {
            return this.root();
        }
        return StringHelper.ujoin(this.root(), this.context().rc.prefix);
    }

    public void setTitle(String title) {
        this.set("title", title);
    }

    public void setTitle(String title, String url) {
        this.setTitle(title);
        this.set("title.href", url);
    }

    public String root_url(String ... parts) {
        return StringHelper.ujoin(this.root(), parts);
    }

    public String url(String ... parts) {
        return StringHelper.ujoin(this.prefix(), parts);
    }

    public ResponseInfo info(String about) {
        return this.getInstance(ResponseInfo.class).about(about);
    }

    public void render(Class<? extends SubView> cls) {
        int saved = this.context().nestLevel;
        this.getInstance(cls).renderPartial();
        if (this.context().nestLevel != saved) {
            throw new WebAppException("View " + cls.getSimpleName() + " not complete");
        }
    }

    @RequestScoped
    public static class ViewContext {
        final Controller.RequestContext rc;
        int nestLevel = 0;
        boolean wasInline;

        @Inject
        ViewContext(Controller.RequestContext ctx) {
            this.rc = ctx;
        }

        public int nestLevel() {
            return this.nestLevel;
        }

        public boolean wasInline() {
            return this.wasInline;
        }

        public void set(int nestLevel, boolean wasInline) {
            this.nestLevel = nestLevel;
            this.wasInline = wasInline;
        }

        public Controller.RequestContext requestContext() {
            return this.rc;
        }
    }
}

