/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.commons.math3.util;

import org.apache.hadoop.hbase.shaded.org.apache.commons.math3.Field;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math3.FieldElement;
import org.apache.hadoop.hbase.shaded.org.apache.commons.math3.util.Decimal64Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decimal64
extends Number
implements FieldElement<Decimal64>,
Comparable<Decimal64> {
    public static final Decimal64 ZERO = new Decimal64(0.0);
    public static final Decimal64 ONE = new Decimal64(1.0);
    public static final Decimal64 NEGATIVE_INFINITY = new Decimal64(Double.NEGATIVE_INFINITY);
    public static final Decimal64 POSITIVE_INFINITY = new Decimal64(Double.POSITIVE_INFINITY);
    public static final Decimal64 NAN = new Decimal64(Double.NaN);
    private static final long serialVersionUID = 20120227L;
    private final double value;

    public Decimal64(double x) {
        this.value = x;
    }

    @Override
    public Field<Decimal64> getField() {
        return Decimal64Field.getInstance();
    }

    @Override
    public Decimal64 add(Decimal64 a) {
        return new Decimal64(this.value + a.value);
    }

    @Override
    public Decimal64 subtract(Decimal64 a) {
        return new Decimal64(this.value - a.value);
    }

    @Override
    public Decimal64 negate() {
        return new Decimal64(-this.value);
    }

    @Override
    public Decimal64 multiply(Decimal64 a) {
        return new Decimal64(this.value * a.value);
    }

    @Override
    public Decimal64 multiply(int n) {
        return new Decimal64((double)n * this.value);
    }

    @Override
    public Decimal64 divide(Decimal64 a) {
        return new Decimal64(this.value / a.value);
    }

    @Override
    public Decimal64 reciprocal() {
        return new Decimal64(1.0 / this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int compareTo(Decimal64 o) {
        return Double.compare(this.value, o.value);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Decimal64) {
            Decimal64 that = (Decimal64)obj;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value);
        }
        return false;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }
}

