/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.counters;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.AbstractIterator;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Iterators;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Maps;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.FileSystemCounter;
import org.apache.hadoop.mapreduce.counters.AbstractCounter;
import org.apache.hadoop.mapreduce.counters.CounterGroupBase;
import org.apache.hadoop.mapreduce.util.ResourceBundles;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public abstract class FileSystemCounterGroup<C extends Counter>
implements CounterGroupBase<C> {
    static final int MAX_NUM_SCHEMES = 100;
    static final ConcurrentMap<String, String> schemes = Maps.newConcurrentMap();
    private static final Log LOG = LogFactory.getLog(FileSystemCounterGroup.class);
    private final Map<String, Object[]> map = new ConcurrentSkipListMap<String, Object[]>();
    private String displayName;
    private static final Joiner NAME_JOINER = Joiner.on('_');
    private static final Joiner DISP_JOINER = Joiner.on(": ");

    @Override
    public String getName() {
        return FileSystemCounter.class.getName();
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = ResourceBundles.getCounterGroupName(this.getName(), "File System Counters");
        }
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public void addCounter(C counter) {
        C ours;
        if (counter instanceof FSCounter) {
            FSCounter c = (FSCounter)counter;
            ours = this.findCounter(c.scheme, c.key);
        } else {
            ours = this.findCounter(counter.getName());
        }
        if (ours != null) {
            ours.setValue(counter.getValue());
        }
    }

    @Override
    public C addCounter(String name, String displayName, long value) {
        C counter = this.findCounter(name);
        if (counter != null) {
            counter.setValue(value);
        }
        return counter;
    }

    private String[] parseCounterName(String counterName) {
        int schemeEnd = counterName.indexOf(95);
        if (schemeEnd < 0) {
            throw new IllegalArgumentException("bad fs counter name");
        }
        return new String[]{counterName.substring(0, schemeEnd), counterName.substring(schemeEnd + 1)};
    }

    @Override
    public C findCounter(String counterName, String displayName) {
        return this.findCounter(counterName);
    }

    @Override
    public C findCounter(String counterName, boolean create) {
        try {
            String[] pair = this.parseCounterName(counterName);
            return this.findCounter(pair[0], FileSystemCounter.valueOf(pair[1]));
        }
        catch (Exception e) {
            if (create) {
                throw new IllegalArgumentException(e);
            }
            LOG.warn((Object)(counterName + " is not a recognized counter."));
            return null;
        }
    }

    @Override
    public C findCounter(String counterName) {
        return this.findCounter(counterName, false);
    }

    public synchronized C findCounter(String scheme, FileSystemCounter key) {
        String canonicalScheme = this.checkScheme(scheme);
        Object[] counters = this.map.get(canonicalScheme);
        int ord = key.ordinal();
        if (counters == null) {
            counters = new Object[FileSystemCounter.values().length];
            this.map.put(canonicalScheme, counters);
            counters[ord] = this.newCounter(canonicalScheme, key);
        } else if (counters[ord] == null) {
            counters[ord] = this.newCounter(canonicalScheme, key);
        }
        return (C)((Counter)counters[ord]);
    }

    private String checkScheme(String scheme) {
        String fixed = StringUtils.toUpperCase(scheme);
        String interned = schemes.putIfAbsent(fixed, fixed);
        if (schemes.size() > 100) {
            throw new IllegalArgumentException("too many schemes? " + schemes.size() + " when process scheme: " + scheme);
        }
        return interned == null ? fixed : interned;
    }

    protected abstract C newCounter(String var1, FileSystemCounter var2);

    @Override
    public int size() {
        int n = 0;
        for (Object[] counters : this.map.values()) {
            n += this.numSetCounters(counters);
        }
        return n;
    }

    @Override
    public void incrAllCounters(CounterGroupBase<C> other) {
        if (Preconditions.checkNotNull(other.getUnderlyingGroup(), "other group") instanceof FileSystemCounterGroup) {
            for (Counter counter : other) {
                FSCounter c = (FSCounter)counter.getUnderlyingCounter();
                this.findCounter(c.scheme, c.key).increment(counter.getValue());
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.map.size());
        for (Map.Entry<String, Object[]> entry : this.map.entrySet()) {
            WritableUtils.writeString(out, entry.getKey());
            WritableUtils.writeVInt(out, this.numSetCounters(entry.getValue()));
            for (Object counter : entry.getValue()) {
                if (counter == null) continue;
                FSCounter c = (FSCounter)((Counter)counter).getUnderlyingCounter();
                WritableUtils.writeVInt(out, c.key.ordinal());
                WritableUtils.writeVLong(out, c.getValue());
            }
        }
    }

    private int numSetCounters(Object[] counters) {
        int n = 0;
        for (Object counter : counters) {
            if (counter == null) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        int numSchemes = WritableUtils.readVInt(in);
        FileSystemCounter[] enums = FileSystemCounter.values();
        for (int i = 0; i < numSchemes; ++i) {
            String scheme = WritableUtils.readString(in);
            int numCounters = WritableUtils.readVInt(in);
            for (int j = 0; j < numCounters; ++j) {
                this.findCounter(scheme, enums[WritableUtils.readVInt(in)]).setValue(WritableUtils.readVLong(in));
            }
        }
    }

    @Override
    public Iterator<C> iterator() {
        return new AbstractIterator<C>(){
            Iterator<Object[]> it;
            Object[] counters;
            int i;
            {
                this.it = FileSystemCounterGroup.this.map.values().iterator();
                this.counters = this.it.hasNext() ? this.it.next() : null;
                this.i = 0;
            }

            @Override
            protected C computeNext() {
                while (this.counters != null) {
                    while (this.i < this.counters.length) {
                        Counter counter;
                        if ((counter = (Counter)this.counters[this.i++]) == null) continue;
                        return counter;
                    }
                    this.i = 0;
                    this.counters = this.it.hasNext() ? this.it.next() : null;
                }
                return (Counter)this.endOfData();
            }
        };
    }

    public synchronized boolean equals(Object genericRight) {
        if (genericRight instanceof CounterGroupBase) {
            CounterGroupBase right = (CounterGroupBase)genericRight;
            return Iterators.elementsEqual(this.iterator(), right.iterator());
        }
        return false;
    }

    public synchronized int hashCode() {
        int hash = FileSystemCounter.class.hashCode();
        for (Object[] counters : this.map.values()) {
            if (counters == null) continue;
            hash ^= Arrays.hashCode(counters);
        }
        return hash;
    }

    @InterfaceAudience.Private
    public static class FSCounter
    extends AbstractCounter {
        final String scheme;
        final FileSystemCounter key;
        private long value;

        public FSCounter(String scheme, FileSystemCounter ref) {
            this.scheme = scheme;
            this.key = ref;
        }

        @InterfaceAudience.Private
        public String getScheme() {
            return this.scheme;
        }

        @InterfaceAudience.Private
        public FileSystemCounter getFileSystemCounter() {
            return this.key;
        }

        @Override
        public String getName() {
            return NAME_JOINER.join(this.scheme, this.key.name(), new Object[0]);
        }

        @Override
        public String getDisplayName() {
            return DISP_JOINER.join(this.scheme, this.localizeCounterName(this.key.name()), new Object[0]);
        }

        protected String localizeCounterName(String counterName) {
            return ResourceBundles.getCounterName(FileSystemCounter.class.getName(), counterName, counterName);
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public void setValue(long value) {
            this.value = value;
        }

        @Override
        public void increment(long incr) {
            this.value += incr;
        }

        @Override
        public void write(DataOutput out) throws IOException {
            assert (false) : "shouldn't be called";
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            assert (false) : "shouldn't be called";
        }

        @Override
        public Counter getUnderlyingCounter() {
            return this;
        }
    }
}

