/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.PayloadCarryingServerCallable;
import org.apache.hadoop.hbase.client.RetryingTimeTracker;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.ResponseConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;

class MultiServerCallable<R>
extends PayloadCarryingServerCallable<MultiResponse> {
    private final MultiAction<R> multiAction;
    private final boolean cellBlock;
    private final RetryingTimeTracker tracker;
    private final int rpcTimeout;

    MultiServerCallable(ClusterConnection connection, TableName tableName, ServerName location, RpcControllerFactory rpcFactory, MultiAction<R> multi, int rpcTimeout, RetryingTimeTracker tracker, int priority) {
        super(connection, tableName, null, rpcFactory, priority);
        this.multiAction = multi;
        this.location = new HRegionLocation(null, location);
        this.cellBlock = this.isCellBlock();
        this.tracker = tracker;
        this.rpcTimeout = rpcTimeout;
    }

    @Override
    protected HRegionLocation getLocation() {
        throw new RuntimeException("Cannot get region location for multi-region request");
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        throw new RuntimeException("Cannot get region info for multi-region request");
    }

    MultiAction<R> getMulti() {
        return this.multiAction;
    }

    @Override
    public MultiResponse call(int operationTimeout) throws IOException {
        ClientProtos.MultiResponse responseProto;
        int remainingTime = this.tracker.getRemainingTime(operationTimeout);
        if (remainingTime <= 1) {
            throw new DoNotRetryIOException("Operation Timeout");
        }
        int callTimeout = Math.min(this.rpcTimeout, remainingTime);
        int countOfActions = this.multiAction.size();
        if (countOfActions <= 0) {
            throw new DoNotRetryIOException("No Actions");
        }
        ClientProtos.MultiRequest.Builder multiRequestBuilder = ClientProtos.MultiRequest.newBuilder();
        ClientProtos.RegionAction.Builder regionActionBuilder = ClientProtos.RegionAction.newBuilder();
        ClientProtos.Action.Builder actionBuilder = ClientProtos.Action.newBuilder();
        ClientProtos.MutationProto.Builder mutationBuilder = ClientProtos.MutationProto.newBuilder();
        ArrayList<CellScannable> cells = this.cellBlock ? new ArrayList<CellScannable>(countOfActions) : null;
        long nonceGroup = this.multiAction.getNonceGroup();
        if (nonceGroup != 0L) {
            multiRequestBuilder.setNonceGroup(nonceGroup);
        }
        int regionActionIndex = -1;
        HashMap<Integer, Integer> rowMutationsIndexMap = new HashMap<Integer, Integer>();
        for (Map.Entry e : this.multiAction.actions.entrySet()) {
            byte[] regionName = e.getKey();
            List actions = e.getValue();
            regionActionBuilder.clear();
            regionActionBuilder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
            int rowMutations = 0;
            for (Action action : actions) {
                Row row = action.getAction();
                if (!(row instanceof RowMutations)) continue;
                RowMutations rms = (RowMutations)row;
                regionActionBuilder = this.cellBlock ? RequestConverter.buildNoDataRegionAction(regionName, rms, cells, regionActionBuilder, actionBuilder, mutationBuilder) : RequestConverter.buildRegionAction(regionName, rms);
                regionActionBuilder.setAtomic(true);
                multiRequestBuilder.addRegionAction(regionActionBuilder.build());
                rowMutationsIndexMap.put(++regionActionIndex, action.getOriginalIndex());
                ++rowMutations;
                regionActionBuilder.clear();
                regionActionBuilder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
            }
            if (actions.size() <= rowMutations) continue;
            regionActionBuilder = this.cellBlock ? RequestConverter.buildNoDataRegionAction(regionName, actions, cells, regionActionBuilder, actionBuilder, mutationBuilder) : RequestConverter.buildRegionAction(regionName, actions, regionActionBuilder, actionBuilder, mutationBuilder);
            multiRequestBuilder.addRegionAction(regionActionBuilder.build());
            ++regionActionIndex;
        }
        this.controller.reset();
        if (cells != null) {
            this.controller.setCellScanner(CellUtil.createCellScanner(cells));
        }
        this.controller.setPriority(this.getTableName());
        this.controller.setPriority(this.getPriority());
        this.controller.setCallTimeout(callTimeout);
        ClientProtos.MultiRequest requestProto = multiRequestBuilder.build();
        try {
            responseProto = this.getStub().multi(this.controller, requestProto);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.getRemoteException(e);
        }
        if (responseProto == null) {
            return null;
        }
        return ResponseConverter.getResults(requestProto, rowMutationsIndexMap, responseProto, this.controller.cellScanner());
    }

    private boolean isCellBlock() {
        HConnection connection = this.getConnection();
        if (!(connection instanceof ClusterConnection)) {
            return true;
        }
        return ((ClusterConnection)connection).hasCellBlockSupport();
    }

    @Override
    public void prepare(boolean reload) throws IOException {
        this.setStub(this.getConnection().getClient(this.location.getServerName()));
    }

    @VisibleForTesting
    ServerName getServerName() {
        return this.location.getServerName();
    }
}

