/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.yammer.metrics.core;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class VirtualMachineMetrics {
    private static final int MAX_STACK_TRACE_DEPTH = 100;
    private static final VirtualMachineMetrics INSTANCE = new VirtualMachineMetrics(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans(), ManagementFactory.getOperatingSystemMXBean(), ManagementFactory.getThreadMXBean(), ManagementFactory.getGarbageCollectorMXBeans(), ManagementFactory.getRuntimeMXBean(), ManagementFactory.getPlatformMBeanServer());
    private final MemoryMXBean memory;
    private final List<MemoryPoolMXBean> memoryPools;
    private final OperatingSystemMXBean os;
    private final ThreadMXBean threads;
    private final List<GarbageCollectorMXBean> garbageCollectors;
    private final RuntimeMXBean runtime;
    private final MBeanServer mBeanServer;

    public static VirtualMachineMetrics getInstance() {
        return INSTANCE;
    }

    VirtualMachineMetrics(MemoryMXBean memory, List<MemoryPoolMXBean> memoryPools, OperatingSystemMXBean os, ThreadMXBean threads, List<GarbageCollectorMXBean> garbageCollectors, RuntimeMXBean runtime, MBeanServer mBeanServer) {
        this.memory = memory;
        this.memoryPools = memoryPools;
        this.os = os;
        this.threads = threads;
        this.garbageCollectors = garbageCollectors;
        this.runtime = runtime;
        this.mBeanServer = mBeanServer;
    }

    public double totalInit() {
        return this.memory.getHeapMemoryUsage().getInit() + this.memory.getNonHeapMemoryUsage().getInit();
    }

    public double totalUsed() {
        return this.memory.getHeapMemoryUsage().getUsed() + this.memory.getNonHeapMemoryUsage().getUsed();
    }

    public double totalMax() {
        return this.memory.getHeapMemoryUsage().getMax() + this.memory.getNonHeapMemoryUsage().getMax();
    }

    public double totalCommitted() {
        return this.memory.getHeapMemoryUsage().getCommitted() + this.memory.getNonHeapMemoryUsage().getCommitted();
    }

    public double heapInit() {
        return this.memory.getHeapMemoryUsage().getInit();
    }

    public double heapUsed() {
        return this.memory.getHeapMemoryUsage().getUsed();
    }

    public double heapMax() {
        return this.memory.getHeapMemoryUsage().getMax();
    }

    public double heapCommitted() {
        return this.memory.getHeapMemoryUsage().getCommitted();
    }

    public double heapUsage() {
        MemoryUsage usage = this.memory.getHeapMemoryUsage();
        return (double)usage.getUsed() / (double)usage.getMax();
    }

    public double nonHeapUsage() {
        MemoryUsage usage = this.memory.getNonHeapMemoryUsage();
        return (double)usage.getUsed() / (double)usage.getMax();
    }

    public Map<String, Double> memoryPoolUsage() {
        TreeMap<String, Double> pools = new TreeMap<String, Double>();
        for (MemoryPoolMXBean pool : this.memoryPools) {
            double max = pool.getUsage().getMax() == -1L ? (double)pool.getUsage().getCommitted() : (double)pool.getUsage().getMax();
            pools.put(pool.getName(), (double)pool.getUsage().getUsed() / max);
        }
        return Collections.unmodifiableMap(pools);
    }

    public double fileDescriptorUsage() {
        try {
            Method getOpenFileDescriptorCount = this.os.getClass().getDeclaredMethod("getOpenFileDescriptorCount", new Class[0]);
            getOpenFileDescriptorCount.setAccessible(true);
            Long openFds = (Long)getOpenFileDescriptorCount.invoke((Object)this.os, new Object[0]);
            Method getMaxFileDescriptorCount = this.os.getClass().getDeclaredMethod("getMaxFileDescriptorCount", new Class[0]);
            getMaxFileDescriptorCount.setAccessible(true);
            Long maxFds = (Long)getMaxFileDescriptorCount.invoke((Object)this.os, new Object[0]);
            return openFds.doubleValue() / maxFds.doubleValue();
        }
        catch (NoSuchMethodException e) {
            return Double.NaN;
        }
        catch (IllegalAccessException e) {
            return Double.NaN;
        }
        catch (InvocationTargetException e) {
            return Double.NaN;
        }
    }

    public String version() {
        return System.getProperty("java.runtime.version");
    }

    public String name() {
        return System.getProperty("java.vm.name");
    }

    public long uptime() {
        return TimeUnit.MILLISECONDS.toSeconds(this.runtime.getUptime());
    }

    public int threadCount() {
        return this.threads.getThreadCount();
    }

    public int daemonThreadCount() {
        return this.threads.getDaemonThreadCount();
    }

    public Map<String, GarbageCollectorStats> garbageCollectors() {
        HashMap<String, GarbageCollectorStats> stats = new HashMap<String, GarbageCollectorStats>();
        for (GarbageCollectorMXBean gc : this.garbageCollectors) {
            stats.put(gc.getName(), new GarbageCollectorStats(gc.getCollectionCount(), gc.getCollectionTime()));
        }
        return Collections.unmodifiableMap(stats);
    }

    public Set<String> deadlockedThreads() {
        long[] threadIds = this.threads.findDeadlockedThreads();
        if (threadIds != null) {
            HashSet<String> threads = new HashSet<String>();
            for (ThreadInfo info : this.threads.getThreadInfo(threadIds, 100)) {
                StringBuilder stackTrace = new StringBuilder();
                for (StackTraceElement element : info.getStackTrace()) {
                    stackTrace.append("\t at ").append(element.toString()).append('\n');
                }
                threads.add(String.format("%s locked on %s (owned by %s):\n%s", info.getThreadName(), info.getLockName(), info.getLockOwnerName(), stackTrace.toString()));
            }
            return Collections.unmodifiableSet(threads);
        }
        return Collections.emptySet();
    }

    public Map<Thread.State, Double> threadStatePercentages() {
        HashMap<Thread.State, Double> conditions = new HashMap<Thread.State, Double>();
        for (Thread.State state : Thread.State.values()) {
            conditions.put(state, 0.0);
        }
        long[] allThreadIds = this.threads.getAllThreadIds();
        ThreadInfo[] allThreads = this.threads.getThreadInfo(allThreadIds);
        int liveCount = 0;
        for (ThreadInfo info : allThreads) {
            if (info == null) continue;
            Thread.State state = info.getThreadState();
            conditions.put(state, (Double)conditions.get((Object)state) + 1.0);
            ++liveCount;
        }
        for (Thread.State state : new ArrayList(conditions.keySet())) {
            conditions.put(state, (Double)conditions.get((Object)state) / (double)liveCount);
        }
        return Collections.unmodifiableMap(conditions);
    }

    public void threadDump(OutputStream out) {
        ThreadInfo[] threads = this.threads.dumpAllThreads(true, true);
        PrintWriter writer = new PrintWriter(out, true);
        for (int ti = threads.length - 1; ti >= 0; --ti) {
            ThreadInfo t = threads[ti];
            writer.printf("%s id=%d state=%s", new Object[]{t.getThreadName(), t.getThreadId(), t.getThreadState()});
            LockInfo lock = t.getLockInfo();
            if (lock != null && t.getThreadState() != Thread.State.BLOCKED) {
                writer.printf("\n    - waiting on <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
                writer.printf("\n    - locked <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
            } else if (lock != null && t.getThreadState() == Thread.State.BLOCKED) {
                writer.printf("\n    - waiting to lock <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
            }
            if (t.isSuspended()) {
                writer.print(" (suspended)");
            }
            if (t.isInNative()) {
                writer.print(" (running in native)");
            }
            writer.println();
            if (t.getLockOwnerName() != null) {
                writer.printf("     owned by %s id=%d\n", t.getLockOwnerName(), t.getLockOwnerId());
            }
            StackTraceElement[] elements = t.getStackTrace();
            MonitorInfo[] monitors = t.getLockedMonitors();
            for (int i = 0; i < elements.length; ++i) {
                StackTraceElement element = elements[i];
                writer.printf("    at %s\n", element);
                for (int j = 1; j < monitors.length; ++j) {
                    MonitorInfo monitor = monitors[j];
                    if (monitor.getLockedStackDepth() != i) continue;
                    writer.printf("      - locked %s\n", monitor);
                }
            }
            writer.println();
            LockInfo[] locks = t.getLockedSynchronizers();
            if (locks.length <= 0) continue;
            writer.printf("    Locked synchronizers: count = %d\n", locks.length);
            for (LockInfo l : locks) {
                writer.printf("      - %s\n", l);
            }
            writer.println();
        }
        writer.println();
        writer.flush();
    }

    public Map<String, BufferPoolStats> getBufferPoolStats() {
        try {
            String[] attributes = new String[]{"Count", "MemoryUsed", "TotalCapacity"};
            ObjectName direct = new ObjectName("java.nio:type=BufferPool,name=direct");
            ObjectName mapped = new ObjectName("java.nio:type=BufferPool,name=mapped");
            AttributeList directAttributes = this.mBeanServer.getAttributes(direct, attributes);
            AttributeList mappedAttributes = this.mBeanServer.getAttributes(mapped, attributes);
            TreeMap<String, BufferPoolStats> stats = new TreeMap<String, BufferPoolStats>();
            BufferPoolStats directStats = new BufferPoolStats((Long)((Attribute)directAttributes.get(0)).getValue(), (Long)((Attribute)directAttributes.get(1)).getValue(), (Long)((Attribute)directAttributes.get(2)).getValue());
            stats.put("direct", directStats);
            BufferPoolStats mappedStats = new BufferPoolStats((Long)((Attribute)mappedAttributes.get(0)).getValue(), (Long)((Attribute)mappedAttributes.get(1)).getValue(), (Long)((Attribute)mappedAttributes.get(2)).getValue());
            stats.put("mapped", mappedStats);
            return Collections.unmodifiableMap(stats);
        }
        catch (JMException e) {
            return Collections.emptyMap();
        }
    }

    public static class BufferPoolStats {
        private final long count;
        private final long memoryUsed;
        private final long totalCapacity;

        private BufferPoolStats(long count, long memoryUsed, long totalCapacity) {
            this.count = count;
            this.memoryUsed = memoryUsed;
            this.totalCapacity = totalCapacity;
        }

        public long getCount() {
            return this.count;
        }

        public long getMemoryUsed() {
            return this.memoryUsed;
        }

        public long getTotalCapacity() {
            return this.totalCapacity;
        }
    }

    public static class GarbageCollectorStats {
        private final long runs;
        private final long timeMS;

        private GarbageCollectorStats(long runs, long timeMS) {
            this.runs = runs;
            this.timeMS = timeMS;
        }

        public long getRuns() {
            return this.runs;
        }

        public long getTime(TimeUnit unit) {
            return unit.convert(this.timeMS, TimeUnit.MILLISECONDS);
        }
    }
}

