/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.NeedUnmanagedConnectionException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ScannerCallable;
import org.apache.hadoop.hbase.client.ScannerCallableWithReplicas;
import org.apache.hadoop.hbase.exceptions.OutOfOrderScannerNextException;
import org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ClientScanner
extends AbstractClientScanner {
    private static final Log LOG = LogFactory.getLog(ClientScanner.class);
    static byte[] MAX_BYTE_ARRAY = Bytes.createMaxByteArray(9);
    protected Scan scan;
    protected boolean closed = false;
    protected HRegionInfo currentRegion = null;
    protected ScannerCallableWithReplicas callable = null;
    protected final LinkedList<Result> cache = new LinkedList();
    protected final LinkedList<Result> partialResults = new LinkedList();
    protected byte[] partialResultsRow = null;
    protected Cell lastCellLoadedToCache = null;
    protected final int caching;
    protected long lastNext;
    protected Result lastResult = null;
    protected final long maxScannerResultSize;
    private final ClusterConnection connection;
    private final TableName tableName;
    protected final int scannerTimeout;
    protected boolean scanMetricsPublished = false;
    protected RpcRetryingCaller<Result[]> caller;
    protected RpcControllerFactory rpcControllerFactory;
    protected Configuration conf;
    protected final int primaryOperationTimeout;
    private int retries;
    protected final ExecutorService pool;
    private static KeyValue.MetaComparator metaComparator = new KeyValue.MetaComparator();

    public ClientScanner(Configuration conf, Scan scan, TableName tableName, ClusterConnection connection, RpcRetryingCallerFactory rpcFactory, RpcControllerFactory controllerFactory, ExecutorService pool, int primaryOperationTimeout) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Scan table=" + tableName + ", startRow=" + Bytes.toStringBinary(scan.getStartRow())));
        }
        this.scan = scan;
        this.tableName = tableName;
        this.lastNext = System.currentTimeMillis();
        this.connection = connection;
        this.pool = pool;
        this.primaryOperationTimeout = primaryOperationTimeout;
        this.retries = conf.getInt("hbase.client.retries.number", 31);
        this.maxScannerResultSize = scan.getMaxResultSize() > 0L ? scan.getMaxResultSize() : conf.getLong("hbase.client.scanner.max.result.size", 0x200000L);
        this.scannerTimeout = HBaseConfiguration.getInt(conf, "hbase.client.scanner.timeout.period", "hbase.regionserver.lease.period", 60000);
        this.initScanMetrics(scan);
        this.caching = this.scan.getCaching() > 0 ? this.scan.getCaching() : conf.getInt("hbase.client.scanner.caching", Integer.MAX_VALUE);
        this.caller = rpcFactory.newCaller();
        this.rpcControllerFactory = controllerFactory;
        this.conf = conf;
        this.initializeScannerInConstruction();
    }

    protected void initializeScannerInConstruction() throws IOException {
        this.nextScanner(this.caching, false);
    }

    protected ClusterConnection getConnection() {
        return this.connection;
    }

    @Deprecated
    protected byte[] getTableName() {
        return this.tableName.getName();
    }

    protected TableName getTable() {
        return this.tableName;
    }

    protected int getRetries() {
        return this.retries;
    }

    protected int getScannerTimeout() {
        return this.scannerTimeout;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    protected Scan getScan() {
        return this.scan;
    }

    protected ExecutorService getPool() {
        return this.pool;
    }

    protected int getPrimaryOperationTimeout() {
        return this.primaryOperationTimeout;
    }

    protected int getCaching() {
        return this.caching;
    }

    protected long getTimestamp() {
        return this.lastNext;
    }

    @VisibleForTesting
    protected long getMaxResultSize() {
        return this.maxScannerResultSize;
    }

    protected boolean checkScanStopRow(byte[] endKey) {
        byte[] stopRow;
        int cmp;
        return this.scan.getStopRow().length > 0 && (cmp = Bytes.compareTo(stopRow = this.scan.getStopRow(), 0, stopRow.length, endKey, 0, endKey.length)) <= 0;
    }

    protected final void closeScanner() throws IOException {
        if (this.callable != null) {
            this.callable.setClose();
            this.call(this.callable, this.caller, this.scannerTimeout);
            this.callable = null;
        }
    }

    protected boolean nextScanner(int nbRows, boolean done) throws IOException {
        byte[] localStartKey;
        this.closeScanner();
        if (this.currentRegion != null) {
            byte[] endKey = this.currentRegion.getEndKey();
            if (endKey == null || Bytes.equals(endKey, HConstants.EMPTY_BYTE_ARRAY) || this.checkScanStopRow(endKey) || done) {
                this.close();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Finished " + this.currentRegion));
                }
                return false;
            }
            localStartKey = endKey;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Finished " + this.currentRegion));
            }
        } else {
            localStartKey = this.scan.getStartRow();
        }
        if (LOG.isDebugEnabled() && this.currentRegion != null) {
            LOG.debug((Object)("Advancing internal scanner to startKey at '" + Bytes.toStringBinary(localStartKey) + "'"));
        }
        try {
            this.callable = this.getScannerCallable(localStartKey, nbRows);
            this.call(this.callable, this.caller, this.scannerTimeout);
            this.currentRegion = this.callable.getHRegionInfo();
            if (this.scanMetrics != null) {
                this.scanMetrics.countOfRegions.incrementAndGet();
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return true;
    }

    @VisibleForTesting
    boolean isAnyRPCcancelled() {
        return this.callable.isAnyRPCcancelled();
    }

    Result[] call(ScannerCallableWithReplicas callable, RpcRetryingCaller<Result[]> caller, int scannerTimeout) throws IOException, RuntimeException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        return caller.callWithoutRetries(callable, scannerTimeout);
    }

    @InterfaceAudience.Private
    protected ScannerCallableWithReplicas getScannerCallable(byte[] localStartKey, int nbRows) {
        this.scan.setStartRow(localStartKey);
        ScannerCallable s = new ScannerCallable(this.getConnection(), this.getTable(), this.scan, this.scanMetrics, this.rpcControllerFactory);
        s.setCaching(nbRows);
        ScannerCallableWithReplicas sr = new ScannerCallableWithReplicas(this.tableName, this.getConnection(), s, this.pool, this.primaryOperationTimeout, this.scan, this.retries, this.scannerTimeout, this.caching, this.conf, this.caller);
        return sr;
    }

    protected void writeScanMetrics() {
        if (this.scanMetrics == null || this.scanMetricsPublished) {
            return;
        }
        MapReduceProtos.ScanMetrics pScanMetrics = ProtobufUtil.toScanMetrics(this.scanMetrics);
        this.scan.setAttribute("scan.attributes.metrics.data", pScanMetrics.toByteArray());
        this.scanMetricsPublished = true;
    }

    @Override
    public Result next() throws IOException {
        if (this.cache.size() == 0 && this.closed) {
            return null;
        }
        if (this.cache.size() == 0) {
            this.loadCache();
        }
        if (this.cache.size() > 0) {
            return this.cache.poll();
        }
        this.writeScanMetrics();
        return null;
    }

    @VisibleForTesting
    public int getCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    private boolean regionExhausted(Result[] values) {
        if (values == null) {
            return true;
        }
        if (values.length == 0 && !this.callable.isHeartbeatMessage()) {
            return true;
        }
        return this.callable.hasMoreResultsContext() && !this.callable.getServerHasMoreResults();
    }

    private void closeScannerIfExhausted(boolean exhausted) throws IOException {
        if (exhausted) {
            if (!this.partialResults.isEmpty()) {
                LOG.warn((Object)"Server tells us there is no more results for this region but we still have partialResults, this should not happen, retry on the current scanner anyway");
            } else {
                this.closeScanner();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadCache() throws IOException {
        Result[] values = null;
        long remainingResultSize = this.maxScannerResultSize;
        int countdown = this.caching;
        if (this.callable == null && !this.nextScanner(countdown, false)) {
            return;
        }
        this.callable.setCaching(this.caching);
        boolean retryAfterOutOfOrderException = true;
        int retriesLeft = this.getRetries();
        while (true) {
            try {
                while ((values = this.call(this.callable, this.caller, this.scannerTimeout)) == null && this.callable.switchedToADifferentReplica()) {
                    this.clearPartialResults();
                    this.currentRegion = this.callable.getHRegionInfo();
                }
                retryAfterOutOfOrderException = true;
            }
            catch (DoNotRetryIOException | NeedUnmanagedConnectionException e) {
                this.clearPartialResults();
                Throwable cause = e.getCause();
                if (!(cause != null && cause instanceof NotServingRegionException || cause != null && cause instanceof RegionServerStoppedException || e instanceof OutOfOrderScannerNextException || e instanceof UnknownScannerException) && !(e instanceof ScannerResetException)) throw e;
                if (retriesLeft-- <= 0) {
                    throw e;
                }
                if (this.lastResult != null) {
                    if (!this.lastResult.isPartial() && this.scan.getBatch() < 0) {
                        if (this.scan.isReversed()) {
                            this.scan.setStartRow(ClientScanner.createClosestRowBefore(this.lastResult.getRow()));
                        } else {
                            this.scan.setStartRow(Bytes.add(this.lastResult.getRow(), new byte[1]));
                        }
                    } else {
                        this.scan.setStartRow(this.lastResult.getRow());
                    }
                }
                if (e instanceof OutOfOrderScannerNextException) {
                    if (!retryAfterOutOfOrderException) throw new DoNotRetryIOException("Failed after retry of OutOfOrderScannerNextException: was there a rpc timeout?", e);
                    retryAfterOutOfOrderException = false;
                }
                this.currentRegion = null;
                this.callable = null;
                if (this.nextScanner(countdown, false)) continue;
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.scanMetrics != null) {
                this.scanMetrics.sumOfMillisSecBetweenNexts.addAndGet(currentTime - this.lastNext);
            }
            this.lastNext = currentTime;
            List<Result> resultsToAddToCache = this.getResultsToAddToCache(values, this.callable.isHeartbeatMessage());
            if (!resultsToAddToCache.isEmpty()) {
                for (Result rs : resultsToAddToCache) {
                    if ((rs = this.filterLoadedCell(rs)) == null) continue;
                    this.cache.add(rs);
                    for (Cell cell : rs.rawCells()) {
                        remainingResultSize -= CellUtil.estimatedHeapSizeOf(cell);
                    }
                    --countdown;
                    this.lastResult = rs;
                    if (this.lastResult.isPartial() || this.scan.getBatch() > 0) {
                        this.updateLastCellLoadedToCache(this.lastResult);
                        continue;
                    }
                    this.lastCellLoadedToCache = null;
                }
            }
            boolean exhausted = this.regionExhausted(values);
            if (this.callable.isHeartbeatMessage() && !this.cache.isEmpty()) {
                if (!LOG.isTraceEnabled()) return;
                LOG.trace((Object)"Heartbeat message received and cache contains Results. Breaking out of scan loop");
                return;
            }
            if (countdown <= 0) {
                this.closeScannerIfExhausted(exhausted);
                return;
            }
            if (remainingResultSize <= 0L) {
                if (!this.cache.isEmpty()) {
                    this.closeScannerIfExhausted(exhausted);
                    return;
                }
                remainingResultSize = this.maxScannerResultSize;
            }
            if (!exhausted) continue;
            if (!this.partialResults.isEmpty()) {
                LOG.warn((Object)"Server tells us there is no more results for this region but we still have partialResults, this should not happen, retry on the current scanner anyway");
                continue;
            }
            if (!this.nextScanner(countdown, values == null)) return;
        }
    }

    protected List<Result> getResultsToAddToCache(Result[] resultsFromServer, boolean heartbeatMessage) throws IOException {
        Result partial;
        boolean allowPartials;
        int resultSize = resultsFromServer != null ? resultsFromServer.length : 0;
        ArrayList<Result> resultsToAddToCache = new ArrayList<Result>(resultSize);
        boolean isBatchSet = this.scan != null && this.scan.getBatch() > 0;
        boolean bl = allowPartials = this.scan != null && this.scan.getAllowPartialResults();
        if (allowPartials || isBatchSet) {
            this.addResultsToList(resultsToAddToCache, resultsFromServer, 0, null == resultsFromServer ? 0 : resultsFromServer.length);
            return resultsToAddToCache;
        }
        if (resultsFromServer == null || resultsFromServer.length == 0) {
            if (!this.partialResults.isEmpty() && !heartbeatMessage) {
                resultsToAddToCache.add(Result.createCompleteResult(this.partialResults));
                this.clearPartialResults();
            }
            return resultsToAddToCache;
        }
        Result last = resultsFromServer[resultsFromServer.length - 1];
        Result result = partial = last.isPartial() ? last : null;
        if (LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("number results from RPC: ").append(resultsFromServer.length).append(",");
            sb.append("partial != null: ").append(partial != null).append(",");
            sb.append("number of partials so far: ").append(this.partialResults.size());
            LOG.trace((Object)sb.toString());
        }
        if (partial != null && this.partialResults.isEmpty()) {
            this.addToPartialResults(partial);
            this.addResultsToList(resultsToAddToCache, resultsFromServer, 0, resultsFromServer.length - 1);
        } else if (!this.partialResults.isEmpty()) {
            for (int i = 0; i < resultsFromServer.length; ++i) {
                Result result2 = resultsFromServer[i];
                if (Bytes.equals(this.partialResultsRow, result2.getRow())) {
                    this.addToPartialResults(result2);
                    if (result2.isPartial()) continue;
                    resultsToAddToCache.add(Result.createCompleteResult(this.partialResults));
                    this.clearPartialResults();
                    continue;
                }
                if (!this.partialResults.isEmpty()) {
                    resultsToAddToCache.add(Result.createCompleteResult(this.partialResults));
                    this.clearPartialResults();
                }
                if (result2.isPartial()) {
                    this.addToPartialResults(result2);
                    continue;
                }
                resultsToAddToCache.add(result2);
            }
        } else {
            this.addResultsToList(resultsToAddToCache, resultsFromServer, 0, resultsFromServer.length);
        }
        return resultsToAddToCache;
    }

    private void addToPartialResults(Result result) throws IOException {
        byte[] row = result.getRow();
        if (this.partialResultsRow != null && !Bytes.equals(row, this.partialResultsRow)) {
            throw new IOException("Partial result row does not match. All partial results must come from the same row. partialResultsRow: " + Bytes.toString(this.partialResultsRow) + "row: " + Bytes.toString(row));
        }
        this.partialResultsRow = row;
        this.partialResults.add(result);
    }

    private void clearPartialResults() {
        this.partialResults.clear();
        this.partialResultsRow = null;
    }

    private void addResultsToList(List<Result> outputList, Result[] inputArray, int start, int end) {
        if (inputArray == null || start < 0 || end > inputArray.length) {
            return;
        }
        for (int i = start; i < end; ++i) {
            outputList.add(inputArray[i]);
        }
    }

    @Override
    public void close() {
        if (!this.scanMetricsPublished) {
            this.writeScanMetrics();
        }
        if (this.callable != null) {
            this.callable.setClose();
            try {
                this.call(this.callable, this.caller, this.scannerTimeout);
            }
            catch (UnknownScannerException unknownScannerException) {
            }
            catch (IOException e) {
                LOG.warn((Object)("scanner failed to close. Exception follows: " + e));
            }
            this.callable = null;
        }
        this.closed = true;
    }

    protected static byte[] createClosestRowBefore(byte[] row) {
        if (row == null) {
            throw new IllegalArgumentException("The passed row is empty");
        }
        if (Bytes.equals(row, HConstants.EMPTY_BYTE_ARRAY)) {
            return MAX_BYTE_ARRAY;
        }
        if (row[row.length - 1] == 0) {
            return Arrays.copyOf(row, row.length - 1);
        }
        byte[] closestFrontRow = Arrays.copyOf(row, row.length);
        closestFrontRow[row.length - 1] = (byte)((closestFrontRow[row.length - 1] & 0xFF) - 1);
        closestFrontRow = Bytes.add(closestFrontRow, MAX_BYTE_ARRAY);
        return closestFrontRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renewLease() {
        if (this.callable != null) {
            this.callable.setRenew(true);
            try {
                this.caller.callWithoutRetries(this.callable, this.scannerTimeout);
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            finally {
                this.callable.setRenew(false);
            }
            return true;
        }
        return false;
    }

    protected void updateLastCellLoadedToCache(Result result) {
        if (result.rawCells().length == 0) {
            return;
        }
        this.lastCellLoadedToCache = result.rawCells()[result.rawCells().length - 1];
    }

    private int compare(Cell a, Cell b) {
        int r = 0;
        r = this.currentRegion != null && this.currentRegion.isMetaRegion() ? metaComparator.compareRows(a, b) : CellComparator.compareRows(a, b);
        if (r != 0) {
            return this.scan.isReversed() ? -r : r;
        }
        return CellComparator.compareWithoutRow(a, b);
    }

    private Result filterLoadedCell(Result result) {
        int index;
        if (this.lastCellLoadedToCache == null || result.rawCells().length == 0) {
            return result;
        }
        if (this.compare(this.lastCellLoadedToCache, result.rawCells()[0]) < 0) {
            return result;
        }
        if (this.compare(this.lastCellLoadedToCache, result.rawCells()[result.rawCells().length - 1]) >= 0) {
            return null;
        }
        for (index = 1; index < result.rawCells().length && this.compare(this.lastCellLoadedToCache, result.rawCells()[index]) >= 0; ++index) {
        }
        Cell[] list = Arrays.copyOfRange(result.rawCells(), index, result.rawCells().length);
        return Result.create(list, result.getExists(), result.isStale(), result.isPartial());
    }
}

