/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.org.apache.avro.util.Utf8;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.EventReader;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.EventWriter;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.TaskFailed;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskFailedEvent
implements HistoryEvent {
    private TaskFailed datum = null;
    private TaskAttemptID failedDueToAttempt;
    private TaskID id;
    private TaskType taskType;
    private long finishTime;
    private String status;
    private String error;
    private Counters counters;
    private static final Counters EMPTY_COUNTERS = new Counters();

    public TaskFailedEvent(TaskID id, long finishTime, TaskType taskType, String error, String status, TaskAttemptID failedDueToAttempt, Counters counters) {
        this.id = id;
        this.finishTime = finishTime;
        this.taskType = taskType;
        this.error = error;
        this.status = status;
        this.failedDueToAttempt = failedDueToAttempt;
        this.counters = counters;
    }

    public TaskFailedEvent(TaskID id, long finishTime, TaskType taskType, String error, String status, TaskAttemptID failedDueToAttempt) {
        this(id, finishTime, taskType, error, status, failedDueToAttempt, EMPTY_COUNTERS);
    }

    TaskFailedEvent() {
    }

    @Override
    public Object getDatum() {
        if (this.datum == null) {
            this.datum = new TaskFailed();
            this.datum.taskid = new Utf8(this.id.toString());
            this.datum.error = new Utf8(this.error);
            this.datum.finishTime = this.finishTime;
            this.datum.taskType = new Utf8(this.taskType.name());
            this.datum.failedDueToAttempt = this.failedDueToAttempt == null ? null : new Utf8(this.failedDueToAttempt.toString());
            this.datum.status = new Utf8(this.status);
            this.datum.counters = EventWriter.toAvro(this.counters);
        }
        return this.datum;
    }

    @Override
    public void setDatum(Object odatum) {
        this.datum = (TaskFailed)odatum;
        this.id = TaskID.forName(this.datum.taskid.toString());
        this.taskType = TaskType.valueOf(this.datum.taskType.toString());
        this.finishTime = this.datum.finishTime;
        this.error = this.datum.error.toString();
        this.failedDueToAttempt = this.datum.failedDueToAttempt == null ? null : TaskAttemptID.forName(this.datum.failedDueToAttempt.toString());
        this.status = this.datum.status.toString();
        this.counters = EventReader.fromAvro(this.datum.counters);
    }

    public TaskID getTaskId() {
        return this.id;
    }

    public String getError() {
        return this.error;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public TaskAttemptID getFailedAttemptID() {
        return this.failedDueToAttempt;
    }

    public String getTaskStatus() {
        return this.status;
    }

    public Counters getCounters() {
        return this.counters;
    }

    @Override
    public EventType getEventType() {
        return EventType.TASK_FAILED;
    }
}

