/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords;

import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.math.LongRange;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class GetApplicationsRequest {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static GetApplicationsRequest newInstance() {
        GetApplicationsRequest request = Records.newRecord(GetApplicationsRequest.class);
        return request;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static GetApplicationsRequest newInstance(ApplicationsRequestScope scope, Set<String> users, Set<String> queues, Set<String> applicationTypes, Set<String> applicationTags, EnumSet<YarnApplicationState> applicationStates, LongRange startRange, LongRange finishRange, Long limit) {
        GetApplicationsRequest request = Records.newRecord(GetApplicationsRequest.class);
        if (scope != null) {
            request.setScope(scope);
        }
        request.setUsers(users);
        request.setQueues(queues);
        request.setApplicationTypes(applicationTypes);
        request.setApplicationTags(applicationTags);
        request.setApplicationStates(applicationStates);
        if (startRange != null) {
            request.setStartRange(startRange.getMinimumLong(), startRange.getMaximumLong());
        }
        if (finishRange != null) {
            request.setFinishRange(finishRange.getMinimumLong(), finishRange.getMaximumLong());
        }
        if (limit != null) {
            request.setLimit(limit);
        }
        return request;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static GetApplicationsRequest newInstance(ApplicationsRequestScope scope) {
        GetApplicationsRequest request = Records.newRecord(GetApplicationsRequest.class);
        request.setScope(scope);
        return request;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static GetApplicationsRequest newInstance(Set<String> applicationTypes) {
        GetApplicationsRequest request = Records.newRecord(GetApplicationsRequest.class);
        request.setApplicationTypes(applicationTypes);
        return request;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static GetApplicationsRequest newInstance(EnumSet<YarnApplicationState> applicationStates) {
        GetApplicationsRequest request = Records.newRecord(GetApplicationsRequest.class);
        request.setApplicationStates(applicationStates);
        return request;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static GetApplicationsRequest newInstance(Set<String> applicationTypes, EnumSet<YarnApplicationState> applicationStates) {
        GetApplicationsRequest request = Records.newRecord(GetApplicationsRequest.class);
        request.setApplicationTypes(applicationTypes);
        request.setApplicationStates(applicationStates);
        return request;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Set<String> getApplicationTypes();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationTypes(Set<String> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract EnumSet<YarnApplicationState> getApplicationStates();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationStates(EnumSet<YarnApplicationState> var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationStates(Set<String> var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract Set<String> getUsers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setUsers(Set<String> var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract Set<String> getQueues();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueues(Set<String> var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract long getLimit();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setLimit(long var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract LongRange getStartRange();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setStartRange(long var1, long var3) throws IllegalArgumentException;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract LongRange getFinishRange();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setFinishRange(long var1, long var3);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract Set<String> getApplicationTags();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationTags(Set<String> var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract ApplicationsRequestScope getScope();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setScope(ApplicationsRequestScope var1);
}

