/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;

@InterfaceAudience.Public
@InterfaceStability.Stable
public final class FilterList
extends Filter {
    private static final int MAX_LOG_FILTERS = 5;
    private Operator operator = Operator.MUST_PASS_ALL;
    private List<Filter> filters = new ArrayList<Filter>();
    private Filter seekHintFilter = null;
    private Cell referenceKV = null;
    private Cell transformedKV = null;

    public FilterList(List<Filter> rowFilters) {
        this.filters = rowFilters instanceof ArrayList ? rowFilters : new ArrayList<Filter>(rowFilters);
    }

    public FilterList(Filter ... rowFilters) {
        this.filters = new ArrayList<Filter>(Arrays.asList(rowFilters));
    }

    public FilterList(Operator operator) {
        this.operator = operator;
    }

    public FilterList(Operator operator, List<Filter> rowFilters) {
        this.filters = new ArrayList<Filter>(rowFilters);
        this.operator = operator;
    }

    public FilterList(Operator operator, Filter ... rowFilters) {
        this.filters = new ArrayList<Filter>(Arrays.asList(rowFilters));
        this.operator = operator;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void addFilter(Filter filter) {
        if (this.isReversed() != filter.isReversed()) {
            throw new IllegalArgumentException("Filters in the list must have the same reversed flag, this.reversed=" + this.isReversed());
        }
        this.filters.add(filter);
    }

    @Override
    public void reset() throws IOException {
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            this.filters.get(i).reset();
        }
        this.seekHintFilter = null;
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) throws IOException {
        boolean flag = this.operator == Operator.MUST_PASS_ONE;
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            Filter filter = this.filters.get(i);
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterAllRemaining() && !filter.filterRowKey(rowKey, offset, length)) continue;
                flag = true;
                continue;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining() || filter.filterRowKey(rowKey, offset, length)) continue;
            flag = false;
        }
        return flag;
    }

    @Override
    public boolean filterAllRemaining() throws IOException {
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            if (this.filters.get(i).filterAllRemaining()) {
                if (this.operator != Operator.MUST_PASS_ALL) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    @Override
    public Cell transformCell(Cell v) throws IOException {
        if (!v.equals(this.referenceKV)) {
            throw new IllegalStateException("Reference Cell: " + this.referenceKV + " does not match: " + v);
        }
        return this.transformedKV;
    }

    @Override
    @Deprecated
    public KeyValue transform(KeyValue v) throws IOException {
        if (!v.equals(this.referenceKV)) {
            throw new IllegalStateException("Reference Cell: " + this.referenceKV + " does not match: " + v);
        }
        return KeyValueUtil.ensureKeyValue(this.transformedKV);
    }

    @Override
    @SuppressWarnings(value={"SF_SWITCH_FALLTHROUGH"}, justification="Intentional")
    public Filter.ReturnCode filterKeyValue(Cell v) throws IOException {
        this.referenceKV = v;
        Cell transformed = v;
        Filter.ReturnCode rc = this.operator == Operator.MUST_PASS_ONE ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
        int listize = this.filters.size();
        block13: for (int i = 0; i < listize; ++i) {
            Filter filter = this.filters.get(i);
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (filter.filterAllRemaining()) {
                    return Filter.ReturnCode.NEXT_ROW;
                }
                Filter.ReturnCode code = filter.filterKeyValue(v);
                switch (code) {
                    case INCLUDE_AND_NEXT_COL: {
                        rc = Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                    }
                    case INCLUDE: {
                        transformed = filter.transformCell(transformed);
                        continue block13;
                    }
                    case SEEK_NEXT_USING_HINT: {
                        this.seekHintFilter = filter;
                        return code;
                    }
                    default: {
                        return code;
                    }
                }
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterAllRemaining()) continue;
            switch (filter.filterKeyValue(v)) {
                case INCLUDE: {
                    if (rc != Filter.ReturnCode.INCLUDE_AND_NEXT_COL) {
                        rc = Filter.ReturnCode.INCLUDE;
                    }
                    transformed = filter.transformCell(transformed);
                    continue block13;
                }
                case INCLUDE_AND_NEXT_COL: {
                    rc = Filter.ReturnCode.INCLUDE_AND_NEXT_COL;
                    transformed = filter.transformCell(transformed);
                    continue block13;
                }
                case NEXT_ROW: {
                    continue block13;
                }
                case SKIP: {
                    continue block13;
                }
                case NEXT_COL: {
                    continue block13;
                }
                case SEEK_NEXT_USING_HINT: {
                    continue block13;
                }
                default: {
                    throw new IllegalStateException("Received code is not valid.");
                }
            }
        }
        this.transformedKV = transformed;
        return rc;
    }

    @Override
    public void filterRowCells(List<Cell> cells) throws IOException {
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            this.filters.get(i).filterRowCells(cells);
        }
    }

    @Override
    public boolean hasFilterRow() {
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            if (!this.filters.get(i).hasFilterRow()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterRow() throws IOException {
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            Filter filter = this.filters.get(i);
            if (this.operator == Operator.MUST_PASS_ALL) {
                if (!filter.filterRow()) continue;
                return true;
            }
            if (this.operator != Operator.MUST_PASS_ONE || filter.filterRow()) continue;
            return false;
        }
        return this.operator == Operator.MUST_PASS_ONE;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        FilterProtos.FilterList.Builder builder = FilterProtos.FilterList.newBuilder();
        builder.setOperator(FilterProtos.FilterList.Operator.valueOf(this.operator.name()));
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            builder.addFilters(ProtobufUtil.toFilter(this.filters.get(i)));
        }
        return builder.build().toByteArray();
    }

    public static FilterList parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.FilterList proto;
        try {
            proto = FilterProtos.FilterList.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        ArrayList<Filter> rowFilters = new ArrayList<Filter>(proto.getFiltersCount());
        try {
            List<FilterProtos.Filter> filtersList = proto.getFiltersList();
            int listSize = filtersList.size();
            for (int i = 0; i < listSize; ++i) {
                rowFilters.add(ProtobufUtil.toFilter(filtersList.get(i)));
            }
        }
        catch (IOException ioe) {
            throw new DeserializationException(ioe);
        }
        return new FilterList(Operator.valueOf(proto.getOperator().name()), rowFilters);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FilterList)) {
            return false;
        }
        FilterList o = (FilterList)other;
        return this.getOperator().equals((Object)o.getOperator()) && (this.getFilters() == o.getFilters() || this.getFilters().equals(o.getFilters()));
    }

    @Override
    @Deprecated
    public KeyValue getNextKeyHint(KeyValue currentKV) throws IOException {
        return KeyValueUtil.ensureKeyValue(this.getNextCellHint(currentKV));
    }

    @Override
    public Cell getNextCellHint(Cell currentKV) throws IOException {
        Cell keyHint = null;
        if (this.operator == Operator.MUST_PASS_ALL) {
            keyHint = this.seekHintFilter.getNextCellHint(currentKV);
            return keyHint;
        }
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            Cell curKeyHint = this.filters.get(i).getNextCellHint(currentKV);
            if (curKeyHint == null) {
                return null;
            }
            if (curKeyHint == null) continue;
            if (keyHint == null) {
                keyHint = curKeyHint;
                continue;
            }
            if (KeyValue.COMPARATOR.compare(keyHint, curKeyHint) <= 0) continue;
            keyHint = curKeyHint;
        }
        return keyHint;
    }

    @Override
    public boolean isFamilyEssential(byte[] name) throws IOException {
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            if (!this.filters.get(i).isFamilyEssential(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setReversed(boolean reversed) {
        int listize = this.filters.size();
        for (int i = 0; i < listize; ++i) {
            this.filters.get(i).setReversed(reversed);
        }
        this.reversed = reversed;
    }

    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxFilters) {
        int endIndex = this.filters.size() < maxFilters ? this.filters.size() : maxFilters;
        return String.format("%s %s (%d/%d): %s", this.getClass().getSimpleName(), this.operator == Operator.MUST_PASS_ALL ? "AND" : "OR", endIndex, this.filters.size(), this.filters.subList(0, endIndex).toString());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static enum Operator {
        MUST_PASS_ALL,
        MUST_PASS_ONE;

    }
}

