/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import java.util.Enumeration;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.yarn.webapp.view.TextPage;

@InterfaceAudience.LimitedPrivate(value={"YARN", "MapReduce"})
public class DefaultPage
extends TextPage {
    static final Joiner valJoiner = Joiner.on(", ");

    @Override
    public void render() {
        this.puts("Request URI: ", this.request().getRequestURI());
        this.puts("Query parameters:");
        Map params = this.request().getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            this.puts("  ", entry.getKey(), "=", valJoiner.join((Object[])entry.getValue()));
        }
        this.puts("More parameters:");
        for (Map.Entry<Object, Object> entry : this.moreParams().entrySet()) {
            this.puts("  ", entry.getKey(), "=", entry.getValue());
        }
        this.puts("Path info: ", this.request().getPathInfo());
        this.puts("Path translated: ", this.request().getPathTranslated());
        this.puts("Auth type: ", this.request().getAuthType());
        this.puts("Remote address: " + this.request().getRemoteAddr());
        this.puts("Remote user: ", this.request().getRemoteUser());
        this.puts("Servlet attributes:");
        Enumeration attrNames = this.request().getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String string = (String)attrNames.nextElement();
            this.puts("  ", string, "=", this.request().getAttribute(string));
        }
        this.puts("Headers:");
        Enumeration enumeration = this.request().getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            this.puts("  ", key, "=", this.request().getHeader(key));
        }
    }
}

