/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.jmx;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.JsonFactory;
import org.apache.hadoop.hbase.shaded.org.codehaus.jackson.JsonGenerator;
import org.apache.hadoop.http.HttpServer2;

public class JMXJsonServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog(JMXJsonServlet.class);
    private static final long serialVersionUID = 1L;
    private static final String CALLBACK_PARAM = "callback";
    protected transient MBeanServer mBeanServer = null;

    public void init() throws ServletException {
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String jsonpcb = null;
        PrintWriter writer = null;
        try {
            if (!HttpServer2.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
                return;
            }
            JsonGenerator jg = null;
            writer = response.getWriter();
            jsonpcb = request.getParameter(CALLBACK_PARAM);
            if (jsonpcb != null) {
                response.setContentType("application/javascript; charset=utf8");
                writer.write(jsonpcb + "(");
            } else {
                response.setContentType("application/json; charset=utf8");
            }
            JsonFactory jsonFactory = new JsonFactory();
            jg = jsonFactory.createJsonGenerator(writer);
            jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            jg.useDefaultPrettyPrinter();
            jg.writeStartObject();
            if (this.mBeanServer == null) {
                jg.writeStringField("result", "ERROR");
                jg.writeStringField("message", "No MBeanServer could be found");
                jg.close();
                LOG.error((Object)"No MBeanServer could be found.");
                response.setStatus(404);
                return;
            }
            String getmethod = request.getParameter("get");
            if (getmethod != null) {
                String[] splitStrings = getmethod.split("\\:\\:");
                if (splitStrings.length != 2) {
                    jg.writeStringField("result", "ERROR");
                    jg.writeStringField("message", "query format is not as expected.");
                    jg.close();
                    response.setStatus(400);
                    return;
                }
                this.listBeans(jg, new ObjectName(splitStrings[0]), splitStrings[1], response);
                jg.close();
                return;
            }
            String qry = request.getParameter("qry");
            if (qry == null) {
                qry = "*:*";
            }
            this.listBeans(jg, new ObjectName(qry), null, response);
            jg.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Caught an exception while processing JMX request", (Throwable)e);
            response.setStatus(500);
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)"Caught an exception while processing JMX request", (Throwable)e);
            response.setStatus(400);
        }
        finally {
            if (jsonpcb != null) {
                writer.write(");");
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void listBeans(JsonGenerator jg, ObjectName qry, String attribute, HttpServletResponse response) throws IOException {
        LOG.debug((Object)("Listing beans for " + qry));
        Set<ObjectName> names = null;
        names = this.mBeanServer.queryNames(qry, null);
        jg.writeArrayFieldStart("beans");
        for (ObjectName oname : names) {
            MBeanInfo minfo;
            String code = "";
            Object attributeinfo = null;
            try {
                minfo = this.mBeanServer.getMBeanInfo(oname);
                code = minfo.getClassName();
                String prs = "";
                try {
                    if ("org.apache.commons.modeler.BaseModelMBean".equals(code)) {
                        prs = "modelerType";
                        code = (String)this.mBeanServer.getAttribute(oname, prs);
                    }
                    if (attribute != null) {
                        prs = attribute;
                        attributeinfo = this.mBeanServer.getAttribute(oname, prs);
                    }
                }
                catch (AttributeNotFoundException e) {
                    LOG.error((Object)("getting attribute " + prs + " of " + oname + " threw an exception"), (Throwable)e);
                }
                catch (MBeanException e) {
                    LOG.error((Object)("getting attribute " + prs + " of " + oname + " threw an exception"), (Throwable)e);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("getting attribute " + prs + " of " + oname + " threw an exception"), (Throwable)e);
                }
                catch (ReflectionException e) {
                    LOG.error((Object)("getting attribute " + prs + " of " + oname + " threw an exception"), (Throwable)e);
                }
            }
            catch (InstanceNotFoundException e) {
                continue;
            }
            catch (IntrospectionException e) {
                LOG.error((Object)("Problem while trying to process JMX query: " + qry + " with MBean " + oname), (Throwable)e);
                continue;
            }
            catch (ReflectionException e) {
                LOG.error((Object)("Problem while trying to process JMX query: " + qry + " with MBean " + oname), (Throwable)e);
                continue;
            }
            jg.writeStartObject();
            jg.writeStringField("name", oname.toString());
            jg.writeStringField("modelerType", code);
            if (attribute != null && attributeinfo == null) {
                jg.writeStringField("result", "ERROR");
                jg.writeStringField("message", "No attribute with name " + attribute + " was found.");
                jg.writeEndObject();
                jg.writeEndArray();
                jg.close();
                response.setStatus(404);
                return;
            }
            if (attribute != null) {
                this.writeAttribute(jg, attribute, attributeinfo);
            } else {
                MBeanAttributeInfo[] attrs = minfo.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    this.writeAttribute(jg, oname, attrs[i]);
                }
            }
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    private void writeAttribute(JsonGenerator jg, ObjectName oname, MBeanAttributeInfo attr) throws IOException {
        if (!attr.isReadable()) {
            return;
        }
        String attName = attr.getName();
        if ("modelerType".equals(attName)) {
            return;
        }
        if (attName.indexOf("=") >= 0 || attName.indexOf(":") >= 0 || attName.indexOf(" ") >= 0) {
            return;
        }
        Object value = null;
        try {
            value = this.mBeanServer.getAttribute(oname, attName);
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() instanceof UnsupportedOperationException) {
                LOG.debug((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            } else {
                LOG.error((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            }
            return;
        }
        catch (RuntimeErrorException e) {
            LOG.debug((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            return;
        }
        catch (AttributeNotFoundException e) {
            return;
        }
        catch (MBeanException e) {
            LOG.error((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            return;
        }
        catch (RuntimeException e) {
            LOG.error((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            return;
        }
        catch (ReflectionException e) {
            LOG.error((Object)("getting attribute " + attName + " of " + oname + " threw an exception"), (Throwable)e);
            return;
        }
        catch (InstanceNotFoundException e) {
            return;
        }
        this.writeAttribute(jg, attName, value);
    }

    private void writeAttribute(JsonGenerator jg, String attName, Object value) throws IOException {
        jg.writeFieldName(attName);
        this.writeObject(jg, value);
    }

    private void writeObject(JsonGenerator jg, Object value) throws IOException {
        if (value == null) {
            jg.writeNull();
        } else {
            Class<?> c = value.getClass();
            if (c.isArray()) {
                jg.writeStartArray();
                int len = Array.getLength(value);
                for (int j = 0; j < len; ++j) {
                    Object item = Array.get(value, j);
                    this.writeObject(jg, item);
                }
                jg.writeEndArray();
            } else if (value instanceof Number) {
                Number n = (Number)value;
                jg.writeNumber(n.toString());
            } else if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                jg.writeBoolean(b);
            } else if (value instanceof CompositeData) {
                CompositeData cds = (CompositeData)value;
                CompositeType comp = cds.getCompositeType();
                Set<String> keys = comp.keySet();
                jg.writeStartObject();
                for (String key : keys) {
                    this.writeAttribute(jg, key, cds.get(key));
                }
                jg.writeEndObject();
            } else if (value instanceof TabularData) {
                TabularData tds = (TabularData)value;
                jg.writeStartArray();
                for (Object entry : tds.values()) {
                    this.writeObject(jg, entry);
                }
                jg.writeEndArray();
            } else {
                jg.writeString(value.toString());
            }
        }
    }
}

