/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.com.google.common.collect;

import javax.annotation.Nullable;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.BstNode;

@GwtCompatible
abstract class BstPath<N extends BstNode<?, N>, P extends BstPath<N, P>> {
    private final N tip;
    @Nullable
    private final P prefix;

    BstPath(N tip, @Nullable P prefix) {
        this.tip = (BstNode)Preconditions.checkNotNull(tip);
        this.prefix = prefix;
    }

    public final N getTip() {
        return this.tip;
    }

    public final boolean hasPrefix() {
        return this.prefix != null;
    }

    @Nullable
    public final P prefixOrNull() {
        return this.prefix;
    }

    public final P getPrefix() {
        Preconditions.checkState(this.hasPrefix());
        return this.prefix;
    }
}

