/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import sun.misc.Unsafe;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="If exception, presume unaligned")
public final class UnsafeAccess {
    private static final Log LOG = LogFactory.getLog(UnsafeAccess.class);
    public static final Unsafe theUnsafe;
    public static final int BYTE_ARRAY_BASE_OFFSET;
    private static boolean unaligned;
    public static final boolean littleEndian;

    private UnsafeAccess() {
    }

    public static boolean isAvailable() {
        return theUnsafe != null;
    }

    public static boolean unaligned() {
        return unaligned;
    }

    static {
        unaligned = false;
        theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field f = Unsafe.class.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    return f.get(null);
                }
                catch (Throwable e) {
                    LOG.warn((Object)"sun.misc.Unsafe is not accessible", e);
                    return null;
                }
            }
        });
        if (theUnsafe != null) {
            BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
            try {
                Class<?> clazz = Class.forName("java.nio.Bits");
                Method m = clazz.getDeclaredMethod("unaligned", new Class[0]);
                m.setAccessible(true);
                unaligned = (Boolean)m.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                unaligned = false;
            }
        } else {
            BYTE_ARRAY_BASE_OFFSET = -1;
        }
        littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
    }
}

