/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public abstract class ZooKeeperNodeTracker
extends ZooKeeperListener {
    static final Log LOG = LogFactory.getLog(ZooKeeperNodeTracker.class);
    protected final String node;
    private byte[] data;
    protected final Abortable abortable;
    private boolean stopped = false;

    public ZooKeeperNodeTracker(ZooKeeperWatcher watcher, String node, Abortable abortable) {
        super(watcher);
        this.node = node;
        this.abortable = abortable;
        this.data = null;
    }

    public synchronized void start() {
        this.watcher.registerListener(this);
        try {
            if (ZKUtil.watchAndCheckExists(this.watcher, this.node)) {
                byte[] data = ZKUtil.getDataAndWatch(this.watcher, this.node);
                if (data != null) {
                    this.data = data;
                } else {
                    LOG.debug((Object)("Try starting again because there is no data from " + this.node));
                    this.start();
                }
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Unexpected exception during initialization, aborting", e);
        }
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public synchronized byte[] blockUntilAvailable() throws InterruptedException {
        return this.blockUntilAvailable(0L, false);
    }

    public synchronized byte[] blockUntilAvailable(long timeout, boolean refresh) throws InterruptedException {
        boolean nodeExistsChecked;
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        boolean notimeout = timeout == 0L;
        long startTime = System.currentTimeMillis();
        long remaining = timeout;
        if (refresh) {
            try {
                this.data = ZKUtil.getDataAndWatch(this.watcher, this.node);
            }
            catch (KeeperException e) {
                LOG.warn((Object)"Unexpected exception handling blockUntilAvailable", (Throwable)e);
                this.abortable.abort("Unexpected exception handling blockUntilAvailable", e);
            }
        }
        boolean bl = nodeExistsChecked = !refresh || this.data != null;
        while (!this.stopped && (notimeout || remaining > 0L) && this.data == null) {
            if (!nodeExistsChecked) {
                try {
                    nodeExistsChecked = ZKUtil.checkExists(this.watcher, this.node) != -1;
                }
                catch (KeeperException e) {
                    LOG.warn((Object)("Got exception while trying to check existence in  ZooKeeper of the node: " + this.node + ", retrying if timeout not reached"), (Throwable)e);
                }
                if (nodeExistsChecked) {
                    LOG.debug((Object)("Node " + this.node + " now exists, resetting a watcher"));
                    try {
                        this.data = ZKUtil.getDataAndWatch(this.watcher, this.node);
                    }
                    catch (KeeperException e) {
                        LOG.warn((Object)"Unexpected exception handling blockUntilAvailable", (Throwable)e);
                        this.abortable.abort("Unexpected exception handling blockUntilAvailable", e);
                    }
                }
            }
            this.wait(100L);
            remaining = timeout - (System.currentTimeMillis() - startTime);
        }
        return this.data;
    }

    public synchronized byte[] getData(boolean refresh) {
        if (refresh) {
            try {
                this.data = ZKUtil.getDataAndWatch(this.watcher, this.node);
            }
            catch (KeeperException e) {
                this.abortable.abort("Unexpected exception handling getData", e);
            }
        }
        return this.data;
    }

    public String getNode() {
        return this.node;
    }

    @Override
    public synchronized void nodeCreated(String path) {
        if (!path.equals(this.node)) {
            return;
        }
        try {
            byte[] data = ZKUtil.getDataAndWatch(this.watcher, this.node);
            if (data != null) {
                this.data = data;
                this.notifyAll();
            } else {
                this.nodeDeleted(path);
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Unexpected exception handling nodeCreated event", e);
        }
    }

    @Override
    public synchronized void nodeDeleted(String path) {
        if (path.equals(this.node)) {
            try {
                if (ZKUtil.watchAndCheckExists(this.watcher, this.node)) {
                    this.nodeCreated(path);
                } else {
                    this.data = null;
                }
            }
            catch (KeeperException e) {
                this.abortable.abort("Unexpected exception handling nodeDeleted event", e);
            }
        }
    }

    @Override
    public synchronized void nodeDataChanged(String path) {
        if (path.equals(this.node)) {
            this.nodeCreated(path);
        }
    }

    public boolean checkIfBaseNodeAvailable() {
        try {
            if (ZKUtil.checkExists(this.watcher, this.watcher.baseZNode) == -1) {
                return false;
            }
        }
        catch (KeeperException e) {
            this.abortable.abort("Exception while checking if basenode (" + this.watcher.baseZNode + ") exists in ZooKeeper.", e);
        }
        return true;
    }

    public String toString() {
        return "ZooKeeperNodeTracker{node='" + this.node + ", stopped=" + this.stopped + '}';
    }
}

