/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;

@InterfaceAudience.Public
@InterfaceStability.Stable
public enum XAttrCodec {
    TEXT,
    HEX,
    BASE64;

    private static final String HEX_PREFIX = "0x";
    private static final String BASE64_PREFIX = "0s";
    private static final Base64 base64;

    public static byte[] decodeValue(String value) throws IOException {
        byte[] result = null;
        if (value != null) {
            if (value.length() >= 2) {
                String en = value.substring(0, 2);
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                    result = value.getBytes("utf-8");
                } else if (en.equalsIgnoreCase(HEX_PREFIX)) {
                    value = value.substring(2, value.length());
                    try {
                        result = Hex.decodeHex(value.toCharArray());
                    }
                    catch (DecoderException e) {
                        throw new IOException(e);
                    }
                } else if (en.equalsIgnoreCase(BASE64_PREFIX)) {
                    value = value.substring(2, value.length());
                    result = base64.decode(value);
                }
            }
            if (result == null) {
                result = value.getBytes("utf-8");
            }
        }
        return result;
    }

    public static String encodeValue(byte[] value, XAttrCodec encoding) throws IOException {
        Preconditions.checkNotNull(value, "Value can not be null.");
        if (encoding == HEX) {
            return HEX_PREFIX + Hex.encodeHexString(value);
        }
        if (encoding == BASE64) {
            return BASE64_PREFIX + base64.encodeToString(value);
        }
        return "\"" + new String(value, "utf-8") + "\"";
    }

    static {
        base64 = new Base64(0);
    }
}

