/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Map;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.MapUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class SnapshotDescription {
    private final String name;
    private final TableName table;
    private final SnapshotType snapShotType;
    private final String owner;
    private final long creationTime;
    private final long ttl;
    private final int version;
    private final long maxFileSize;

    public SnapshotDescription(String name) {
        this(name, null);
    }

    public SnapshotDescription(String name, TableName table) {
        this(name, table, SnapshotType.DISABLED, null, -1L, -1, null);
    }

    public SnapshotDescription(String name, TableName table, SnapshotType type) {
        this(name, table, type, null, -1L, -1, null);
    }

    public SnapshotDescription(String name, TableName table, SnapshotType type, String owner) {
        this(name, table, type, owner, -1L, -1, null);
    }

    @Deprecated
    public SnapshotDescription(String name, TableName table, SnapshotType type, String owner, long creationTime, int version) {
        this(name, table, type, owner, creationTime, version, null);
    }

    public SnapshotDescription(String name, TableName table, SnapshotType type, String owner, long creationTime, int version, Map<String, Object> snapshotProps) {
        this.name = name;
        this.table = table;
        this.snapShotType = type;
        this.owner = owner;
        this.creationTime = creationTime;
        this.ttl = this.getLongFromSnapshotProps(snapshotProps, "TTL");
        this.version = version;
        this.maxFileSize = this.getLongFromSnapshotProps(snapshotProps, "MAX_FILESIZE");
    }

    private long getLongFromSnapshotProps(Map<String, Object> snapshotProps, String property) {
        return MapUtils.getLongValue(snapshotProps, property, -1L);
    }

    public SnapshotDescription(String snapshotName, TableName tableName, SnapshotType type, Map<String, Object> snapshotProps) {
        this(snapshotName, tableName, type, null, -1L, -1, snapshotProps);
    }

    public String getName() {
        return this.name;
    }

    public String getTableNameAsString() {
        return this.table.getNameAsString();
    }

    public TableName getTableName() {
        return this.table;
    }

    public SnapshotType getType() {
        return this.snapShotType;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getTtl() {
        return this.ttl;
    }

    public int getVersion() {
        return this.version;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).append("table", this.table).append("snapShotType", (Object)this.snapShotType).append("owner", this.owner).append("creationTime", this.creationTime).append("ttl", this.ttl).append("version", this.version).append("maxFileSize", this.maxFileSize).toString();
    }
}

