/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.namespace.QName;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.model.ColumnSchemaModel;
import org.apache.hadoop.hbase.rest.model.TableSchemaModel;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SchemaResource
extends ResourceBase {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaResource.class);
    static CacheControl cacheControl = new CacheControl();
    TableResource tableResource;

    public SchemaResource(TableResource tableResource) throws IOException {
        this.tableResource = tableResource;
    }

    private HTableDescriptor getTableSchema() throws IOException, TableNotFoundException {
        try (Table table = this.servlet.getTable(this.tableResource.getName());){
            HTableDescriptor hTableDescriptor = table.getTableDescriptor();
            return hTableDescriptor;
        }
    }

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("GET " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            Response.ResponseBuilder response = Response.ok((Object)new TableSchemaModel(this.getTableSchema()));
            response.cacheControl(cacheControl);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return this.processException(e);
        }
    }

    private Response replace(TableName name, TableSchemaModel model, UriInfo uriInfo, Admin admin) {
        if (this.servlet.isReadOnly()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        try {
            HTableDescriptor htd = new HTableDescriptor(name);
            for (Map.Entry<QName, Object> e : model.getAny().entrySet()) {
                htd.setValue(e.getKey().getLocalPart(), e.getValue().toString());
            }
            for (ColumnSchemaModel family : model.getColumns()) {
                HColumnDescriptor hcd = new HColumnDescriptor(family.getName());
                for (Map.Entry<QName, Object> e : family.getAny().entrySet()) {
                    hcd.setValue(e.getKey().getLocalPart(), e.getValue().toString());
                }
                htd.addFamily(hcd);
            }
            if (admin.tableExists(name)) {
                admin.disableTable(name);
                admin.modifyTable(name, (TableDescriptor)htd);
                admin.enableTable(name);
                this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            } else {
                try {
                    admin.createTable((TableDescriptor)htd);
                    this.servlet.getMetrics().incrementSucessfulPutRequests(1);
                }
                catch (TableExistsException e) {
                    return Response.status((Response.Status)Response.Status.NOT_MODIFIED).type("text/plain").entity((Object)"Not modified\r\n").build();
                }
            }
            return Response.created((URI)uriInfo.getAbsolutePath()).build();
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return this.processException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response update(TableName name, TableSchemaModel model, UriInfo uriInfo, Admin admin) {
        if (this.servlet.isReadOnly()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        try {
            HTableDescriptor htd = admin.getTableDescriptor(name);
            admin.disableTable(name);
            try {
                for (ColumnSchemaModel family : model.getColumns()) {
                    HColumnDescriptor hcd = new HColumnDescriptor(family.getName());
                    for (Map.Entry<QName, Object> e : family.getAny().entrySet()) {
                        hcd.setValue(e.getKey().getLocalPart(), e.getValue().toString());
                    }
                    if (htd.hasFamily(hcd.getName())) {
                        admin.modifyColumnFamily(name, (ColumnFamilyDescriptor)hcd);
                        continue;
                    }
                    admin.addColumnFamily(name, (ColumnFamilyDescriptor)hcd);
                }
            }
            catch (IOException e) {
                Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
                return response;
            }
            finally {
                admin.enableTable(TableName.valueOf((String)this.tableResource.getName()));
            }
            this.servlet.getMetrics().incrementSucessfulPutRequests(1);
            return Response.ok().build();
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return this.processException(e);
        }
    }

    private Response update(TableSchemaModel model, boolean replace, UriInfo uriInfo) {
        try {
            TableName name = TableName.valueOf((String)this.tableResource.getName());
            Admin admin = this.servlet.getAdmin();
            if (replace || !admin.tableExists(name)) {
                return this.replace(name, model, uriInfo, admin);
            }
            return this.update(name, model, uriInfo, admin);
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedPutRequests(1);
            return this.processException(e);
        }
    }

    @PUT
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response put(TableSchemaModel model, @Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("PUT " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        return this.update(model, true, uriInfo);
    }

    @POST
    @Consumes(value={"text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response post(TableSchemaModel model, @Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("PUT " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        return this.update(model, false, uriInfo);
    }

    @DELETE
    @SuppressWarnings(value={"DE_MIGHT_IGNORE"}, justification="Expected")
    public Response delete(@Context UriInfo uriInfo) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("DELETE " + uriInfo.getAbsolutePath());
        }
        this.servlet.getMetrics().incrementRequests(1);
        if (this.servlet.isReadOnly()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).type("text/plain").entity((Object)"Forbidden\r\n").build();
        }
        try {
            Admin admin = this.servlet.getAdmin();
            try {
                admin.disableTable(TableName.valueOf((String)this.tableResource.getName()));
            }
            catch (TableNotEnabledException tableNotEnabledException) {
                // empty catch block
            }
            admin.deleteTable(TableName.valueOf((String)this.tableResource.getName()));
            this.servlet.getMetrics().incrementSucessfulDeleteRequests(1);
            return Response.ok().build();
        }
        catch (Exception e) {
            this.servlet.getMetrics().incrementFailedDeleteRequests(1);
            return this.processException(e);
        }
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

