/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.CoprocessorDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorageType;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.TableReplicationQueueStorage;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ReplicationStorageFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationStorageFactory.class);
    public static final String REPLICATION_PEER_STORAGE_IMPL = "hbase.replication.peer.storage.impl";
    public static final ReplicationPeerStorageType DEFAULT_REPLICATION_PEER_STORAGE_IMPL = ReplicationPeerStorageType.ZOOKEEPER;
    public static final String REPLICATION_QUEUE_TABLE_NAME = "hbase.replication.queue.table.name";
    public static final TableName REPLICATION_QUEUE_TABLE_NAME_DEFAULT = TableName.valueOf((String)NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR, (String)"replication");
    public static final String REPLICATION_QUEUE_IMPL = "hbase.replication.queue.storage.impl";

    public static TableDescriptor createReplicationQueueTableDescriptor(TableName tableName) throws IOException {
        return TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])TableReplicationQueueStorage.QUEUE_FAMILY)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])TableReplicationQueueStorage.LAST_SEQUENCE_ID_FAMILY)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])TableReplicationQueueStorage.HFILE_REF_FAMILY)).setValue("hbase.regionserver.region.split_restriction.type", "DelimitedKeyPrefix").setValue("hbase.regionserver.region.split_restriction.delimiter", "-").setCoprocessor(CoprocessorDescriptorBuilder.newBuilder((String)"org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint").setPriority(0x1FFFFFFF).build()).build();
    }

    private ReplicationStorageFactory() {
    }

    private static Class<? extends ReplicationPeerStorage> getReplicationPeerStorageClass(Configuration conf) {
        try {
            ReplicationPeerStorageType type = ReplicationPeerStorageType.valueOf(conf.get(REPLICATION_PEER_STORAGE_IMPL, DEFAULT_REPLICATION_PEER_STORAGE_IMPL.name()).toUpperCase());
            return type.getClazz();
        }
        catch (IllegalArgumentException e) {
            return conf.getClass(REPLICATION_PEER_STORAGE_IMPL, DEFAULT_REPLICATION_PEER_STORAGE_IMPL.getClazz(), ReplicationPeerStorage.class);
        }
    }

    public static ReplicationPeerStorage getReplicationPeerStorage(FileSystem fs, ZKWatcher zk, Configuration conf) {
        Class<? extends ReplicationPeerStorage> clazz = ReplicationStorageFactory.getReplicationPeerStorageClass(conf);
        for (Constructor<?> c : clazz.getConstructors()) {
            if (c.getParameterCount() != 2) continue;
            if (c.getParameterTypes()[0].isAssignableFrom(FileSystem.class)) {
                return (ReplicationPeerStorage)ReflectionUtils.newInstance(clazz, (Object[])new Object[]{fs, conf});
            }
            if (!c.getParameterTypes()[0].isAssignableFrom(ZKWatcher.class)) continue;
            return (ReplicationPeerStorage)ReflectionUtils.newInstance(clazz, (Object[])new Object[]{zk, conf});
        }
        throw new IllegalArgumentException("Can not create replication peer storage with type " + clazz);
    }

    public static ReplicationQueueStorage getReplicationQueueStorage(Connection conn, Configuration conf) {
        return ReplicationStorageFactory.getReplicationQueueStorage(conn, conf, TableName.valueOf((String)conf.get(REPLICATION_QUEUE_TABLE_NAME, REPLICATION_QUEUE_TABLE_NAME_DEFAULT.getNameAsString())));
    }

    public static ReplicationQueueStorage getReplicationQueueStorage(Connection conn, Configuration conf, TableName tableName) {
        Class clazz = conf.getClass(REPLICATION_QUEUE_IMPL, TableReplicationQueueStorage.class, ReplicationQueueStorage.class);
        try {
            Constructor c = clazz.getConstructor(Connection.class, TableName.class);
            return (ReplicationQueueStorage)c.newInstance(conn, tableName);
        }
        catch (Exception e) {
            LOG.debug("failed to create ReplicationQueueStorage with Connection, try creating with Configuration", (Throwable)e);
            return (ReplicationQueueStorage)ReflectionUtils.newInstance((Class)clazz, (Object[])new Object[]{conf, tableName});
        }
    }

    public static boolean isReplicationQueueTable(Configuration conf, TableName tableName) {
        TableName replicationQueueTableName = TableName.valueOf((String)conf.get(REPLICATION_QUEUE_TABLE_NAME, REPLICATION_QUEUE_TABLE_NAME_DEFAULT.getNameAsString()));
        return replicationQueueTableName.equals((Object)tableName);
    }
}

