/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.replication.ReplicationListener;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.replication.ReplicationTracker;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ReplicationTrackerZKImpl
extends ReplicationStateZKBase
implements ReplicationTracker {
    private static final Log LOG = LogFactory.getLog(ReplicationTrackerZKImpl.class);
    private final Stoppable stopper;
    private final List<ReplicationListener> listeners = new CopyOnWriteArrayList<ReplicationListener>();
    private final ArrayList<String> otherRegionServers = new ArrayList();
    private final ReplicationPeers replicationPeers;

    public ReplicationTrackerZKImpl(ZooKeeperWatcher zookeeper, ReplicationPeers replicationPeers, Configuration conf, Abortable abortable, Stoppable stopper) {
        super(zookeeper, conf, abortable);
        this.replicationPeers = replicationPeers;
        this.stopper = stopper;
        this.zookeeper.registerListener((ZooKeeperListener)new OtherRegionServerWatcher(this.zookeeper));
        this.zookeeper.registerListener((ZooKeeperListener)new PeersWatcher(this.zookeeper));
    }

    @Override
    public void registerListener(ReplicationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ReplicationListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getListOfRegionServers() {
        this.refreshOtherRegionServersList();
        ArrayList<String> list = null;
        ArrayList<String> arrayList = this.otherRegionServers;
        synchronized (arrayList) {
            list = new ArrayList<String>(this.otherRegionServers);
        }
        return list;
    }

    private List<String> refreshPeersList(String path) {
        if (!path.startsWith(this.getPeersZNode())) {
            return null;
        }
        return this.replicationPeers.getAllPeerIds();
    }

    private String getPeersZNode() {
        return this.peersZNode;
    }

    private String getZNodeName(String fullPath) {
        String[] parts = fullPath.split("/");
        return parts.length > 0 ? parts[parts.length - 1] : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshOtherRegionServersList() {
        List<String> newRsList = this.getRegisteredRegionServers();
        if (newRsList == null) {
            return false;
        }
        ArrayList<String> arrayList = this.otherRegionServers;
        synchronized (arrayList) {
            this.otherRegionServers.clear();
            this.otherRegionServers.addAll(newRsList);
        }
        return true;
    }

    private List<String> getRegisteredRegionServers() {
        List result = null;
        try {
            result = ZKUtil.listChildrenAndWatchThem((ZooKeeperWatcher)this.zookeeper, (String)this.zookeeper.znodePaths.rsZNode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Get list of registered region servers", (Throwable)e);
        }
        return result;
    }

    public class PeersWatcher
    extends ZooKeeperListener {
        public PeersWatcher(ZooKeeperWatcher watcher) {
            super(watcher);
        }

        public void nodeDeleted(String path) {
            List peers = ReplicationTrackerZKImpl.this.refreshPeersList(path);
            if (peers == null) {
                return;
            }
            if (ReplicationTrackerZKImpl.this.isPeerPath(path)) {
                String id = ReplicationTrackerZKImpl.this.getZNodeName(path);
                LOG.info((Object)(path + " znode expired, triggering peerRemoved event"));
                for (ReplicationListener rl : ReplicationTrackerZKImpl.this.listeners) {
                    rl.peerRemoved(id);
                }
            }
        }

        public void nodeChildrenChanged(String path) {
            List peers = ReplicationTrackerZKImpl.this.refreshPeersList(path);
            if (peers == null) {
                return;
            }
            LOG.info((Object)(path + " znode expired, triggering peerListChanged event"));
            for (ReplicationListener rl : ReplicationTrackerZKImpl.this.listeners) {
                rl.peerListChanged(peers);
            }
        }
    }

    public class OtherRegionServerWatcher
    extends ZooKeeperListener {
        public OtherRegionServerWatcher(ZooKeeperWatcher watcher) {
            super(watcher);
        }

        public void nodeCreated(String path) {
            this.refreshListIfRightPath(path);
        }

        public void nodeDeleted(String path) {
            if (ReplicationTrackerZKImpl.this.stopper.isStopped()) {
                return;
            }
            boolean cont = this.refreshListIfRightPath(path);
            if (!cont) {
                return;
            }
            LOG.info((Object)(path + " znode expired, triggering replicatorRemoved event"));
            for (ReplicationListener rl : ReplicationTrackerZKImpl.this.listeners) {
                rl.regionServerRemoved(ReplicationTrackerZKImpl.this.getZNodeName(path));
            }
        }

        public void nodeChildrenChanged(String path) {
            if (ReplicationTrackerZKImpl.this.stopper.isStopped()) {
                return;
            }
            this.refreshListIfRightPath(path);
        }

        private boolean refreshListIfRightPath(String path) {
            if (!path.startsWith(this.watcher.znodePaths.rsZNode)) {
                return false;
            }
            return ReplicationTrackerZKImpl.this.refreshOtherRegionServersList();
        }
    }
}

