/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.vint;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.nio.ByteBuff;

@InterfaceAudience.Private
public class UVIntTool {
    public static final byte BYTE_7_RIGHT_BITS_SET = 127;
    public static final byte BYTE_LEFT_BIT_SET = -128;
    public static final long INT_7_RIGHT_BITS_SET = 127L;
    public static final long INT_8TH_BIT_SET = 128L;
    public static final byte[] MAX_VALUE_BYTES = new byte[]{-1, -1, -1, -1, 7};

    public static int numBytes(int in) {
        if (in == 0) {
            return 1;
        }
        return (38 - Integer.numberOfLeadingZeros(in)) / 7;
    }

    public static byte[] getBytes(int value) {
        int numBytes = UVIntTool.numBytes(value);
        byte[] bytes = new byte[numBytes];
        int remainder = value;
        for (int i = 0; i < numBytes - 1; ++i) {
            bytes[i] = (byte)((long)remainder & 0x7FL | 0x80L);
            remainder >>= 7;
        }
        bytes[numBytes - 1] = (byte)((long)remainder & 0x7FL);
        return bytes;
    }

    public static int writeBytes(int value, OutputStream os) throws IOException {
        int numBytes = UVIntTool.numBytes(value);
        int remainder = value;
        for (int i = 0; i < numBytes - 1; ++i) {
            os.write((byte)((long)remainder & 0x7FL | 0x80L));
            remainder >>= 7;
        }
        os.write((byte)((long)remainder & 0x7FL));
        return numBytes;
    }

    public static int getInt(ByteBuff buffer, int offset) {
        int value = 0;
        int i = 0;
        while (true) {
            byte b = buffer.get(offset + i);
            int shifted = 0x7F & b;
            value |= (shifted <<= 7 * i);
            if (b >= 0) break;
            ++i;
        }
        return value;
    }

    public static int getInt(InputStream is) throws IOException {
        int b;
        int value = 0;
        int i = 0;
        do {
            b = is.read();
            int shifted = 0x7F & b;
            value |= (shifted <<= 7 * i);
            ++i;
        } while (b > 127);
        return value;
    }
}

