/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.decode.ArraySearcherPool;
import org.apache.hadoop.hbase.codec.prefixtree.decode.PrefixTreeArraySearcher;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellSearcher;
import org.apache.hadoop.hbase.nio.ByteBuff;

@InterfaceAudience.Private
public class DecoderFactory {
    private static final ArraySearcherPool POOL = new ArraySearcherPool();

    public static PrefixTreeArraySearcher checkOut(ByteBuff buffer, boolean includeMvccVersion) {
        PrefixTreeArraySearcher searcher = POOL.checkOut(buffer, includeMvccVersion);
        return searcher;
    }

    public static void checkIn(CellSearcher pSearcher) {
        if (pSearcher == null) {
            return;
        }
        if (!(pSearcher instanceof PrefixTreeArraySearcher)) {
            throw new IllegalArgumentException("Cannot return " + pSearcher.getClass() + " to " + DecoderFactory.class);
        }
        PrefixTreeArraySearcher searcher = (PrefixTreeArraySearcher)pSearcher;
        POOL.checkIn(searcher);
    }

    public static PrefixTreeArraySearcher ensureArraySearcherValid(ByteBuff buffer, PrefixTreeArraySearcher searcher, boolean includeMvccVersion) {
        if (searcher == null) {
            PrefixTreeBlockMeta blockMeta = new PrefixTreeBlockMeta(buffer);
            searcher = new PrefixTreeArraySearcher(blockMeta, blockMeta.getRowTreeDepth(), blockMeta.getMaxRowLength(), blockMeta.getMaxQualifierLength(), blockMeta.getMaxTagsLength());
            searcher.initOnBlock(blockMeta, buffer, includeMvccVersion);
            return searcher;
        }
        PrefixTreeBlockMeta blockMeta = searcher.getBlockMeta();
        blockMeta.initOnBlock(buffer);
        if (!searcher.areBuffersBigEnough()) {
            int maxRowTreeStackNodes = Math.max(blockMeta.getRowTreeDepth(), searcher.getMaxRowTreeStackNodes());
            int rowBufferLength = Math.max(blockMeta.getMaxRowLength(), searcher.getRowBufferLength());
            int qualifierBufferLength = Math.max(blockMeta.getMaxQualifierLength(), searcher.getQualifierBufferLength());
            int tagBufferLength = Math.max(blockMeta.getMaxTagsLength(), searcher.getTagBufferLength());
            searcher = new PrefixTreeArraySearcher(blockMeta, maxRowTreeStackNodes, rowBufferLength, qualifierBufferLength, tagBufferLength);
        }
        searcher.initOnBlock(blockMeta, buffer, includeMvccVersion);
        return searcher;
    }
}

