/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeSeeker;
import org.apache.hadoop.hbase.codec.prefixtree.decode.DecoderFactory;
import org.apache.hadoop.hbase.codec.prefixtree.decode.PrefixTreeArraySearcher;
import org.apache.hadoop.hbase.codec.prefixtree.encode.EncoderFactory;
import org.apache.hadoop.hbase.codec.prefixtree.encode.PrefixTreeEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.EncodingState;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class PrefixTreeCodec
implements DataBlockEncoder {
    public ByteBuffer decodeKeyValues(DataInputStream source, HFileBlockDecodingContext decodingCtx) throws IOException {
        return this.decodeKeyValues(source, 0, 0, decodingCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer decodeKeyValues(DataInputStream source, int allocateHeaderLength, int skipLastBytes, HFileBlockDecodingContext decodingCtx) throws IOException {
        ByteBuffer byteBuffer;
        ByteBuffer sourceAsBuffer = ByteBufferUtils.drainInputStreamToBuffer((InputStream)source);
        sourceAsBuffer.mark();
        PrefixTreeBlockMeta blockMeta = new PrefixTreeBlockMeta((ByteBuff)new SingleByteBuff(sourceAsBuffer));
        sourceAsBuffer.rewind();
        int numV1BytesWithHeader = allocateHeaderLength + blockMeta.getNumKeyValueBytes();
        byte[] keyValueBytesWithHeader = new byte[numV1BytesWithHeader];
        ByteBuffer result = ByteBuffer.wrap(keyValueBytesWithHeader);
        result.rewind();
        PrefixTreeArraySearcher searcher = null;
        try {
            boolean includesMvcc = decodingCtx.getHFileContext().isIncludesMvcc();
            searcher = DecoderFactory.checkOut((ByteBuff)new SingleByteBuff(sourceAsBuffer), includesMvcc);
            while (searcher.advance()) {
                KeyValue currentCell = KeyValueUtil.copyToNewKeyValue((Cell)searcher.current());
                int offset = result.arrayOffset() + result.position();
                System.arraycopy(currentCell.getBuffer(), currentCell.getOffset(), result.array(), offset, currentCell.getLength());
                int keyValueLength = KeyValueUtil.length((Cell)currentCell);
                ByteBufferUtils.skip((ByteBuffer)result, (int)keyValueLength);
                offset += keyValueLength;
                if (!includesMvcc) continue;
                ByteBufferUtils.writeVLong((ByteBuffer)result, (long)currentCell.getSequenceId());
            }
            result.position(result.limit());
            byteBuffer = result;
        }
        catch (Throwable throwable) {
            DecoderFactory.checkIn(searcher);
            throw throwable;
        }
        DecoderFactory.checkIn(searcher);
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cell getFirstKeyCellInBlock(ByteBuff block) {
        block.rewind();
        PrefixTreeArraySearcher searcher = null;
        try {
            searcher = DecoderFactory.checkOut(block, true);
            if (!searcher.positionAtFirstCell()) {
                Cell cell = null;
                return cell;
            }
            Cell cell = searcher.current();
            return cell;
        }
        finally {
            DecoderFactory.checkIn(searcher);
        }
    }

    public HFileBlockEncodingContext newDataBlockEncodingContext(DataBlockEncoding encoding, byte[] header, HFileContext meta) {
        if (DataBlockEncoding.PREFIX_TREE != encoding) {
            throw new IllegalArgumentException("only DataBlockEncoding.PREFIX_TREE supported");
        }
        return new HFileBlockDefaultEncodingContext(encoding, header, meta);
    }

    public HFileBlockDecodingContext newDataBlockDecodingContext(HFileContext meta) {
        return new HFileBlockDefaultDecodingContext(meta);
    }

    public DataBlockEncoder.EncodedSeeker createSeeker(CellComparator comparator, HFileBlockDecodingContext decodingCtx) {
        if (comparator instanceof CellComparator.MetaCellComparator) {
            throw new IllegalArgumentException("DataBlockEncoding.PREFIX_TREE not compatible with hbase:meta table");
        }
        return new PrefixTreeSeeker(decodingCtx.getHFileContext().isIncludesMvcc());
    }

    public int encode(Cell cell, HFileBlockEncodingContext encodingCtx, DataOutputStream out) throws IOException {
        PrefixTreeEncodingState state = (PrefixTreeEncodingState)encodingCtx.getEncodingState();
        PrefixTreeEncoder builder = state.builder;
        builder.write(cell);
        int size = KeyValueUtil.length((Cell)cell);
        if (encodingCtx.getHFileContext().isIncludesMvcc()) {
            size += WritableUtils.getVIntSize((long)cell.getSequenceId());
        }
        return size;
    }

    public void startBlockEncoding(HFileBlockEncodingContext blkEncodingCtx, DataOutputStream out) throws IOException {
        if (blkEncodingCtx.getClass() != HFileBlockDefaultEncodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + " as the encoding context.");
        }
        HFileBlockDefaultEncodingContext encodingCtx = (HFileBlockDefaultEncodingContext)blkEncodingCtx;
        encodingCtx.prepareEncoding(out);
        PrefixTreeEncoder builder = EncoderFactory.checkOut(out, encodingCtx.getHFileContext().isIncludesMvcc());
        PrefixTreeEncodingState state = new PrefixTreeEncodingState();
        state.builder = builder;
        blkEncodingCtx.setEncodingState((EncodingState)state);
    }

    public void endBlockEncoding(HFileBlockEncodingContext encodingCtx, DataOutputStream out, byte[] uncompressedBytesWithHeader) throws IOException {
        PrefixTreeEncodingState state = (PrefixTreeEncodingState)encodingCtx.getEncodingState();
        PrefixTreeEncoder builder = state.builder;
        builder.flush();
        EncoderFactory.checkIn(builder);
        if (encodingCtx.getDataBlockEncoding() != DataBlockEncoding.NONE) {
            encodingCtx.postEncoding(BlockType.ENCODED_DATA);
        } else {
            encodingCtx.postEncoding(BlockType.DATA);
        }
    }

    private static class PrefixTreeEncodingState
    extends EncodingState {
        PrefixTreeEncoder builder = null;

        private PrefixTreeEncodingState() {
        }
    }
}

