/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.encode.column;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.encode.column.ColumnNodeWriter;
import org.apache.hadoop.hbase.codec.prefixtree.encode.other.ColumnNodeType;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.Tokenizer;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.TokenizerNode;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.util.vint.UFIntTool;

@InterfaceAudience.Private
public class ColumnSectionWriter {
    public static final int EXPECTED_NUBS_PLUS_LEAVES = 100;
    private PrefixTreeBlockMeta blockMeta;
    private ColumnNodeType nodeType;
    private Tokenizer tokenizer;
    private int numBytes = 0;
    private ArrayList<TokenizerNode> nonLeaves = Lists.newArrayList();
    private ArrayList<TokenizerNode> leaves = Lists.newArrayList();
    private ArrayList<TokenizerNode> allNodes;
    private ArrayList<ColumnNodeWriter> columnNodeWriters;
    private List<Integer> outputArrayOffsets = Lists.newArrayList();

    public ColumnSectionWriter() {
    }

    public ColumnSectionWriter(PrefixTreeBlockMeta blockMeta, Tokenizer builder, ColumnNodeType nodeType) {
        this();
        this.reconstruct(blockMeta, builder, nodeType);
    }

    public void reconstruct(PrefixTreeBlockMeta blockMeta, Tokenizer builder, ColumnNodeType nodeType) {
        this.blockMeta = blockMeta;
        this.tokenizer = builder;
        this.nodeType = nodeType;
    }

    public void reset() {
        this.numBytes = 0;
        this.nonLeaves.clear();
        this.leaves.clear();
        this.outputArrayOffsets.clear();
    }

    public ColumnSectionWriter compile() {
        if (this.nodeType != ColumnNodeType.FAMILY) {
            if (this.nodeType == ColumnNodeType.QUALIFIER) {
                this.blockMeta.setMaxQualifierLength(this.tokenizer.getMaxElementLength());
            } else {
                this.blockMeta.setMaxTagsLength(this.tokenizer.getMaxElementLength());
            }
        }
        this.compilerInternals();
        return this;
    }

    protected void compilerInternals() {
        int numBytesFinder;
        this.tokenizer.setNodeFirstInsertionIndexes();
        this.tokenizer.appendNodes(this.nonLeaves, true, false);
        this.tokenizer.appendNodes(this.leaves, false, true);
        this.allNodes = Lists.newArrayListWithCapacity((int)(this.nonLeaves.size() + this.leaves.size()));
        this.allNodes.addAll(this.nonLeaves);
        this.allNodes.addAll(this.leaves);
        this.columnNodeWriters = Lists.newArrayListWithCapacity((int)CollectionUtils.nullSafeSize(this.allNodes));
        for (int i = 0; i < this.allNodes.size(); ++i) {
            TokenizerNode node = this.allNodes.get(i);
            this.columnNodeWriters.add(new ColumnNodeWriter(this.blockMeta, node, this.nodeType));
        }
        int totalBytesWithoutOffsets = 0;
        for (int i = this.allNodes.size() - 1; i >= 0; --i) {
            ColumnNodeWriter columnNodeWriter = this.columnNodeWriters.get(i);
            totalBytesWithoutOffsets += columnNodeWriter.getWidthUsingPlaceholderForOffsetWidth(0);
        }
        int parentOffsetWidth = 0;
        while ((long)(numBytesFinder = totalBytesWithoutOffsets + ++parentOffsetWidth * this.allNodes.size()) >= UFIntTool.maxValueForNumBytes(parentOffsetWidth)) {
        }
        this.numBytes = numBytesFinder;
        if (this.nodeType == ColumnNodeType.FAMILY) {
            this.blockMeta.setFamilyOffsetWidth(parentOffsetWidth);
        } else if (this.nodeType == ColumnNodeType.QUALIFIER) {
            this.blockMeta.setQualifierOffsetWidth(parentOffsetWidth);
        } else {
            this.blockMeta.setTagsOffsetWidth(parentOffsetWidth);
        }
        int forwardIndex = 0;
        for (int i = 0; i < this.allNodes.size(); ++i) {
            TokenizerNode node = this.allNodes.get(i);
            ColumnNodeWriter columnNodeWriter = this.columnNodeWriters.get(i);
            int fullNodeWidth = columnNodeWriter.getWidthUsingPlaceholderForOffsetWidth(parentOffsetWidth);
            node.setOutputArrayOffset(forwardIndex);
            columnNodeWriter.setTokenBytes(node.getToken());
            if (node.isRoot()) {
                columnNodeWriter.setParentStartPosition(0);
            } else {
                columnNodeWriter.setParentStartPosition(node.getParent().getOutputArrayOffset());
            }
            forwardIndex += fullNodeWidth;
        }
        this.tokenizer.appendOutputArrayOffsets(this.outputArrayOffsets);
    }

    public void writeBytes(OutputStream os) throws IOException {
        for (ColumnNodeWriter columnNodeWriter : this.columnNodeWriters) {
            columnNodeWriter.writeBytes(os);
        }
    }

    public ArrayList<ColumnNodeWriter> getColumnNodeWriters() {
        return this.columnNodeWriters;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public int getOutputArrayOffset(int sortedIndex) {
        return this.outputArrayOffsets.get(sortedIndex);
    }

    public ArrayList<TokenizerNode> getNonLeaves() {
        return this.nonLeaves;
    }

    public ArrayList<TokenizerNode> getLeaves() {
        return this.leaves;
    }
}

