/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class PrefixTreeCell
implements Cell,
Comparable<Cell> {
    public static final KeyValue.Type[] TYPES = new KeyValue.Type[256];
    public static final KeyValue.Type DEFAULT_TYPE;
    protected byte[] block;
    protected boolean includeMvccVersion;
    protected byte[] rowBuffer;
    protected int rowLength;
    protected byte[] familyBuffer;
    protected int familyOffset;
    protected int familyLength;
    protected byte[] qualifierBuffer;
    protected int qualifierOffset;
    protected int qualifierLength;
    protected Long timestamp;
    protected Long mvccVersion;
    protected KeyValue.Type type;
    protected int absoluteValueOffset;
    protected int valueLength;
    protected byte[] tagsBuffer;
    protected int tagsOffset;
    protected int tagsLength;

    public String toString() {
        return this.getKeyValueString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cell)) {
            return false;
        }
        return CellComparator.equalsIgnoreMvccVersion((Cell)this, (Cell)((Cell)obj));
    }

    public int hashCode() {
        return KeyValueUtil.copyToNewKeyValue((Cell)this).hashCode();
    }

    @Override
    public int compareTo(Cell other) {
        return CellComparator.compareStatic((Cell)this, (Cell)other);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getMvccVersion() {
        if (!this.includeMvccVersion) {
            return 0L;
        }
        return this.mvccVersion;
    }

    public int getValueLength() {
        return this.valueLength;
    }

    public byte[] getRowArray() {
        return this.rowBuffer;
    }

    public int getRowOffset() {
        return 0;
    }

    public short getRowLength() {
        return (short)this.rowLength;
    }

    public byte[] getFamilyArray() {
        return this.familyBuffer;
    }

    public int getFamilyOffset() {
        return this.familyOffset;
    }

    public byte getFamilyLength() {
        return (byte)this.familyLength;
    }

    public byte[] getQualifierArray() {
        return this.qualifierBuffer;
    }

    public int getQualifierOffset() {
        return this.qualifierOffset;
    }

    public int getQualifierLength() {
        return this.qualifierLength;
    }

    public byte[] getValueArray() {
        return this.block;
    }

    public int getValueOffset() {
        return this.absoluteValueOffset;
    }

    public byte getTypeByte() {
        return this.type.getCode();
    }

    public byte[] getValue() {
        return CellUtil.cloneValue((Cell)this);
    }

    public byte[] getFamily() {
        return CellUtil.cloneFamily((Cell)this);
    }

    public byte[] getQualifier() {
        return CellUtil.cloneQualifier((Cell)this);
    }

    public byte[] getRow() {
        return CellUtil.cloneRow((Cell)this);
    }

    protected String getKeyValueString() {
        KeyValue kv = KeyValueUtil.copyToNewKeyValue((Cell)this);
        return kv.toString();
    }

    public int getTagsOffset() {
        return this.tagsOffset;
    }

    @Deprecated
    public int getTagsLengthUnsigned() {
        return this.tagsLength;
    }

    @Deprecated
    public short getTagsLength() {
        return (short)this.tagsLength;
    }

    public byte[] getTagsArray() {
        return this.tagsBuffer;
    }

    static {
        KeyValue.Type[] arr$ = KeyValue.Type.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            KeyValue.Type type;
            PrefixTreeCell.TYPES[type.getCode() & 0xFF] = type = arr$[i$];
        }
        DEFAULT_TYPE = KeyValue.Type.Put;
    }
}

